/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.CallTraceElement;
import com.bea.jvm.ThreadSnapshot;
import java.util.ArrayList;
import java.util.List;
import jrockit.mapi.CallTraceElementImpl;
import jrockit.vm.Threads;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadSnapshotImpl
implements ThreadSnapshot {
    private String name;
    private long id;
    private int state;
    private int extraState;
    private int priority;
    private List calltrace;
    private ThreadSnapshot.Monitor blockedOn;
    private ThreadSnapshot.Monitor waitingOn;
    private static int snapshotID;

    private ThreadSnapshotImpl(String string, long l, int n, int n2, int n3, List list, ThreadSnapshot.Monitor monitor, ThreadSnapshot.Monitor monitor2) {
        this.name = string;
        this.id = l;
        this.state = n;
        this.extraState = n2;
        this.priority = n3;
        this.calltrace = list;
        this.blockedOn = monitor;
        this.waitingOn = monitor2;
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        if ((this.state & 0x100000) != 0) {
            return 7;
        }
        if ((this.state & 0x400) != 0) {
            return 3;
        }
        if ((this.state & 0x80) != 0) {
            return 2;
        }
        if ((this.extraState & 0x400) != 0) {
            return 3;
        }
        if ((this.extraState & 0x80) != 0) {
            return 2;
        }
        return 0;
    }

    public int getStateBitmap() {
        return this.state;
    }

    public Thread.State getThreadState() {
        return Threads.getEnumStateFromBitmapState(this.state);
    }

    public long getID() {
        return this.id;
    }

    public boolean isDaemon() {
        return this.priority < 0;
    }

    public int getPriority() {
        return Math.abs(this.priority);
    }

    public List getStackTrace() {
        return this.calltrace;
    }

    public String getDescription() {
        return this.toString();
    }

    public String describeState() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.state == 0) {
            return "not started";
        }
        if ((this.state & 2) != 0) {
            return "terminated";
        }
        stringBuffer.append("alive");
        if ((this.state & 0x400000) != 0) {
            stringBuffer.append(", in native");
        }
        if ((this.state & 0x20000000) != 0) {
            stringBuffer.append(", in suspend critical mode");
        }
        if ((this.state & 0x100000) != 0) {
            stringBuffer.append(", suspended");
        }
        if ((this.state & 0x200000) != 0) {
            stringBuffer.append(", interrupted");
        }
        if ((this.state & 0x400) != 0) {
            stringBuffer.append(", blocked");
            if ((this.state & 0x10000000) != 0) {
                stringBuffer.append(" (on thin lock)");
            }
        } else if ((this.state & 0x80) != 0) {
            if ((this.state & 0x100) != 0) {
                stringBuffer.append(", waiting");
            } else if ((this.state & 0x40) != 0) {
                stringBuffer.append(", sleeping");
            } else {
                stringBuffer.append(", parked");
            }
        }
        if ((this.extraState & 0x80) != 0) {
            stringBuffer.append(", native_waiting");
        } else if ((this.extraState & 0x400) != 0) {
            stringBuffer.append(", native_blocked");
        }
        return stringBuffer.toString();
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        stringBuffer.append("Thread-");
        stringBuffer.append(this.getID());
        stringBuffer.append(" \"");
        stringBuffer.append(this.getName());
        stringBuffer.append('\"');
        stringBuffer.append(" <");
        stringBuffer.append(this.describeState());
        stringBuffer.append(", priority=");
        stringBuffer.append(this.getPriority());
        if (this.isDaemon()) {
            stringBuffer.append(", DAEMON");
        }
        stringBuffer.append("> {\n");
        if (this.blockedOn != null) {
            stringBuffer.append("    -- Blocked trying to get lock: ");
            stringBuffer.append(this.blockedOn);
            stringBuffer.append("\n");
        }
        if (this.waitingOn != null) {
            stringBuffer.append("    -- Waiting for notification on: ");
            stringBuffer.append(this.waitingOn);
            stringBuffer.append("\n");
        }
        for (CallTraceElement callTraceElement : this.getStackTrace()) {
            stringBuffer.append("    ");
            stringBuffer.append(callTraceElement);
            stringBuffer.append('\n');
            ThreadSnapshot.Monitor[] monitorArray = callTraceElement.getMonitors();
            if (monitorArray == null || monitorArray.length <= 0) continue;
            for (int i = 0; i < monitorArray.length; ++i) {
                if (monitorArray[i].equals(this.waitingOn)) {
                    stringBuffer.append("    ^-- Lock released while waiting: ");
                    stringBuffer.append(monitorArray[i]);
                    stringBuffer.append("\n");
                    continue;
                }
                stringBuffer.append("    ^-- Holding lock: ");
                stringBuffer.append(monitorArray[i]);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("}\n\n");
        return stringBuffer;
    }

    public String toString() {
        return this.toString(new StringBuffer(40 + this.getStackTrace().size() * 40)).toString();
    }

    static List<ThreadSnapshot> getThreadSnapshot(Thread[] threadArray) {
        final int n = ThreadSnapshotImpl.getSnapshotID();
        final ArrayList<ThreadSnapshot> arrayList = new ArrayList<ThreadSnapshot>(threadArray != null ? threadArray.length : 30);
        Threads.ThreadDumpCallback threadDumpCallback = new Threads.ThreadDumpCallback(){
            private ArrayList<CallTraceElement> trace = new ArrayList();
            private ArrayList<ThreadSnapshot.Monitor> monitors = new ArrayList();
            private ThreadSnapshotImpl current;
            private CallTraceElementImpl elem;

            public void beginThread(String string, long l, int n4, int n2, long l2, int n3, long l3, long l4, long l5, long l6) {
                this.current = new ThreadSnapshotImpl(string, l, n4, n2, n3, null, null, null);
                this.trace.clear();
            }

            public void beginStackFrame(String string, String string2, String string3, String string4, int n3, int n2) {
                this.elem = new CallTraceElementImpl(string, string2, string3, string4, n3, null);
            }

            public void addMonitor(Object object, int n3, long l, int n2) {
                MonitorImpl monitorImpl = new MonitorImpl(object.hashCode(), n, object.getClass().getName(), n3, l);
                switch (n2) {
                    case 0: {
                        this.current.waitingOn = monitorImpl;
                        break;
                    }
                    case 1: {
                        this.current.blockedOn = monitorImpl;
                        break;
                    }
                    case 2: {
                        this.monitors.add(monitorImpl);
                        break;
                    }
                    default: {
                        throw new InternalError(Integer.toHexString(n2));
                    }
                }
            }

            public void endStackFrame() {
                if (!this.monitors.isEmpty()) {
                    this.elem.setMonitors(this.monitors.toArray(new ThreadSnapshot.Monitor[this.monitors.size()]));
                    this.monitors.clear();
                }
                this.trace.add(this.elem);
            }

            public void endThread() {
                this.current.calltrace = this.trace;
                this.trace = new ArrayList();
                arrayList.add(this.current);
            }
        };
        Threads.dumpThreads(threadDumpCallback, threadArray, true);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getSnapshotID() {
        Class<ThreadSnapshotImpl> clazz = ThreadSnapshotImpl.class;
        synchronized (ThreadSnapshotImpl.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++snapshotID;
        }
    }

    public ThreadSnapshot.Monitor getBlockedOnMonitor() {
        return this.blockedOn;
    }

    public ThreadSnapshot.Monitor getWaitingOnMonitor() {
        return this.waitingOn;
    }

    public static class MonitorImpl
    implements ThreadSnapshot.Monitor {
        private long monitorID;
        private int snapshotID;
        private String className;
        private int lockType;
        private long ownerThreadID;

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof MonitorImpl)) {
                return false;
            }
            MonitorImpl monitorImpl = (MonitorImpl)object;
            return monitorImpl.monitorID == this.monitorID && monitorImpl.snapshotID == this.snapshotID;
        }

        public int hashCode() {
            return (int)this.monitorID ^ this.snapshotID;
        }

        public String toString() {
            if (this.getLockType() == -1) {
                return this.className + "@" + Long.toHexString(this.monitorID);
            }
            return this.className + "@" + Long.toHexString(this.monitorID) + "[" + this.getLockTypeString() + "]";
        }

        public MonitorImpl(long l, int n, String string, int n2, long l2) {
            this.monitorID = l;
            this.snapshotID = n;
            this.className = string;
            this.lockType = n2;
            this.ownerThreadID = l2;
        }

        public long getID() {
            return this.monitorID;
        }

        public String getClassName() {
            return this.className;
        }

        public int getLockType() {
            return this.lockType;
        }

        public String getLockTypeString() {
            switch (this.lockType) {
                case 0: {
                    return "not locked";
                }
                case 1: {
                    return "thin lock";
                }
                case 2: {
                    return "fat lock";
                }
                case 3: {
                    return "recursive lock";
                }
            }
            return "unknown";
        }

        public long getOwnerThreadID() {
            return this.ownerThreadID;
        }

        public String getDescription() {
            return this.toString();
        }
    }
}

