/*
 * Decompiled with CFR 0.152.
 */
package jrockit.mapi;

import com.bea.jvm.NoSuchThreadException;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.ThreadSnapshot;
import com.bea.jvm.ThreadSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import jrockit.mapi.ThreadSnapshotImpl;
import jrockit.mapi.Toolkit;
import jrockit.vm.Threads;

public class ThreadSystemImpl
implements ThreadSystem {
    ThreadSystemImpl() {
        Toolkit.checkCreate();
    }

    public Collection getThreadSnapshots() {
        return ThreadSnapshotImpl.getThreadSnapshot(null);
    }

    public ThreadSnapshot getThreadSnapshot(Thread thread) {
        return (ThreadSnapshotImpl)ThreadSnapshotImpl.getThreadSnapshot(new Thread[]{thread}).get(0);
    }

    public Collection getThreadSnapshots(String string) {
        Collection collection;
        if (string != null && (collection = this.getThreads(string)).size() > 0) {
            return ThreadSnapshotImpl.getThreadSnapshot(collection.toArray(new Thread[collection.size()]));
        }
        return new ArrayList(0);
    }

    public ThreadSnapshot getThreadSnapshot(long l) throws NoSuchThreadException {
        return ThreadSnapshotImpl.getThreadSnapshot(new Thread[]{this.getThread(l)}).get(0);
    }

    public int getTotalThreadCount() throws NotAvailableException {
        return Threads.getThreadCount();
    }

    public int getDaemonThreadCount() throws NotAvailableException {
        return Threads.getDaemonThreadCount();
    }

    public Collection getAllThreads() throws NotAvailableException {
        return Arrays.asList(Threads.getThreads());
    }

    public Collection getThreads(String string) {
        return Arrays.asList(Threads.getThreads(string));
    }

    public Thread getThread(long l) throws NoSuchThreadException {
        Thread thread = Threads.getThreadFromId(l);
        if (thread != null) {
            return thread;
        }
        throw new NoSuchThreadException(String.valueOf(l));
    }

    public boolean isUsingThinThreads() {
        return false;
    }

    public String getThreadStackDump() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("===== FULL THREAD DUMP ===============\n");
        stringBuffer.append(new Date());
        stringBuffer.append("\n\n");
        for (ThreadSnapshotImpl threadSnapshotImpl : this.getThreadSnapshots()) {
            threadSnapshotImpl.toString(stringBuffer).append('\n');
        }
        stringBuffer.append("======================================\n");
        return stringBuffer.toString();
    }

    public String getDescription() {
        return this.isUsingThinThreads() ? "Thin Threads" : "Native Threads";
    }
}

