/*
 * Decompiled with CFR 0.152.
 */
package jrockit.memory;

import jrockit.vm.Memory;

public class NativeObject {
    protected int address;
    protected int realAddress;

    public NativeObject(int n) {
        this.realAddress = this.address = Memory.allocateMemory(n);
    }

    private NativeObject(NativeObject nativeObject, int n) {
        this.address = nativeObject.address + n;
    }

    private NativeObject(int n, int n2) {
        this.address = n + n2;
        this.realAddress = 0;
    }

    private NativeObject(NativeObject nativeObject) {
        this(nativeObject, 0);
    }

    protected NativeObject(int n, boolean bl) {
        if (!bl) {
            this.realAddress = this.address = Memory.allocateMemory(n);
        } else {
            int n2;
            int n3 = Memory.pageSize();
            this.realAddress = n2 = Memory.allocateMemory(n + n3);
            this.address = n2 + n3 - (n2 & n3 - 1);
        }
    }

    public final synchronized void free() {
        if (this.realAddress != 0) {
            Memory.freeMemory(this.realAddress);
            this.realAddress = 0;
        }
    }

    public final int address() {
        return this.address;
    }

    public NativeObject subObject(int n) {
        return new NativeObject(this, n);
    }

    public NativeObject getObject(int n) {
        return new NativeObject(Memory.getAddress(this.address + n), 0);
    }

    public void setObject(int n, NativeObject nativeObject) {
        Memory.setAddress(this.address, n, nativeObject.address);
    }

    public final byte getByte(int n) {
        return Memory.getByte(this.address, n);
    }

    public final void setByte(int n, byte by) {
        Memory.setByte(this.address, n, by);
    }

    public final short getShort(int n) {
        return Memory.getShort(this.address, n);
    }

    public final void setShort(int n, short s) {
        Memory.setShort(this.address, n, s);
    }

    public final char getChar(int n) {
        return Memory.getChar(this.address, n);
    }

    public final void setChar(int n, char c) {
        Memory.setChar(this.address, n, c);
    }

    public final int getInt(int n) {
        return Memory.getInt(this.address, n);
    }

    public final void setInt(int n, int n2) {
        Memory.setInt(this.address, n, n2);
    }

    public final long getLong(int n) {
        return Memory.getLong(this.address, n);
    }

    public final void setLong(int n, long l) {
        Memory.setLong(this.address, n, l);
    }

    public final int getAddress(int n) {
        return Memory.getAddress(this.address, n);
    }

    public final void setAddress(int n, int n2) {
        Memory.setAddress(this.address, n, n2);
    }

    public final float getFloat(int n) {
        return Memory.getFloat(this.address, n);
    }

    public final void setFloat(int n, float f) {
        Memory.setFloat(this.address, n, f);
    }

    public final double getDouble(int n) {
        return Memory.getDouble(this.address, n);
    }

    public final void setDouble(int n, double d) {
        Memory.setDouble(this.address, n, d);
    }
}

