/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import jrockit.io.IOMemory;
import jrockit.net.InetAddressCache;
import jrockit.net.SocketNativeIO;
import jrockit.net.SocketOpts;
import jrockit.nio.ch.AlreadyBoundException;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;

public final class DatagramChannelImpl
extends DatagramChannel
implements Selectable {
    FileDescriptor fd = null;
    private static final int ST_UNINITIALIZED = -1;
    private static int ST_UNCONNECTED = 0;
    private static int ST_CONNECTED = 1;
    private static final int ST_KILLED = 2;
    private volatile int state = -1;
    private static SocketNativeIO nd = SocketNativeIO.getInstance();
    private int timeout = -1;
    private InetAddressCache cache = new InetAddressCache();
    private InetSocketAddress sender;
    private volatile SocketAddress localAddress = null;
    private volatile SocketAddress remoteAddress = null;
    private DatagramSocket socket;
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private final Object stateLock = new Object();
    private static DatagramSocketImpl useLess = new DatagramSocketImpl(){

        protected void create() throws SocketException {
        }

        protected void bind(int n, InetAddress inetAddress) throws SocketException {
        }

        protected void send(DatagramPacket datagramPacket) throws IOException {
        }

        protected int peek(InetAddress inetAddress) throws IOException {
            return -1;
        }

        protected int peekData(DatagramPacket datagramPacket) throws IOException {
            return -1;
        }

        protected void receive(DatagramPacket datagramPacket) throws IOException {
        }

        protected void setTTL(byte by) throws IOException {
        }

        protected byte getTTL() throws IOException {
            return -1;
        }

        protected void setTimeToLive(int n) throws IOException {
        }

        protected int getTimeToLive() throws IOException {
            return -1;
        }

        protected void join(InetAddress inetAddress) throws IOException {
        }

        protected void leave(InetAddress inetAddress) throws IOException {
        }

        protected void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        protected void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        }

        protected void close() {
        }

        public void setOption(int n, Object object) throws SocketException {
        }

        public Object getOption(int n) throws SocketException {
            return null;
        }
    };

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = nd.socket(false);
        this.state = ST_UNCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                try {
                    this.socket = new DatagramSocketAdaptor();
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
            }
            return this.socket;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * Exception decompiling
     */
    public SocketAddress receive(ByteBuffer var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int receive0(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        if (byteBuffer instanceof IOMemory) {
            return this.receive((IOMemory)((Object)byteBuffer), n);
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(IOMemory iOMemory, int n) throws IOException {
        int n2 = 0;
        try {
            n2 = nd.receive(this.fd, iOMemory.acquire(), n, this.cache, this.timeout, false, this.isConnected());
        }
        finally {
            iOMemory.release(n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int send(ByteBuffer var1_1, SocketAddress var2_2) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var3_3 = this.writeLock;
        synchronized (var3_3) {
            block27: {
                this.ensureOpen();
                var4_4 = this.stateLock;
                synchronized (var4_4) {
                    if (!this.isConnected()) {
                        if (var2_2 == null) {
                            throw new NullPointerException();
                        }
                        var5_6 = System.getSecurityManager();
                        if (var5_6 != null) {
                            var6_9 = (InetSocketAddress)var2_2;
                            if (var6_9.getAddress().isMulticastAddress()) {
                                var5_6.checkMulticast(var6_9.getAddress());
                            } else {
                                var5_6.checkConnect(var6_9.getAddress().getHostAddress(), var6_9.getPort());
                            }
                        }
                    } else if (var2_2 == null) {
                        var2_2 = this.remoteAddress;
                    } else if (!var2_2.equals(this.remoteAddress)) {
                        throw new IllegalArgumentException("Connected address not equal to  target address");
                    }
                }
                var4_5 = 0;
                this.begin();
                if (this.isOpen()) break block27;
                var5_7 = 0;
                if (var4_5 > 0) ** GOTO lbl-1000
                if (var4_5 == -2) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                return var5_7;
            }
            var4_5 = this.send0(var1_1, var2_2);
            var5_8 = SocketNativeIO.normalize(var4_5);
            if (var4_5 > 0) ** GOTO lbl-1000
            {
                catch (Throwable var8_11) {
                    if (var4_5 > 0) ** GOTO lbl-1000
                    if (var4_5 == -2) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                    throw var8_11;
                }
            }
            if (var4_5 == -2) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.end(v2);
            return var5_8;
        }
    }

    private int send0(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        if (byteBuffer instanceof IOMemory) {
            return this.send((IOMemory)((Object)byteBuffer), n, socketAddress);
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(IOMemory iOMemory, int n, SocketAddress socketAddress) throws IOException {
        InetSocketAddress inetSocketAddress = SocketNativeIO.asInetSocketAddress(socketAddress);
        int n2 = 0;
        try {
            n2 = nd.send(this.fd, iOMemory.acquire(), n, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), 0);
        }
        finally {
            iOMemory.release(n2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.readLock;
        synchronized (var2_2) {
            block19: {
                var3_3 = this.stateLock;
                synchronized (var3_3) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                var3_4 = 0;
                this.begin();
                if (this.isOpen()) break block19;
                var4_6 = 0;
                if (var3_4 > 0) ** GOTO lbl-1000
                if (var3_4 == -2) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                return var4_6;
            }
            var3_4 = IOUtil.read(this.fd, var1_1, -1L, DatagramChannelImpl.nd, null);
            var4_7 = SocketNativeIO.normalize(var3_4);
            if (var3_4 > 0) ** GOTO lbl-1000
            {
                catch (Throwable var5_8) {
                    if (var3_4 > 0) ** GOTO lbl-1000
                    if (var3_4 == -2) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                    throw var5_8;
                }
            }
            if (var3_4 == -2) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.end(v2);
            return var4_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long read0(ByteBuffer[] var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.readLock;
        synchronized (var2_2) {
            var3_3 = this.stateLock;
            synchronized (var3_3) {
                this.ensureOpen();
                if (!this.isConnected()) {
                    throw new NotYetConnectedException();
                }
            }
            var3_4 = 0L;
            try {
                this.begin();
                var3_4 = IOUtil.read(this.fd, var1_1, DatagramChannelImpl.nd);
                var5_6 = SocketNativeIO.normalize(var3_4);
                if (var3_4 > 0L) ** GOTO lbl-1000
            }
            catch (Throwable var7_7) {
                if (var3_4 > 0L) ** GOTO lbl-1000
                if (var3_4 == -2L) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                throw var7_7;
            }
            if (var3_4 == -2L) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.end(v1);
            return var5_6;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.read0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int write(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.writeLock;
        synchronized (var2_2) {
            block19: {
                var3_3 = this.stateLock;
                synchronized (var3_3) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                var3_4 = 0;
                this.begin();
                if (this.isOpen()) break block19;
                var4_6 = 0;
                if (var3_4 > 0) ** GOTO lbl-1000
                if (var3_4 == -2) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                return var4_6;
            }
            var3_4 = IOUtil.write(this.fd, var1_1, -1L, DatagramChannelImpl.nd, this.writeLock);
            var4_7 = SocketNativeIO.normalize(var3_4);
            if (var3_4 > 0) ** GOTO lbl-1000
            {
                catch (Throwable var5_8) {
                    if (var3_4 > 0) ** GOTO lbl-1000
                    if (var3_4 == -2) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                    throw var5_8;
                }
            }
            if (var3_4 == -2) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.end(v2);
            return var4_7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long write0(ByteBuffer[] var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.writeLock;
        synchronized (var2_2) {
            block19: {
                var3_3 = this.stateLock;
                synchronized (var3_3) {
                    this.ensureOpen();
                    if (!this.isConnected()) {
                        throw new NotYetConnectedException();
                    }
                }
                var3_4 = 0L;
                this.begin();
                if (this.isOpen()) break block19;
                var5_6 = 0L;
                if (var3_4 > 0L) ** GOTO lbl-1000
                if (var3_4 == -2L) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                return var5_6;
            }
            var3_4 = IOUtil.write(this.fd, var1_1, DatagramChannelImpl.nd);
            var5_7 = SocketNativeIO.normalize(var3_4);
            if (var3_4 > 0L) ** GOTO lbl-1000
            {
                catch (Throwable var7_8) {
                    if (var3_4 > 0L) ** GOTO lbl-1000
                    if (var3_4 == -2L) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                    throw var7_8;
                }
            }
            if (var3_4 == -2L) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.end(v2);
            return var5_7;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.write0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        nd.configureBlocking(this.fd, bl);
    }

    public boolean isBound() {
        return SocketNativeIO.localPortNumber(this.fd) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            SecurityManager securityManager;
            if (this.isConnected() && this.localAddress == null) {
                this.localAddress = SocketNativeIO.localAddress(this.fd);
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localAddress;
                securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        throw new AlreadyBoundException();
                    }
                    SecurityManager securityManager = System.getSecurityManager();
                    InetSocketAddress inetSocketAddress = SocketNativeIO.checkAddress(socketAddress);
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    nd.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = SocketNativeIO.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ST_CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state != ST_UNCONNECTED) {
                throw new IllegalStateException("Connect already invoked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        int n = 0;
        boolean bl = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    int n2;
                    this.ensureOpenAndUnconnected();
                    InetSocketAddress inetSocketAddress = SocketNativeIO.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    if ((n2 = nd.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n)) < 0) {
                        throw new Error();
                    }
                    this.state = ST_CONNECTED;
                    this.remoteAddress = socketAddress;
                    this.sender = inetSocketAddress;
                    this.cache.setAddress(inetSocketAddress.getAddress());
                    this.cache.setPort(inetSocketAddress.getPort());
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isConnected() || !this.isOpen()) {
                        return this;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                    }
                    nd.disconnect(this.fd);
                    this.remoteAddress = null;
                    this.state = ST_UNCONNECTED;
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preclose(this.fd);
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2 || this.state == -1) {
                this.state = 2;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 2;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public boolean translateAndSetOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = 0;
        int n3 = selectionKeyImpl.interestOps0();
        int n4 = selectionKeyImpl.readyOps0();
        if ((n & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n & 0x19) != 0 && (n3 & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 0x1C) != 0 && (n3 & 4) != 0) {
            n2 |= 4;
        }
        selectionKeyImpl.readyOps0(n2);
        return (n2 & ~n4) != 0;
    }

    public void translateAndRegisterOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 8) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    private final class DatagramSocketAdaptor
    extends DatagramSocket {
        public DatagramSocketAdaptor() {
            super(useLess);
        }

        public void bind(SocketAddress socketAddress) throws SocketException {
            try {
                if (socketAddress == null) {
                    socketAddress = new InetSocketAddress(0);
                }
                DatagramChannelImpl.this.bind(socketAddress);
            }
            catch (Exception exception) {
                IOUtil.translateToSocketException(exception);
            }
        }

        public void connect(InetAddress inetAddress, int n) {
            try {
                this.connect(new InetSocketAddress(inetAddress, n));
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(SocketAddress socketAddress) throws SocketException {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (inetSocketAddress.isUnresolved()) {
                throw new SocketException("Unresolved address");
            }
            Object object = DatagramChannelImpl.this.blockingLock();
            synchronized (object) {
                if (!DatagramChannelImpl.this.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    DatagramChannelImpl.this.connect(inetSocketAddress);
                }
                catch (Exception exception) {
                    IOUtil.translateToSocketException(exception);
                }
            }
        }

        public void disconnect() {
            try {
                DatagramChannelImpl.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(DatagramPacket datagramPacket) throws IOException {
            Object object = DatagramChannelImpl.this.blockingLock();
            synchronized (object) {
                if (!DatagramChannelImpl.this.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    DatagramPacket datagramPacket2 = datagramPacket;
                    synchronized (datagramPacket2) {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                        DatagramChannelImpl.this.send(byteBuffer, datagramPacket.getSocketAddress());
                    }
                }
                catch (IOException iOException) {
                    IOUtil.translateToSocketException(iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(DatagramPacket datagramPacket) throws IOException {
            Object object = DatagramChannelImpl.this.blockingLock();
            synchronized (object) {
                if (!DatagramChannelImpl.this.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    DatagramPacket datagramPacket2 = datagramPacket;
                    synchronized (datagramPacket2) {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                        if (DatagramChannelImpl.this.receive(byteBuffer) == null) {
                            throw new SocketTimeoutException("receive");
                        }
                        datagramPacket.setLength(byteBuffer.position() - datagramPacket.getOffset());
                    }
                }
                catch (IOException iOException) {
                    IOUtil.translateToSocketException(iOException);
                }
            }
        }

        public boolean isBound() {
            return DatagramChannelImpl.this.isBound();
        }

        public boolean isConnected() {
            return DatagramChannelImpl.this.isConnected();
        }

        public InetAddress getInetAddress() {
            if (!this.isConnected()) {
                return null;
            }
            nd;
            return SocketNativeIO.asInetSocketAddress(DatagramChannelImpl.this.remoteAddress()).getAddress();
        }

        public int getPort() {
            if (!this.isConnected()) {
                return -1;
            }
            nd;
            return SocketNativeIO.asInetSocketAddress(DatagramChannelImpl.this.remoteAddress()).getPort();
        }

        public SocketAddress getRemoteSocketAddress() {
            return DatagramChannelImpl.this.remoteAddress();
        }

        public SocketAddress getLocalSocketAddress() {
            if (!this.isBound()) {
                return null;
            }
            return DatagramChannelImpl.this.localAddress();
        }

        public InetAddress getLocalAddress() {
            if (this.isClosed()) {
                return null;
            }
            if (!this.isBound()) {
                return new InetSocketAddress(0).getAddress();
            }
            nd;
            return SocketNativeIO.asInetSocketAddress(DatagramChannelImpl.this.localAddress()).getAddress();
        }

        public int getLocalPort() {
            if (this.isClosed()) {
                return -1;
            }
            try {
                nd;
                return SocketNativeIO.asInetSocketAddress(DatagramChannelImpl.this.localAddress()).getPort();
            }
            catch (Exception exception) {
                return 0;
            }
        }

        public boolean isClosed() {
            return !DatagramChannelImpl.this.isOpen();
        }

        public DatagramChannel getChannel() {
            return DatagramChannelImpl.this;
        }

        public synchronized void setSoTimeout(int n) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            nd;
            DatagramChannelImpl.this.timeout = SocketNativeIO.java2NativeTimeout(n);
        }

        public synchronized int getSoTimeout() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            nd;
            return SocketNativeIO.native2JavaTimeout(DatagramChannelImpl.this.timeout);
        }

        public synchronized void setSendBufferSize(int n) throws SocketException {
            if (n <= 0) {
                throw new IllegalArgumentException("negative send size");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4097, new Integer(n), DatagramChannelImpl.this.fd, nd);
        }

        public synchronized int getSendBufferSize() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = 0;
            Object object = SocketOpts.getOption(4097, DatagramChannelImpl.this.fd, nd);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        public synchronized void setReceiveBufferSize(int n) throws SocketException {
            if (n <= 0) {
                throw new IllegalArgumentException("invalid receive size");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4098, new Integer(n), DatagramChannelImpl.this.fd, nd);
        }

        public synchronized int getReceiveBufferSize() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = 0;
            Object object = SocketOpts.getOption(4098, DatagramChannelImpl.this.fd, nd);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        public synchronized void setReuseAddress(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4, new Boolean(bl), DatagramChannelImpl.this.fd, nd);
        }

        public synchronized boolean getReuseAddress() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            Object object = SocketOpts.getOption(4, DatagramChannelImpl.this.fd, nd);
            return (Boolean)object;
        }

        public synchronized void setBroadcast(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(32, new Boolean(bl), DatagramChannelImpl.this.fd, nd);
        }

        public synchronized boolean getBroadcast() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(32, DatagramChannelImpl.this.fd, nd);
        }

        public synchronized void setTrafficClass(int n) throws SocketException {
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(3, new Integer(n), DatagramChannelImpl.this.fd, nd);
        }

        public synchronized int getTrafficClass() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Integer)SocketOpts.getOption(3, DatagramChannelImpl.this.fd, nd);
        }

        public void close() {
            try {
                DatagramChannelImpl.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

