/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import jrockit.io.FileNativeIO;
import jrockit.nio.ch.DirectBuffer;
import jrockit.nio.ch.FileLockImpl;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;

public class FileChannelImpl
extends FileChannel {
    private FileDescriptor fd;
    private boolean writable;
    private boolean readable;
    private boolean appending;
    List lockList = new ArrayList();
    private Object parent;
    private static FileNativeIO nd = FileNativeIO.getInstance();
    private Object lock = new Object();
    private static long allocationGranularity = nd.getMemoryMapGranularity();
    private static final int TRANSFER_SIZE = 8192;
    private static final Field isAMappedBufferField;

    private FileChannelImpl(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object, boolean bl3) {
        this.fd = fileDescriptor;
        this.readable = bl;
        this.writable = bl2;
        this.parent = object;
        this.appending = bl3;
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, object, false);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl, boolean bl2, Object object, boolean bl3) {
        return new FileChannelImpl(fileDescriptor, bl, bl2, object, bl3);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseChannel() throws IOException {
        List list = this.lockList;
        synchronized (list) {
            for (FileLockImpl fileLockImpl : this.lockList) {
                fileLockImpl.invalidate();
                nd.release(this.fd, fileLockImpl.position(), fileLockImpl.size());
            }
            this.lockList.clear();
        }
        if (this.parent != null) {
            if (this.parent instanceof FileInputStream) {
                ((FileInputStream)this.parent).close();
            } else if (this.parent instanceof FileOutputStream) {
                ((FileOutputStream)this.parent).close();
            } else if (this.parent instanceof RandomAccessFile) {
                ((RandomAccessFile)this.parent).close();
            } else assert (false);
        } else {
            nd.close(this.fd);
        }
    }

    protected void finalize() throws IOException {
        this.implCloseChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            int n;
            int n2 = 0;
            try {
                this.begin();
                n = n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.lock);
                this.end(n2 > 0);
            }
            catch (Throwable throwable) {
                this.end(n2 > 0);
                throw throwable;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long read0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            long l;
            long l2 = 0L;
            try {
                this.begin();
                l = l2 = IOUtil.read(this.fd, byteBufferArray, nd);
                this.end(l2 > 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 > 0L);
                throw throwable;
            }
            return l;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.read0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            int n;
            block7: {
                int n2;
                n = 0;
                try {
                    this.begin();
                    if (this.isOpen()) break block7;
                    n2 = 0;
                    this.end(n > 0);
                }
                catch (Throwable throwable) {
                    this.end(n > 0);
                    throw throwable;
                }
                return n2;
            }
            if (this.appending) {
                this.position(this.size());
            }
            int n3 = n = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.lock);
            this.end(n > 0);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long write0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            long l;
            long l2 = 0L;
            try {
                this.begin();
                if (this.appending) {
                    this.position(this.size());
                }
                l = l2 = IOUtil.write(this.fd, byteBufferArray, nd);
                this.end(l2 > 0L);
            }
            catch (Throwable throwable) {
                this.end(l2 > 0L);
                throw throwable;
            }
            return l;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.write0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l;
            long l2 = -1L;
            try {
                this.begin();
                l = l2 = nd.position(this.fd, -1L, false);
                this.end(l2 > -1L);
            }
            catch (Throwable throwable) {
                this.end(l2 > -1L);
                throw throwable;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel position(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.begin();
                nd.position(this.fd, l, false);
                bl = true;
            }
            finally {
                this.end(bl);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l;
            long l2 = -1L;
            try {
                this.begin();
                l = l2 = nd.size(this.fd);
                this.end(l2 > -1L);
            }
            catch (Throwable throwable) {
                this.end(l2 > -1L);
                throw throwable;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel truncate(long l) throws IOException {
        this.ensureOpen();
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            try {
                this.begin();
                nd.truncate(this.fd, l);
                bl = true;
            }
            finally {
                this.end(bl);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force(boolean bl) throws IOException {
        this.ensureOpen();
        boolean bl2 = false;
        try {
            this.begin();
            nd.force(this.fd, bl);
            bl2 = true;
        }
        finally {
            this.end(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        Object object;
        this.ensureOpen();
        if (!writableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        long l3 = this.size();
        if (l > l3) {
            return 0L;
        }
        int n = (int)Math.min(l2, Integer.MAX_VALUE);
        if (l3 - l < (long)n) {
            n = (int)(l3 - l);
        }
        FileDescriptor fileDescriptor = null;
        if (writableByteChannel instanceof FileChannelImpl) {
            object = (FileChannelImpl)writableByteChannel;
            if (!((FileChannelImpl)object).writable) {
                throw new NonWritableChannelException();
            }
            fileDescriptor = ((FileChannelImpl)writableByteChannel).fd;
        } else if (writableByteChannel instanceof Selectable) {
            fileDescriptor = ((Selectable)((Object)writableByteChannel)).getFD();
        }
        if (fileDescriptor != null) {
            object = null;
            try {
                object = this.map(FileChannel.MapMode.READ_ONLY, l, n);
                long l4 = writableByteChannel.write((ByteBuffer)object);
                return l4;
            }
            finally {
                if (object != null) {
                    FileChannelImpl.unmap((MappedByteBuffer)object);
                }
            }
        }
        int n2 = Math.min(n, 8192);
        ByteBuffer byteBuffer = null;
        int n3 = 0;
        long l5 = l;
        try {
            byteBuffer = IOUtil.getIOBuffer(n2);
            while (n3 < n) {
                byteBuffer.limit(Math.min(n - n3, 8192));
                int n4 = this.read(byteBuffer, l5);
                if (n4 <= 0) break;
                byteBuffer.flip();
                int n5 = writableByteChannel.write(byteBuffer);
                n3 += n5;
                if (n5 != n4) break;
                l5 += (long)n5;
                byteBuffer.clear();
            }
            long l6 = n3;
            return l6;
        }
        catch (IOException iOException) {
            if (n3 > 0) {
                long l7 = n3;
                return l7;
            }
            throw iOException;
        }
        finally {
            IOUtil.releaseIOBuffer(byteBuffer);
        }
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        this.ensureOpen();
        if (!readableByteChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l > this.size()) {
            return 0L;
        }
        int n = (int)Math.min(l2, Integer.MAX_VALUE);
        if (readableByteChannel instanceof FileChannelImpl) {
            return this.transfer((FileChannelImpl)readableByteChannel, l, n);
        }
        return this.transfer(readableByteChannel, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transfer(FileChannelImpl fileChannelImpl, long l, int n) throws IOException {
        int n2;
        block6: {
            MappedByteBuffer mappedByteBuffer = null;
            try {
                int n3 = 0;
                Object object = fileChannelImpl.lock;
                synchronized (object) {
                    long l2 = fileChannelImpl.position();
                    mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l2, n);
                    n3 = this.write(mappedByteBuffer, l);
                    fileChannelImpl.position(l2 + (long)n3);
                }
                n2 = n3;
                if (mappedByteBuffer == null) break block6;
            }
            catch (Throwable throwable) {
                if (mappedByteBuffer != null) {
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transfer(ReadableByteChannel readableByteChannel, long l, int n) throws IOException {
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        int n5 = n3 > 8192 ? 8192 : n3;
        ByteBuffer byteBuffer = IOUtil.getIOBuffer(n5);
        try {
            int n6;
            this.begin();
            long l2 = l;
            while ((n6 = readableByteChannel.read(byteBuffer)) > 0) {
                byteBuffer.flip();
                n4 = IOUtil.write(this.fd, byteBuffer, l2, nd, this.lock);
                if (n4 != n6) {
                    throw new IOException("transferFrom failed to write all bytes read");
                }
                l2 += (long)n4;
                n2 += n4;
                byteBuffer.clear();
                n5 = (n3 -= n4) > 8192 ? 8192 : n3;
                byteBuffer.limit(n5);
                if (n2 < n) continue;
            }
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            this.end(n2 > 0);
            IOUtil.releaseIOBuffer(byteBuffer);
            throw throwable;
        }
        IOUtil.releaseIOBuffer(byteBuffer);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        this.ensureOpen();
        int n2 = 0;
        try {
            this.begin();
            n = n2 = IOUtil.read(this.fd, byteBuffer, l, nd, this.lock);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            this.end(n2 > 0);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        int n;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        this.ensureOpen();
        int n2 = 0;
        try {
            this.begin();
            n = n2 = IOUtil.write(this.fd, byteBuffer, l, nd, this.lock);
            this.end(n2 > 0);
        }
        catch (Throwable throwable) {
            this.end(n2 > 0);
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        int n;
        int n2;
        int n3;
        block19: {
            int n4;
            block17: {
                block18: {
                    MappedByteBuffer mappedByteBuffer;
                    this.ensureOpen();
                    if (l < 0L) {
                        throw new IllegalArgumentException("Negative position");
                    }
                    if (l2 < 0L) {
                        throw new IllegalArgumentException("Negative size");
                    }
                    if (l2 > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                    }
                    n4 = -1;
                    if (mapMode == FileChannel.MapMode.READ_ONLY) {
                        n4 = 0;
                    } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
                        n4 = 1;
                    } else if (mapMode == FileChannel.MapMode.PRIVATE) {
                        n4 = 2;
                    }
                    assert (n4 >= 0);
                    if (mapMode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                        throw new NonWritableChannelException();
                    }
                    if (!this.readable) {
                        throw new NonReadableChannelException();
                    }
                    n3 = -1;
                    try {
                        this.begin();
                        if (this.size() < l + l2) {
                            nd.truncate(this.fd, l + l2);
                        }
                        if (l2 != 0L) break block17;
                        n3 = 0;
                        if (this.writable && n4 != 0) break block18;
                        mappedByteBuffer = IOUtil.newMappedByteBufferR(0, 0, 0);
                        this.end(n3 != -1);
                    }
                    catch (Throwable throwable) {
                        this.end(n3 != -1);
                        throw throwable;
                    }
                    return mappedByteBuffer;
                }
                MappedByteBuffer mappedByteBuffer = IOUtil.newMappedByteBuffer(0, 0, 0);
                this.end(n3 != -1);
                return mappedByteBuffer;
            }
            n2 = (int)(l % allocationGranularity);
            n3 = nd.map(this.fd, n4, l - (long)n2, l2 + (long)n2);
            n = (int)l2;
            if (this.writable && n4 != 0) break block19;
            MappedByteBuffer mappedByteBuffer = IOUtil.newMappedByteBufferR(n, n3, n2);
            this.end(n3 != -1);
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = IOUtil.newMappedByteBuffer(n, n3, n2);
        this.end(n3 != -1);
        return mappedByteBuffer;
    }

    public static void unmap(MappedByteBuffer mappedByteBuffer) {
        DirectBuffer directBuffer = (DirectBuffer)((Object)mappedByteBuffer);
        while (directBuffer.viewedBuffer() != null) {
            directBuffer = (DirectBuffer)directBuffer.viewedBuffer();
        }
        int n = directBuffer.address();
        if (n != 0) {
            FileNativeIO.unmap(n, ((MappedByteBuffer)((Object)directBuffer)).capacity());
        }
        try {
            isAMappedBufferField.setBoolean(directBuffer, false);
        }
        catch (Throwable throwable) {
            throw new InternalError();
        }
    }

    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        this.ensureOpen();
        if (bl && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        this.checkList(l, l2);
        this.addList(fileLockImpl);
        boolean bl2 = true;
        try {
            this.begin();
            int n = nd.lock(this.fd, true, l, l2, bl);
            if (n == 1) {
                assert (bl);
                FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
                this.addList(fileLockImpl2);
                this.removeList(fileLockImpl);
                FileLockImpl fileLockImpl3 = fileLockImpl2;
                return fileLockImpl3;
            }
            if (n == 2 || n == -1) {
                this.removeList(fileLockImpl);
                bl2 = false;
            }
        }
        catch (IOException iOException) {
            this.removeList(fileLockImpl);
            throw iOException;
        }
        finally {
            try {
                this.end(bl2);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new FileLockInterruptionException();
            }
        }
        return fileLockImpl;
    }

    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        this.ensureOpen();
        if (bl && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l, l2, bl);
        this.checkList(l, l2);
        this.addList(fileLockImpl);
        int n = nd.lock(this.fd, false, l, l2, bl);
        if (n == -1) {
            this.removeList(fileLockImpl);
            return null;
        }
        if (n == 1) {
            assert (bl);
            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l, l2, false);
            this.addList(fileLockImpl2);
            this.removeList(fileLockImpl);
            return fileLockImpl2;
        }
        return fileLockImpl;
    }

    void release(FileLockImpl fileLockImpl) throws IOException {
        this.ensureOpen();
        nd.release(this.fd, fileLockImpl.position(), fileLockImpl.size());
        this.removeList(fileLockImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkList(long l, long l2) throws OverlappingFileLockException {
        List list = this.lockList;
        synchronized (list) {
            for (FileLock fileLock : this.lockList) {
                if (!fileLock.overlaps(l, l2)) continue;
                throw new OverlappingFileLockException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.add(fileLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.remove(fileLock);
        }
    }

    static {
        try {
            isAMappedBufferField = (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Field field = MappedByteBuffer.class.getDeclaredField("isAMappedBuffer");
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError(throwable.toString());
        }
    }
}

