/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import jrockit.io.IOMemory;
import jrockit.io.NativeIO;
import jrockit.memory.NativeObject;
import jrockit.nio.ch.AlreadyBoundException;
import jrockit.nio.ch.DirectBuffer;
import jrockit.nio.ch.IOVecWrapper;
import jrockit.vm.Memory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IOUtil {
    private static ThreadLocal bufferReference = new ThreadLocal();
    private static Constructor directByteBufferConstructor = null;
    private static Constructor directByteBufferRConstructor = null;

    private IOUtil() {
    }

    static <E> Set<E> ungrowableSet(final Set<E> set) {
        return new Set<E>(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object);
            }

            @Override
            public Object[] toArray() {
                return set.toArray();
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return set.toArray(TArray);
            }

            public String toString() {
                return set.toString();
            }

            @Override
            public Iterator<E> iterator() {
                return set.iterator();
            }

            @Override
            public boolean equals(Object object) {
                return ((Object)set).equals(object);
            }

            @Override
            public int hashCode() {
                return ((Object)set).hashCode();
            }

            @Override
            public void clear() {
                set.clear();
            }

            @Override
            public boolean remove(Object object) {
                return set.remove(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return set.removeAll(collection);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                return set.retainAll(collection);
            }

            @Override
            public boolean add(E e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> collection) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return i;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n) {
        int n2 = byteBufferArray.length - n;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        for (int i = 0; i < n2; ++i) {
            byteBufferArray2[i] = byteBufferArray[i + n];
        }
        return byteBufferArray2;
    }

    static int write(FileDescriptor fileDescriptor, int n, int n2, long l, NativeIO nativeIO, Object object) throws IOException {
        if (l != -1L) {
            return nativeIO.pwrite(fileDescriptor, n, n2, l, object);
        }
        return nativeIO.write(fileDescriptor, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, IOMemory iOMemory, int n, long l, NativeIO nativeIO, Object object) throws IOException {
        int n2 = 0;
        try {
            n2 = IOUtil.write(fileDescriptor, iOMemory.acquire(), n, l, nativeIO, object);
        }
        finally {
            iOMemory.release(n2);
        }
        return n2;
    }

    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeIO nativeIO, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        if (byteBuffer instanceof IOMemory) {
            return IOUtil.write(fileDescriptor, (IOMemory)((Object)byteBuffer), n, l, nativeIO, object);
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeIO nativeIO) throws IOException {
        int n;
        ByteBuffer byteBuffer;
        int n2;
        int n3 = IOUtil.remaining(byteBufferArray);
        if (n3 < 0) {
            return 0L;
        }
        if (n3 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n3);
        }
        int n4 = byteBufferArray.length;
        int n5 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i = 0; i < n4; ++i) {
            if (!(byteBufferArray[i] instanceof DirectBuffer)) {
                int n6 = byteBufferArray[i].position();
                int n7 = byteBufferArray[i].limit();
                assert (n6 <= n7);
                n2 = n6 <= n7 ? n7 - n6 : 0;
                byteBufferArray2[i] = byteBuffer = ByteBuffer.allocateDirect(n2);
                byteBuffer.put(byteBufferArray[i]);
                byteBufferArray[i].position(n6);
                byteBuffer.flip();
                continue;
            }
            byteBufferArray2[i] = byteBufferArray[i];
        }
        long l = 0L;
        NativeObject nativeObject = null;
        try {
            nativeObject = new IOVecWrapper(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                byteBuffer = byteBufferArray2[n2];
                n = byteBuffer.position();
                int n8 = byteBuffer.limit() - n;
                n5 += n8;
                ((IOVecWrapper)nativeObject).putBase(n2, ((DirectBuffer)((Object)byteBuffer)).address() + n);
                ((IOVecWrapper)nativeObject).putLen(n2, n8);
            }
            l = nativeIO.writev(fileDescriptor, ((IOVecWrapper)nativeObject).iovec(), n4);
        }
        finally {
            nativeObject.free();
        }
        long l2 = l;
        for (n = 0; n < n4; ++n) {
            int n9;
            int n10;
            ByteBuffer byteBuffer2 = byteBufferArray[n];
            int n11 = byteBuffer2.position();
            int n12 = byteBuffer2.limit();
            assert (n11 <= n12);
            int n13 = n10 = n11 <= n12 ? n12 - n11 : n12;
            if (l >= (long)n10) {
                l -= (long)n10;
            } else {
                if (l <= 0L) break;
                n9 = (int)((long)n11 + l);
                byteBuffer2.position(n9);
                break;
            }
            n9 = n11 + n10;
            byteBuffer2.position(n9);
        }
        return l2;
    }

    static int read(FileDescriptor fileDescriptor, int n, int n2, long l, NativeIO nativeIO, Object object) throws IOException {
        boolean bl = false;
        if (l != -1L) {
            return nativeIO.pread(fileDescriptor, n, n2, l, object);
        }
        return nativeIO.read(fileDescriptor, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, IOMemory iOMemory, int n, long l, NativeIO nativeIO, Object object) throws IOException {
        int n2 = 0;
        try {
            n2 = IOUtil.read(fileDescriptor, iOMemory.acquire(), n, l, nativeIO, object);
        }
        finally {
            iOMemory.release(n2);
        }
        return n2;
    }

    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeIO nativeIO, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        if (byteBuffer instanceof IOMemory) {
            return IOUtil.read(fileDescriptor, (IOMemory)((Object)byteBuffer), n, l, nativeIO, object);
        }
        throw new InternalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeIO nativeIO) throws IOException {
        int n;
        int n2 = IOUtil.remaining(byteBufferArray);
        if (n2 < 0) {
            return 0L;
        }
        if (n2 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n2);
        }
        int n3 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            byteBufferArray2[i] = !(byteBufferArray[i] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[i].remaining()) : byteBufferArray[i];
        }
        long l = 0L;
        NativeObject nativeObject = null;
        try {
            nativeObject = new IOVecWrapper(n3);
            for (int i = 0; i < n3; ++i) {
                ByteBuffer byteBuffer = byteBufferArray2[i];
                n = byteBuffer.position();
                int n4 = byteBuffer.remaining();
                ((IOVecWrapper)nativeObject).putBase(i, ((DirectBuffer)((Object)byteBuffer)).address() + n);
                ((IOVecWrapper)nativeObject).putLen(i, n4);
            }
            l = nativeIO.readv(fileDescriptor, ((IOVecWrapper)nativeObject).iovec(), n3);
        }
        finally {
            nativeObject.free();
        }
        long l2 = l;
        for (n = 0; n < n3; ++n) {
            int n5;
            ByteBuffer byteBuffer = byteBufferArray2[n];
            int n6 = byteBuffer.position();
            int n7 = byteBuffer.remaining();
            if (l >= (long)n7) {
                l -= (long)n7;
            } else {
                if (l <= 0L) break;
                n5 = (int)((long)n6 + l);
                byteBuffer.position(n5);
                break;
            }
            n5 = n6 + n7;
            byteBuffer.position(n5);
        }
        for (n = 0; n < n3; ++n) {
            if (byteBufferArray[n] instanceof DirectBuffer) continue;
            byteBufferArray2[n].flip();
            byteBufferArray[n].put(byteBufferArray2[n]);
        }
        return l2;
    }

    public static ByteBuffer getIOBuffer(int n) {
        return ByteBuffer.allocate(n);
    }

    public static void releaseIOBuffer(ByteBuffer byteBuffer) {
    }

    static ByteBuffer getTemporaryDirectBuffer(int n) {
        ByteBuffer byteBuffer = null;
        SoftReference softReference = (SoftReference)bufferReference.get();
        if (softReference == null || (byteBuffer = (ByteBuffer)softReference.get()) == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocateDirect(n);
            bufferReference.set(new SoftReference<ByteBuffer>(byteBuffer));
        } else {
            byteBuffer.rewind();
            byteBuffer.limit(n);
        }
        return byteBuffer;
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (n == 0 && n2 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n3 = n2;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            byteBufferArray2[i] = byteBufferArray[n + i];
        }
        return byteBufferArray2;
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
                    directByteBufferConstructor = clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    directByteBufferConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBuffer(int n, int n2, int n3) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            IOUtil.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Integer(n), new Integer(n2), new Integer(n3), new Boolean(true));
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName("java.nio.DirectByteBufferR");
                    directByteBufferRConstructor = clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    directByteBufferRConstructor.setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    static MappedByteBuffer newMappedByteBufferR(int n, int n2, int n3) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            IOUtil.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Integer(n), new Integer(n2), new Integer(n3), new Boolean(true));
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    public static void translateToSocketException(Exception exception, boolean bl) throws SocketException {
        if (exception instanceof SocketException) {
            throw (SocketException)exception;
        }
        Exception exception2 = exception;
        if (exception instanceof ClosedChannelException) {
            exception2 = new SocketException("Socket is closed");
        } else if (exception instanceof AlreadyBoundException) {
            exception2 = new SocketException("Already bound");
        } else if (exception instanceof NotYetBoundException) {
            exception2 = new SocketException("Socket is not bound yet");
        } else if (exception instanceof UnsupportedAddressTypeException) {
            exception2 = new SocketException("Unsupported address type");
        } else if (exception instanceof UnresolvedAddressException) {
            exception2 = bl ? new UnknownHostException() : new SocketException("Unresolved address");
        }
        if (exception2 == exception) {
            if (exception2 instanceof RuntimeException) {
                throw (RuntimeException)exception2;
            }
            throw new Error("Untranslated exception", exception2);
        }
        exception2.initCause(exception);
    }

    public static void translateToSocketException(Exception exception) throws SocketException {
        IOUtil.translateToSocketException(exception, false);
    }

    public static void translateException(Exception exception, boolean bl) throws IOException {
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        IOUtil.translateToSocketException(exception, bl);
    }

    public static void translateException(Exception exception) throws IOException {
        IOUtil.translateException(exception, false);
    }

    static void erase(ByteBuffer byteBuffer) {
        Memory.setMemory(((DirectBuffer)((Object)byteBuffer)).address(), byteBuffer.capacity(), 0);
    }
}

