/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;

public abstract class PipeImpl
extends Pipe {
    protected SourceChannelImpl source;
    protected SinkChannelImpl sink;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;

    public Pipe.SourceChannel source() {
        return this.source;
    }

    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    protected abstract class SourceChannelImpl
    extends Pipe.SourceChannel
    implements Selectable {
        private Object stateLock;
        private volatile int state;

        SourceChannelImpl(SelectorProvider selectorProvider) {
            super(selectorProvider);
            this.stateLock = new Object();
            this.state = -1;
            this.state = 0;
        }

        protected void implCloseSelectableChannel() throws IOException {
            if (!this.isRegistered()) {
                this.kill();
            }
        }

        protected abstract void destroy() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    return;
                }
                if (this.state == -1) {
                    this.state = 1;
                    return;
                }
                this.destroy();
                this.state = 1;
            }
        }

        public boolean translateAndSetOps(SelectionKeyImpl selectionKeyImpl, int n) {
            int n2 = 0;
            int n3 = selectionKeyImpl.interestOps0();
            int n4 = selectionKeyImpl.readyOps0();
            if ((n & 0x18) != 0) {
                n2 = n3;
            }
            if ((n & 1) != 0 && (n3 & 1) != 0) {
                n2 |= 1;
            }
            selectionKeyImpl.readyOps0(n2);
            return (n2 & ~n4) != 0;
        }

        public void translateAndRegisterOps(SelectionKeyImpl selectionKeyImpl, int n) {
            int n2 = 0;
            if ((n & 1) != 0) {
                n2 |= 1;
            }
            selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
        }

        public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            return this.read(IOUtil.subsequence(byteBufferArray, n, n2));
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }

    protected abstract class SinkChannelImpl
    extends Pipe.SinkChannel
    implements Selectable {
        private Object stateLock;
        private volatile int state;

        SinkChannelImpl(SelectorProvider selectorProvider) {
            super(selectorProvider);
            this.stateLock = new Object();
            this.state = -1;
            this.state = 0;
        }

        protected void implCloseSelectableChannel() throws IOException {
            if (!this.isRegistered()) {
                this.kill();
            }
        }

        protected abstract void destroy() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 1) {
                    return;
                }
                if (this.state == -1) {
                    this.state = 1;
                    return;
                }
                this.destroy();
                this.state = 1;
            }
        }

        public boolean translateAndSetOps(SelectionKeyImpl selectionKeyImpl, int n) {
            int n2 = 0;
            int n3 = selectionKeyImpl.interestOps0();
            int n4 = selectionKeyImpl.readyOps0();
            if ((n & 0x18) != 0) {
                n2 = n3;
            }
            if ((n & 4) != 0 && (n3 & 4) != 0) {
                n2 |= 4;
            }
            selectionKeyImpl.readyOps0(n2);
            return (n2 & ~n4) != 0;
        }

        public void translateAndRegisterOps(SelectionKeyImpl selectionKeyImpl, int n) {
            int n2 = 0;
            if ((n & 4) != 0) {
                n2 |= 4;
            }
            selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
        }

        public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
            return this.write(IOUtil.subsequence(byteBufferArray, n, n2));
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

