/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.util.Set;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectorImpl;
import jrockit.vm.Access;

public final class SelectionKeyImpl
extends AbstractSelectionKey {
    int signal_info;
    int index;
    int interestOps;
    int readyOps;
    Selectable channel;
    SelectorImpl selector;

    public String toString() {
        return "KEY index=" + this.index + ", iops=" + this.interestOps + ", rops=" + this.readyOps + ", fh=" + Access.getFDHandle(this.getFD());
    }

    SelectionKeyImpl(Selectable selectable, SelectorImpl selectorImpl) {
        this.channel = selectable;
        this.selector = selectorImpl;
    }

    public SelectableChannel channel() {
        return (SelectableChannel)((Object)this.channel);
    }

    FileDescriptor getFD() {
        return this.channel.getFD();
    }

    public Selector selector() {
        return this.selector;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int n) {
        this.index = n;
    }

    private void ensureValid() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int interestOps() {
        this.ensureValid();
        Set<SelectionKey> set = this.selector.selectedKeys();
        synchronized (set) {
            return this.interestOps;
        }
    }

    public SelectionKey interestOps(int n) {
        this.ensureValid();
        return this.interestOps0(n);
    }

    public int readyOps() {
        this.ensureValid();
        return this.readyOps0();
    }

    public int interestOps0() {
        return this.interestOps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey interestOps0(int n) {
        Set<SelectionKey> set = this.selector.selectedKeys();
        synchronized (set) {
            if ((n & ~this.channel().validOps()) != 0) {
                throw new IllegalArgumentException();
            }
            this.channel.translateAndRegisterOps(this, n);
            this.interestOps = n;
        }
        return this;
    }

    public int readyOps0() {
        return this.readyOps;
    }

    void readyOps0(int n) {
        this.readyOps = n;
    }
}

