/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;
import jrockit.nio.ch.SelectorProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectorImpl
extends AbstractSelector {
    protected Set<SelectionKey> selectedKeys;
    protected HashSet<SelectionKey> keys;
    private Set<SelectionKey> publicKeys;
    private Set<SelectionKey> publicSelectedKeys;
    protected SelectionKeyImpl[] channelArray;
    protected int totalChannels = 0;
    protected Object interruptLock = new Object();
    private boolean interruptTriggered = false;

    protected SelectorImpl(SelectorProviderImpl selectorProviderImpl, int n) {
        super(selectorProviderImpl);
        this.channelArray = new SelectionKeyImpl[n];
        this.selectedKeys = new HashSet<SelectionKey>();
        this.keys = new HashSet();
        this.publicKeys = Collections.unmodifiableSet(this.keys);
        this.publicSelectedKeys = IOUtil.ungrowableSet(this.selectedKeys);
    }

    @Override
    public Set<SelectionKey> keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.publicKeys;
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.publicSelectedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockSelect(long l) throws IOException {
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            if (!this.isOpen()) {
                throw new ClosedSelectorException();
            }
            Set<SelectionKey> set = this.publicKeys;
            synchronized (set) {
                Set<SelectionKey> set2 = this.publicSelectedKeys;
                synchronized (set2) {
                    return this.doSelect(l);
                }
            }
        }
    }

    @Override
    public int select(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        return this.lockSelect(l == 0L ? -1L : l);
    }

    @Override
    public int select() throws IOException {
        return this.select(0L);
    }

    @Override
    public int selectNow() throws IOException {
        return this.lockSelect(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        int n = 0;
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        if (this.checkInterrupt()) {
            return 0;
        }
        try {
            this.begin();
            n = this.poll(l);
        }
        finally {
            this.end();
        }
        this.clearInterrupt();
        this.processDeregisterQueue();
        int n2 = this.updateSelectedKeys(n);
        return n2;
    }

    protected abstract int poll(long var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelector() throws IOException {
        this.wakeup();
        SelectorImpl selectorImpl = this;
        synchronized (selectorImpl) {
            Set<SelectionKey> set = this.publicKeys;
            synchronized (set) {
                Set<SelectionKey> set2 = this.publicSelectedKeys;
                synchronized (set2) {
                    this.implClose();
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        if (!(abstractSelectableChannel instanceof Selectable)) {
            throw new IllegalSelectorException();
        }
        SelectionKeyImpl selectionKeyImpl = new SelectionKeyImpl((Selectable)((Object)abstractSelectableChannel), this);
        selectionKeyImpl.attach(object);
        Set<SelectionKey> set = this.publicKeys;
        synchronized (set) {
            this.implRegister(selectionKeyImpl);
        }
        selectionKeyImpl.interestOps0(n);
        return selectionKeyImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeregisterQueue() throws IOException {
        Set<SelectionKey> set;
        Set<SelectionKey> set2 = set = this.cancelledKeys();
        synchronized (set2) {
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.implDereg((SelectionKeyImpl)iterator.next());
                iterator.remove();
            }
        }
    }

    protected final boolean implUpdate(SelectionKeyImpl selectionKeyImpl, int n) {
        if (!selectionKeyImpl.isValid()) {
            return false;
        }
        if (this.selectedKeys.contains(selectionKeyImpl)) {
            return selectionKeyImpl.channel.translateAndSetOps(selectionKeyImpl, n);
        }
        selectionKeyImpl.channel.translateAndSetOps(selectionKeyImpl, n);
        if ((selectionKeyImpl.readyOps0() & selectionKeyImpl.interestOps0()) != 0) {
            this.selectedKeys.add(selectionKeyImpl);
            return true;
        }
        return false;
    }

    protected void implGrow(int n) {
        SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
        for (int i = 0; i < this.channelArray.length; ++i) {
            selectionKeyImplArray[i] = this.channelArray[i];
        }
        this.channelArray = selectionKeyImplArray;
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        if (this.totalChannels == this.channelArray.length) {
            this.implGrow(this.channelArray.length * 2);
        }
        selectionKeyImpl.setIndex(this.totalChannels);
        this.channelArray[this.totalChannels++] = selectionKeyImpl;
        this.keys.add(selectionKeyImpl);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n = selectionKeyImpl.getIndex();
        int n2 = this.totalChannels - 1;
        if (this.channelArray[n] != selectionKeyImpl) {
            throw new IllegalStateException("unknown key");
        }
        if (n != n2) {
            this.channelArray[n] = this.channelArray[n2];
            this.channelArray[n].setIndex(n);
        }
        this.channelArray[n2] = null;
        --this.totalChannels;
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((Selectable)((Object)selectableChannel)).kill();
        }
    }

    protected void implClose() throws IOException {
        if (this.channelArray != null) {
            for (int i = this.totalChannels - 1; i >= 0; --i) {
                this.implDereg(this.channelArray[i]);
            }
            this.channelArray = null;
            this.selectedKeys = null;
            this.keys = null;
            assert (this.totalChannels == 0);
        }
    }

    protected abstract void putEventOps(SelectionKeyImpl var1, int var2);

    protected abstract int updateSelectedKeys(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInterrupted() {
        Object object = this.interruptLock;
        synchronized (object) {
            return this.interruptTriggered;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkInterrupt() {
        Object object = this.interruptLock;
        synchronized (object) {
            boolean bl = this.interruptTriggered;
            this.clearInterrupt();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.interruptTriggered = true;
                this.interrupt();
            }
        }
        return this;
    }

    protected abstract void interrupt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInterrupt() {
        Object object = this.interruptLock;
        synchronized (object) {
            this.interruptTriggered = false;
        }
    }
}

