/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import jrockit.net.InetAddressCache;
import jrockit.net.SocketNativeIO;
import jrockit.net.SocketOpts;
import jrockit.nio.ch.AlreadyBoundException;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;
import jrockit.nio.ch.SocketChannelImpl;

public class ServerSocketChannelImpl
extends ServerSocketChannel
implements Selectable {
    private SocketNativeIO nd = SocketNativeIO.getInstance();
    private final FileDescriptor fd;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = 0;
    private volatile SocketAddress localAddress = null;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    ServerSocket socket;
    private int timeout = -1;

    public ServerSocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = this.nd.socket(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSocket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                try {
                    this.socket = new ServerSocketAdaptor();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
            }
            return this.socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isBound()) {
                throw new AlreadyBoundException();
            }
            InetSocketAddress inetSocketAddress = SocketNativeIO.checkAddress(socketAddress);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            this.nd.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
            this.nd.listen(this.fd, n < 1 ? 50 : n);
            Object object2 = this.stateLock;
            synchronized (object2) {
                this.localAddress = SocketNativeIO.localAddress(this.fd);
            }
        }
    }

    public SocketChannel accept() throws IOException {
        return this.accept(this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SocketChannel accept(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            InetAddressCache inetAddressCache;
            FileDescriptor fileDescriptor;
            block11: {
                SocketChannel socketChannel;
                if (!this.isOpen()) {
                    throw new ClosedChannelException();
                }
                if (!this.isBound()) {
                    throw new NotYetBoundException();
                }
                try {
                    this.begin();
                    fileDescriptor = new FileDescriptor();
                    inetAddressCache = this.nd.accept(this.fd, fileDescriptor, n);
                    if (inetAddressCache != null) break block11;
                    fileDescriptor = null;
                    if (n > 0) {
                        throw new SocketTimeoutException("accept");
                    }
                    socketChannel = null;
                    this.end(this.fd != null);
                }
                catch (Throwable throwable) {
                    this.end(this.fd != null);
                    throw throwable;
                }
                return socketChannel;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkAccept(inetAddressCache.getAddress().getHostAddress(), inetAddressCache.getPort());
                }
                catch (SecurityException securityException) {
                    fileDescriptor = null;
                    throw securityException;
                }
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddressCache.getAddress(), inetAddressCache.getPort());
            SocketChannelImpl socketChannelImpl = new SocketChannelImpl(this.provider(), fileDescriptor, inetSocketAddress);
            this.end(this.fd != null);
            return socketChannelImpl;
        }
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.nd.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            this.nd.close(this.fd);
            this.state = 1;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public boolean translateAndSetOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = selectionKeyImpl.readyOps0();
        int n3 = 0;
        if ((n & 0x18) != 0) {
            n3 = selectionKeyImpl.interestOps0();
        }
        if ((n & 1) != 0) {
            n3 |= 0x10;
        }
        selectionKeyImpl.readyOps0(n3);
        return (n3 & ~n2) != 0;
    }

    public void translateAndRegisterOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = 0;
        if ((n & 0x10) != 0) {
            n2 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.localAddress() == null) {
                    stringBuffer.append("unbound");
                } else {
                    stringBuffer.append(this.localAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private class ServerSocketAdaptor
    extends ServerSocket {
        public void bind(SocketAddress socketAddress) throws IOException {
            this.bind(socketAddress, 50);
        }

        public void bind(SocketAddress socketAddress, int n) throws IOException {
            SecurityManager securityManager;
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (this.isBound()) {
                throw new SocketException("Already bound");
            }
            if (socketAddress == null) {
                socketAddress = new InetSocketAddress(0);
            }
            if (!(socketAddress instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Unsupported address type");
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (inetSocketAddress.isUnresolved()) {
                throw new SocketException("Unresolved address");
            }
            if (n < 1) {
                n = 50;
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkListen(inetSocketAddress.getPort());
            }
            try {
                this.setReuseAddress(true);
                ServerSocketChannelImpl.this.bind(inetSocketAddress, n);
            }
            catch (Exception exception) {
                IOUtil.translateException(exception, true);
            }
        }

        public InetAddress getInetAddress() {
            if (!this.isBound()) {
                return null;
            }
            ServerSocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(ServerSocketChannelImpl.this.localAddress()).getAddress();
        }

        public int getLocalPort() {
            if (!this.isBound()) {
                return -1;
            }
            ServerSocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(ServerSocketChannelImpl.this.localAddress()).getPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return ServerSocketChannelImpl.this.localAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket accept() throws IOException {
            Object object = ServerSocketChannelImpl.this.blockingLock();
            synchronized (object) {
                if (!ServerSocketChannelImpl.this.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    SocketChannel socketChannel = ServerSocketChannelImpl.this.accept(ServerSocketChannelImpl.this.timeout);
                    if (socketChannel == null) {
                        throw new SocketException("accept failed");
                    }
                    return socketChannel.socket();
                }
                catch (Exception exception) {
                    IOUtil.translateException(exception, true);
                    return null;
                }
            }
        }

        public void close() throws IOException {
            ServerSocketChannelImpl.this.close();
        }

        public ServerSocketChannel getChannel() {
            return ServerSocketChannelImpl.this;
        }

        public boolean isBound() {
            return ServerSocketChannelImpl.this.isBound();
        }

        public boolean isClosed() {
            return !ServerSocketChannelImpl.this.isOpen();
        }

        public synchronized void setSoTimeout(int n) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (n < 0) {
                throw new IllegalArgumentException("timeout can't be negative");
            }
            ServerSocketChannelImpl.this.nd;
            ServerSocketChannelImpl.this.timeout = SocketNativeIO.java2NativeTimeout(ServerSocketChannelImpl.this.timeout);
        }

        public synchronized int getSoTimeout() throws IOException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            ServerSocketChannelImpl.this.nd;
            return SocketNativeIO.native2JavaTimeout(ServerSocketChannelImpl.this.timeout);
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4, new Boolean(bl), ServerSocketChannelImpl.this.fd, ServerSocketChannelImpl.this.nd);
        }

        public boolean getReuseAddress() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(4, ServerSocketChannelImpl.this.fd, ServerSocketChannelImpl.this.nd);
        }

        public String toString() {
            if (!this.isBound()) {
                return "ServerSocket[unbound]";
            }
            return "ServerSocket[addr=" + this.getInetAddress() + ",localport=" + this.getLocalPort() + "]";
        }

        public synchronized void setReceiveBufferSize(int n) throws SocketException {
            if (n <= 0) {
                throw new IllegalArgumentException("negative receive size");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4098, new Integer(n), ServerSocketChannelImpl.this.fd, ServerSocketChannelImpl.this.nd);
        }

        public synchronized int getReceiveBufferSize() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = 0;
            Object object = SocketOpts.getOption(4098, ServerSocketChannelImpl.this.fd, ServerSocketChannelImpl.this.nd);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }
    }
}

