/*
 * Decompiled with CFR 0.152.
 */
package jrockit.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import jrockit.io.NativeIOInputStream;
import jrockit.io.NativeIOOutputStream;
import jrockit.net.SocketNativeIO;
import jrockit.net.SocketOpts;
import jrockit.nio.ch.AlreadyBoundException;
import jrockit.nio.ch.IOUtil;
import jrockit.nio.ch.Selectable;
import jrockit.nio.ch.SelectionKeyImpl;

public final class SocketChannelImpl
extends SocketChannel
implements Selectable {
    private SocketNativeIO nd = SocketNativeIO.getInstance();
    private FileDescriptor fd;
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_UNCONNECTED = 0;
    private static final int ST_PENDING = 1;
    private static final int ST_CONNECTED = 2;
    private static final int ST_KILLED = 3;
    private volatile int state = -1;
    private volatile SocketAddress localAddress = null;
    private volatile SocketAddress remoteAddress = null;
    private volatile boolean isInputOpen = true;
    private volatile boolean isOutputOpen = true;
    private volatile boolean readyToConnect = false;
    private Socket socket = null;
    private int timeout = -1;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Object stateLock = new Object();
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;
    public static final int SHUT_RDWR = 2;

    public SocketChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = this.nd.socket(true);
        this.state = 0;
    }

    SocketChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor, SocketAddress socketAddress) throws IOException {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.remoteAddress = socketAddress;
        this.state = 2;
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.socket == null) {
                try {
                    this.socket = new SocketAdaptor();
                }
                catch (IOException iOException) {
                    throw new Error(iOException);
                }
            }
            return this.socket;
        }
    }

    void setRemoteAddress(InetSocketAddress inetSocketAddress) {
        this.remoteAddress = inetSocketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReadOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return this.isInputOpen;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWriteOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isOutputOpen) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int read(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.readLock;
        synchronized (var2_2) {
            block28: {
                if (!this.ensureReadOpen()) {
                    return -1;
                }
                var3_3 = 0;
                this.begin();
                if (this.isOpen()) break block28;
                var4_4 = 0;
                if (var3_3 > 0) ** GOTO lbl-1000
                if (var3_3 == -2) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                var5_6 = this.stateLock;
                synchronized (var5_6) {
                    if (var3_3 <= 0 && !this.isInputOpen) {
                        return -1;
                    }
                }
                return var4_4;
            }
            var3_3 = IOUtil.read(this.fd, var1_1, -1L, this.nd, this.readLock);
            var4_5 = SocketNativeIO.normalize(var3_3);
            if (var3_3 > 0) ** GOTO lbl-1000
            {
                catch (Throwable var8_10) {
                    if (var3_3 > 0) ** GOTO lbl-1000
                    if (var3_3 == -2) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                    var9_11 = this.stateLock;
                    synchronized (var9_11) {
                        if (var3_3 <= 0 && !this.isInputOpen) {
                            return -1;
                        }
                    }
                    throw var8_10;
                }
            }
            if (var3_3 == -2) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            this.end(v2);
            var5_7 = this.stateLock;
            synchronized (var5_7) {
                if (var3_3 <= 0 && !this.isInputOpen) {
                    return -1;
                }
            }
            return var4_5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private long read0(ByteBuffer[] var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.readLock;
        synchronized (var2_2) {
            if (!this.ensureReadOpen()) {
                return -1L;
            }
            var3_3 = 0L;
            try {
                this.begin();
                var3_3 = IOUtil.read(this.fd, var1_1, this.nd);
                var5_4 = SocketNativeIO.normalize(var3_3);
                if (var3_3 > 0L) ** GOTO lbl-1000
            }
            catch (Throwable var9_7) {
                if (var3_3 > 0L) ** GOTO lbl-1000
                if (var3_3 == -2L) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                var10_8 = this.stateLock;
                synchronized (var10_8) {
                    if (var3_3 <= 0L && !this.isInputOpen) {
                        return -1L;
                    }
                }
                throw var9_7;
            }
            if (var3_3 == -2L) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.end(v1);
            var7_5 = this.stateLock;
            synchronized (var7_5) {
                if (var3_3 <= 0L && !this.isInputOpen) {
                    return -1L;
                }
            }
            return var5_4;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.read0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int write(ByteBuffer var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.writeLock;
        synchronized (var2_2) {
            this.ensureWriteOpen();
            var3_3 = 0;
            try {
                this.begin();
                var3_3 = IOUtil.write(this.fd, var1_1, -1L, this.nd, this.writeLock);
                var4_4 = SocketNativeIO.normalize(var3_3);
                if (var3_3 > 0) ** GOTO lbl-1000
            }
            catch (Throwable var7_7) {
                if (var3_3 > 0) ** GOTO lbl-1000
                if (var3_3 == -2) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                var8_8 = this.stateLock;
                synchronized (var8_8) {
                    if (var3_3 <= 0 && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                throw var7_7;
            }
            if (var3_3 == -2) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.end(v1);
            var5_5 = this.stateLock;
            synchronized (var5_5) {
                if (var3_3 <= 0 && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
            }
            return var4_4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public long write0(ByteBuffer[] var1_1) throws IOException {
        if (var1_1 == null) {
            throw new NullPointerException();
        }
        var2_2 = this.writeLock;
        synchronized (var2_2) {
            this.ensureWriteOpen();
            var3_3 = 0L;
            try {
                this.begin();
                var3_3 = IOUtil.write(this.fd, var1_1, this.nd);
                var5_4 = SocketNativeIO.normalize(var3_3);
                if (var3_3 > 0L) ** GOTO lbl-1000
            }
            catch (Throwable var9_7) {
                if (var3_3 > 0L) ** GOTO lbl-1000
                if (var3_3 == -2L) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                this.end(v0);
                var10_8 = this.stateLock;
                synchronized (var10_8) {
                    if (var3_3 <= 0L && !this.isOutputOpen) {
                        throw new AsynchronousCloseException();
                    }
                }
                throw var9_7;
            }
            if (var3_3 == -2L) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.end(v1);
            var7_5 = this.stateLock;
            synchronized (var7_5) {
                if (var3_3 <= 0L && !this.isOutputOpen) {
                    throw new AsynchronousCloseException();
                }
            }
            return var5_4;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.write0(IOUtil.subsequence(byteBufferArray, n, n2));
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.nd.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                return true;
            }
            return this.localAddress != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress localAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2 && this.localAddress == null) {
                this.localAddress = SocketNativeIO.localAddress(this.fd);
            }
            return this.localAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress remoteAddress() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.remoteAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.localAddress != null) {
                        throw new AlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = SocketNativeIO.checkAddress(socketAddress);
                    this.nd.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    this.localAddress = SocketNativeIO.localAddress(this.fd);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.state == 2) {
                throw new AlreadyConnectedException();
            }
            if (this.state == 1) {
                throw new ConnectionPendingException();
            }
        }
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.connect(socketAddress, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean connect(SocketAddress var1_1, int var2_2) throws IOException {
        var3_3 = 0;
        var4_4 = false;
        var5_5 = this.readLock;
        synchronized (var5_5) {
            var6_6 = this.writeLock;
            synchronized (var6_6) {
                this.ensureOpenAndUnconnected();
                var7_7 = SocketNativeIO.checkAddress(var1_1);
                var8_8 = System.getSecurityManager();
                if (var8_8 != null) {
                    var8_8.checkConnect(var7_7.getAddress().getHostAddress(), var7_7.getPort());
                }
                var9_9 = this.blockingLock();
                synchronized (var9_9) {
                    var10_10 = 0;
                    try {
                        try {
                            this.begin();
                            if (this.isOpen()) {
                                if (!this.isBlocking()) {
                                    var2_2 = 0;
                                }
                                var10_10 = this.nd.connect(this.fd, var7_7.getAddress(), var7_7.getPort(), var3_3, var2_2);
                            }
                            if (var10_10 > 0) ** GOTO lbl-1000
                        }
                        catch (Throwable var11_11) {
                            if (var10_10 > 0) ** GOTO lbl-1000
                            if (var10_10 == -2) lbl-1000:
                            // 2 sources

                            {
                                v0 = true;
                            } else {
                                v0 = false;
                            }
                            this.end(v0);
                            throw var11_11;
                        }
                        if (var10_10 == -2) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = false;
                        }
                        this.end(v1);
                    }
                    catch (IOException var11_12) {
                        this.close();
                        throw var11_12;
                    }
                    var11_13 = this.stateLock;
                    synchronized (var11_13) {
                        this.remoteAddress = var7_7;
                        if (var10_10 > 0) {
                            this.state = 2;
                            return true;
                        }
                        if (this.isBlocking()) {
                            throw new InternalError();
                        }
                        this.state = 1;
                    }
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean finishConnect() throws IOException {
        var1_1 = this.readLock;
        synchronized (var1_1) {
            var2_2 = this.writeLock;
            synchronized (var2_2) {
                var3_3 = this.stateLock;
                synchronized (var3_3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (this.state == 2) {
                        return true;
                    }
                    if (this.state != 1) {
                        throw new NoConnectionPendingException();
                    }
                }
                var3_4 = 0;
                try {
                    try {
                        this.begin();
                        if (this.isOpen()) {
                            var3_4 = this.nd.checkConnect(this.fd, false, this.readyToConnect);
                        }
                        if (var3_4 > 0) ** GOTO lbl-1000
                    }
                    catch (Throwable var5_8) {
                        if (var3_4 > 0) ** GOTO lbl-1000
                        if (var3_4 == -2) lbl-1000:
                        // 2 sources

                        {
                            v0 = true;
                        } else {
                            v0 = false;
                        }
                        this.end(v0);
                        throw var5_8;
                    }
                    if (var3_4 == -2) lbl-1000:
                    // 2 sources

                    {
                        v1 = true;
                    } else {
                        v1 = false;
                    }
                    this.end(v1);
                }
                catch (IOException var4_6) {
                    this.close();
                    throw var4_6;
                }
                if (var3_4 > 0) {
                    var4_7 = this.stateLock;
                    synchronized (var4_7) {
                        this.state = 2;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public boolean translateAndSetOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = 0;
        int n3 = selectionKeyImpl.interestOps0();
        int n4 = selectionKeyImpl.readyOps0();
        if ((n & 0x20) != 0) {
            throw new Error("POLLNVAL detected (" + n + ", " + selectionKeyImpl + ", " + this + ")");
        }
        if ((n & 0x18) != 0) {
            n2 = n3;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0 && this.state == 2) {
            n2 |= 1;
        }
        if ((n & 4) != 0 && (n3 & 4) != 0 && this.state == 2) {
            n2 |= 4;
        }
        if ((n & 4) != 0 && (n3 & 8) != 0) {
            n2 |= 8;
            this.readyToConnect = true;
        }
        selectionKeyImpl.readyOps0(n2);
        return (n2 & ~n4) != 0;
    }

    public void translateAndRegisterOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = 0;
        if (n != 0) {
            if ((n & 1) != 0) {
                n2 |= 1;
            }
            if ((n & 4) != 0) {
                n2 |= 4;
            }
            if ((n & 8) != 0) {
                n2 |= 4;
            }
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownInput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isInputOpen = false;
            this.nd.shutdown(this.fd, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownOutput() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            this.isOutputOpen = false;
            this.nd.shutdown(this.fd, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isInputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOutputOpen() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isOutputOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.isInputOpen = false;
            this.isOutputOpen = false;
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3 || this.state == -1) {
                this.state = 3;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            this.nd.close(this.fd);
            this.state = 3;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSuperclass().getName());
        stringBuffer.append('[');
        if (!this.isOpen()) {
            stringBuffer.append("closed");
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case 0: {
                        stringBuffer.append("unconnected");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("connection-pending");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("connected");
                        if (!this.isInputOpen) {
                            stringBuffer.append(" ishut");
                        }
                        if (this.isOutputOpen) break;
                        stringBuffer.append(" oshut");
                    }
                }
                if (this.localAddress() != null) {
                    stringBuffer.append(" local=");
                    stringBuffer.append(this.localAddress().toString());
                }
                if (this.remoteAddress() != null) {
                    stringBuffer.append(" remote=");
                    stringBuffer.append(this.remoteAddress().toString());
                }
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private class SocketAdaptor
    extends Socket {
        private InputStream is;
        private OutputStream os;

        public SocketAdaptor() throws SocketException {
            super((SocketImpl)null);
            this.is = null;
            this.os = null;
        }

        public void connect(SocketAddress socketAddress) throws IOException {
            this.connect(socketAddress, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connect(SocketAddress socketAddress, int n) throws IOException {
            if (socketAddress == null) {
                throw new IllegalArgumentException("connect: The address can't be null");
            }
            if (n < 0) {
                throw new IllegalArgumentException("connect: timeout can't be negative");
            }
            Object object = SocketChannelImpl.this.blockingLock();
            synchronized (object) {
                if (!SocketChannelImpl.this.isBlocking()) {
                    throw new IllegalBlockingModeException();
                }
                try {
                    SocketChannelImpl.this.configureBlocking(false);
                    if (!SocketChannelImpl.this.connect(socketAddress, n)) {
                        throw new SocketTimeoutException("connect");
                    }
                }
                catch (Exception exception) {
                    IOUtil.translateException(exception, true);
                }
                finally {
                    SocketChannelImpl.this.configureBlocking(true);
                }
            }
        }

        public void bind(SocketAddress socketAddress) throws IOException {
            try {
                if (socketAddress == null) {
                    socketAddress = new InetSocketAddress(0);
                }
                SocketChannelImpl.this.bind(socketAddress);
            }
            catch (AlreadyBoundException alreadyBoundException) {
                throw new SocketException("already bound");
            }
            catch (Exception exception) {
                IOUtil.translateException(exception, true);
            }
        }

        public InetAddress getInetAddress() {
            if (!this.isConnected()) {
                return null;
            }
            SocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(SocketChannelImpl.this.remoteAddress()).getAddress();
        }

        public InetAddress getLocalAddress() {
            if (!this.isBound()) {
                return new InetSocketAddress(0).getAddress();
            }
            SocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(SocketChannelImpl.this.localAddress()).getAddress();
        }

        public int getPort() {
            if (!this.isConnected()) {
                return 0;
            }
            SocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(SocketChannelImpl.this.remoteAddress()).getPort();
        }

        public int getLocalPort() {
            if (!this.isConnected()) {
                return 0;
            }
            SocketChannelImpl.this.nd;
            return SocketNativeIO.asInetSocketAddress(SocketChannelImpl.this.localAddress()).getPort();
        }

        public SocketAddress getRemoteSocketAddress() {
            return SocketChannelImpl.this.remoteAddress();
        }

        public SocketAddress getLocalSocketAddress() {
            return SocketChannelImpl.this.localAddress();
        }

        public SocketChannel getChannel() {
            return SocketChannelImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getInputStream() throws IOException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
            if (!SocketChannelImpl.this.isInputOpen()) {
                throw new SocketException("Socket input is shutdown");
            }
            Object object = SocketChannelImpl.this.readLock;
            synchronized (object) {
                if (this.is == null) {
                    this.is = new NativeIOInputStream(SocketChannelImpl.this.nd, SocketChannelImpl.this.fd){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected final int read(int n, int n2) throws IOException {
                            Object object = SocketChannelImpl.this.blockingLock();
                            synchronized (object) {
                                if (!SocketChannelImpl.this.isBlocking()) {
                                    throw new IllegalBlockingModeException();
                                }
                                int n3 = SocketChannelImpl.this.nd.read(this.fd, n, n2, SocketChannelImpl.this.timeout);
                                if (n3 == -2) {
                                    throw new SocketTimeoutException("read");
                                }
                                return n3;
                            }
                        }

                        public void close() throws IOException {
                            SocketChannelImpl.this.implCloseSelectableChannel();
                        }
                    };
                }
                return this.is;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OutputStream getOutputStream() throws IOException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
            if (!SocketChannelImpl.this.isOutputOpen()) {
                throw new SocketException("Socket output is shutdown");
            }
            Object object = SocketChannelImpl.this.writeLock;
            synchronized (object) {
                if (this.os == null) {
                    this.os = new NativeIOOutputStream(SocketChannelImpl.this.nd, SocketChannelImpl.this.fd){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void write(int n, int n2) throws IOException {
                            Object object = SocketChannelImpl.this.blockingLock();
                            synchronized (object) {
                                if (!SocketChannelImpl.this.isBlocking()) {
                                    throw new IllegalBlockingModeException();
                                }
                                SocketChannelImpl.this.nd.write(this.fd, n, n2);
                            }
                        }

                        public void close() throws IOException {
                            SocketChannelImpl.this.implCloseSelectableChannel();
                        }
                    };
                }
                return this.os;
            }
        }

        public void setTcpNoDelay(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(1, new Boolean(bl), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public boolean getTcpNoDelay() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(1, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public void setSoLinger(boolean bl, int n) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!bl) {
                SocketOpts.setOption(128, new Boolean(bl), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
            } else {
                if (n < 0) {
                    throw new IllegalArgumentException("invalid value for SO_LINGER");
                }
                if (n > 65535) {
                    n = 65535;
                }
                SocketOpts.setOption(128, new Integer(n), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
            }
        }

        public int getSoLinger() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            Object object = SocketOpts.getOption(128, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return -1;
        }

        public void sendUrgentData(int n) throws IOException {
            throw new SocketException("Urgent data not supported");
        }

        public void setOOBInline(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4099, new Boolean(bl), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public boolean getOOBInline() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(4099, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public synchronized void setSoTimeout(int n) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (n < 0) {
                throw new IllegalArgumentException("timeout can't be negative");
            }
            SocketChannelImpl.this.nd;
            SocketChannelImpl.this.timeout = SocketNativeIO.java2NativeTimeout(n);
        }

        public synchronized int getSoTimeout() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketChannelImpl.this.nd;
            return SocketNativeIO.native2JavaTimeout(SocketChannelImpl.this.timeout);
        }

        public synchronized void setSendBufferSize(int n) throws SocketException {
            if (n <= 0) {
                throw new IllegalArgumentException("negative send size");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4097, new Integer(n), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public synchronized int getSendBufferSize() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = 0;
            Object object = SocketOpts.getOption(4097, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        public synchronized void setReceiveBufferSize(int n) throws SocketException {
            if (n <= 0) {
                throw new IllegalArgumentException("invalid receive size");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4098, new Integer(n), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public synchronized int getReceiveBufferSize() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            int n = 0;
            Object object = SocketOpts.getOption(4098, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
            if (object instanceof Integer) {
                n = (Integer)object;
            }
            return n;
        }

        public void setKeepAlive(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(8, new Boolean(bl), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public boolean getKeepAlive() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(8, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public void setTrafficClass(int n) throws SocketException {
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("tc is not in range 0 -- 255");
            }
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(3, new Integer(n), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public int getTrafficClass() throws SocketException {
            return (Integer)SocketOpts.getOption(3, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            SocketOpts.setOption(4, new Boolean(bl), SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public boolean getReuseAddress() throws SocketException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            return (Boolean)SocketOpts.getOption(4, SocketChannelImpl.this.fd, SocketChannelImpl.this.nd);
        }

        public void close() throws IOException {
            SocketChannelImpl.this.close();
        }

        public void shutdownInput() throws IOException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
            if (!SocketChannelImpl.this.isInputOpen()) {
                throw new SocketException("Socket input is already shutdown");
            }
            try {
                SocketChannelImpl.this.shutdownInput();
            }
            catch (ClosedChannelException closedChannelException) {
                throw new SocketException("socket is closed");
            }
        }

        public void shutdownOutput() throws IOException {
            if (this.isClosed()) {
                throw new SocketException("Socket is closed");
            }
            if (!this.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
            if (!SocketChannelImpl.this.isOutputOpen()) {
                throw new SocketException("Socket output is already shutdown");
            }
            try {
                SocketChannelImpl.this.shutdownOutput();
            }
            catch (ClosedChannelException closedChannelException) {
                throw new SocketException("socket is closed");
            }
        }

        public String toString() {
            if (this.isConnected()) {
                return "Socket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
            }
            return "Socket[unconnected]";
        }

        public boolean isConnected() {
            return SocketChannelImpl.this.isConnected();
        }

        public boolean isBound() {
            return SocketChannelImpl.this.isBound();
        }

        public boolean isClosed() {
            return !SocketChannelImpl.this.isOpen();
        }

        public boolean isInputShutdown() {
            return !SocketChannelImpl.this.isInputOpen();
        }

        public boolean isOutputShutdown() {
            return !SocketChannelImpl.this.isOutputOpen();
        }
    }
}

