/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Map;
import jrockit.vm.Access;
import sun.reflect.ConstantPool;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInfo {
    private static final byte FIELD = 0;
    private static final byte METHOD = 1;
    private static final byte CONSTRUCTOR = 2;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private int numParameters;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private transient Map<Class, Annotation> declaredAnnotations;

    public AnnotationInfo(Constructor constructor) {
        this.init(constructor, (byte)2);
    }

    public AnnotationInfo(Method method) {
        this.init(method, (byte)1);
    }

    public AnnotationInfo(Field field) {
        this.init(field, (byte)0);
    }

    private native void init(Object var1, byte var2);

    public byte[] getAnnotations() {
        return this.annotations;
    }

    public byte[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public byte[] getAnnotationDefault() {
        return this.annotationDefault;
    }

    public <T extends Annotation> T getAnnotation(Class clazz, Class<T> clazz2) {
        if (clazz2 == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations(clazz).get(clazz2);
    }

    public Annotation[] getDeclaredAnnotations(Class clazz) {
        return this.declaredAnnotations(clazz).values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    private synchronized Map<Class, Annotation> declaredAnnotations(Class clazz) {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations((byte[])this.annotations, (ConstantPool)Access.lang().getConstantPool(clazz), (Class)clazz);
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue(Class clazz, Class clazz2, Object object) {
        Object object2;
        Object object3 = object2 = this.annotationDefault == null ? null : this.parseMemberValue(clazz, clazz2);
        if (object2 instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + object);
        }
        return object2;
    }

    private Object parseMemberValue(Class clazz, Class clazz2) {
        return AnnotationParser.parseMemberValue(AnnotationType.invocationHandlerReturnType(clazz2), (ByteBuffer)ByteBuffer.wrap(this.annotationDefault), (ConstantPool)Access.lang().getConstantPool(clazz), (Class)clazz);
    }

    public Annotation[][] getParameterAnnotations(Class clazz) {
        if (this.parameterAnnotations == null) {
            return new Annotation[this.numParameters][0];
        }
        Annotation[][] annotationArray = AnnotationParser.parseParameterAnnotations((byte[])this.parameterAnnotations, (ConstantPool)Access.lang().getConstantPool(clazz), (Class)clazz);
        if (annotationArray.length != this.numParameters) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return annotationArray;
    }
}

