/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.Field;
import jrockit.reflect.FieldAccessorImpl;
import jrockit.vm.Memory;

public class FloatFieldAccessor
extends FieldAccessorImpl {
    public FloatFieldAccessor(Field field) {
        super(field);
    }

    public Object get(Object object) throws IllegalArgumentException {
        return new Float(this.getFloat(object));
    }

    public boolean getBoolean(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public byte getByte(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public char getChar(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public short getShort(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public int getInt(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public long getLong(Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public float getFloat(Object object) throws IllegalArgumentException {
        this.ensureObj(object);
        return Memory.getFloat(object, this.fieldOffset);
    }

    public double getDouble(Object object) throws IllegalArgumentException {
        return this.getFloat(object);
    }

    public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            throw new IllegalAccessException("Field is final");
        }
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        if (object2 instanceof Byte) {
            Memory.setFloat(object, this.fieldOffset, (float)((Byte)object2).byteValue());
            return;
        }
        if (object2 instanceof Short) {
            Memory.setFloat(object, this.fieldOffset, (float)((Short)object2).shortValue());
            return;
        }
        if (object2 instanceof Character) {
            Memory.setFloat(object, this.fieldOffset, (float)((Character)object2).charValue());
            return;
        }
        if (object2 instanceof Integer) {
            Memory.setFloat(object, this.fieldOffset, (float)((Integer)object2).intValue());
            return;
        }
        if (object2 instanceof Long) {
            Memory.setFloat(object, this.fieldOffset, (float)((Long)object2).longValue());
            return;
        }
        if (object2 instanceof Float) {
            Memory.setFloat(object, this.fieldOffset, ((Float)object2).floatValue());
            return;
        }
        throw new IllegalArgumentException();
    }

    public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
        throw new IllegalArgumentException();
    }

    public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, by);
    }

    public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, c);
    }

    public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, s);
    }

    public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, n);
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setFloat(object, l);
    }

    public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
        this.ensureObj(object);
        if (this.isFinal) {
            throw new IllegalAccessException("Field is final");
        }
        Memory.setFloat(object, this.fieldOffset, f);
    }

    public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
        throw new IllegalArgumentException();
    }
}

