/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.WeakHashMap;
import jrockit.reflect.CompiledConstructorInvoker;
import jrockit.reflect.CompiledMethodInvoker;
import jrockit.reflect.ConstructorInvoker;
import jrockit.reflect.MethodInvoker;
import jrockit.vm.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InvocationCompiler {
    private static InvocationCompiler compiler = new InvocationCompiler();
    private WeakHashMap<Class, HashMap<MemberKey, Object>> classMap = new WeakHashMap();

    private InvocationCompiler() {
    }

    public static InvocationCompiler compilerFor(ClassLoader classLoader) {
        return compiler;
    }

    private synchronized HashMap<MemberKey, Object> mapFor(Class clazz) {
        HashMap<MemberKey, Object> hashMap = this.classMap.get(clazz);
        if (hashMap == null) {
            hashMap = new HashMap(3);
            this.classMap.put(clazz, hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object compileInvoker(int n, Class clazz, Class clazz2, AccessibleObject accessibleObject) {
        Class clazz3 = clazz;
        synchronized (clazz3) {
            MemberKey memberKey = new MemberKey(accessibleObject);
            HashMap<MemberKey, Object> hashMap = this.mapFor(clazz);
            Object object = hashMap.get(memberKey);
            if (object != null) {
                return object;
            }
            int n2 = InvocationCompiler.compile(n, clazz2);
            assert (n2 != 0);
            object = accessibleObject instanceof Constructor ? new CompiledConstructorInvoker((Constructor)accessibleObject, n2) : new CompiledMethodInvoker((Method)accessibleObject, n2);
            Object object2 = hashMap.put(memberKey, object);
            assert (object2 == null);
            return object;
        }
    }

    public MethodInvoker compileInvoker(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        return (CompiledMethodInvoker)this.compileInvoker(Reflect.IMethod.getID(method), clazz, null, method);
    }

    public ConstructorInvoker compileInvoker(Constructor constructor, Class clazz) {
        return (ConstructorInvoker)this.compileInvoker(Reflect.IConstructor.getID(constructor), clazz, clazz, constructor);
    }

    private static native int compile(int var0, Class var1);

    public static native void compileNewInstance(Class var0);

    private static class MemberKey {
        private int iname;
        private int idesc;

        private MemberKey(int n, int n2) {
            this.iname = n;
            this.idesc = n2;
        }

        public MemberKey(AccessibleObject accessibleObject) {
            this(Reflect.IAccessibleObject.getIName(accessibleObject), Reflect.IAccessibleObject.getIDescriptor(accessibleObject));
        }

        public boolean equals(Object object) {
            if (object instanceof MemberKey) {
                MemberKey memberKey = (MemberKey)object;
                return this.iname == memberKey.iname && memberKey.idesc == this.idesc;
            }
            return false;
        }
    }
}

