/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import jrockit.reflect.BooleanFieldAccessor;
import jrockit.reflect.ByteFieldAccessor;
import jrockit.reflect.CharFieldAccessor;
import jrockit.reflect.ConstructorInvoker;
import jrockit.reflect.DoubleFieldAccessor;
import jrockit.reflect.EmptyConstructorInvoker;
import jrockit.reflect.FieldAccessor;
import jrockit.reflect.FloatFieldAccessor;
import jrockit.reflect.InitialConstructorInvoker;
import jrockit.reflect.InitialMethodInvoker;
import jrockit.reflect.InstantiationExceptionConstructorInvoker;
import jrockit.reflect.IntFieldAccessor;
import jrockit.reflect.InvocationCompiler;
import jrockit.reflect.LongFieldAccessor;
import jrockit.reflect.MethodInvoker;
import jrockit.reflect.NativeConstructorInvoker;
import jrockit.reflect.NativeMethodInvoker;
import jrockit.reflect.ObjectFieldAccessor;
import jrockit.reflect.ShortFieldAccessor;
import jrockit.reflect.StaticBooleanFieldAccessor;
import jrockit.reflect.StaticByteFieldAccessor;
import jrockit.reflect.StaticCharFieldAccessor;
import jrockit.reflect.StaticDoubleFieldAccessor;
import jrockit.reflect.StaticFloatFieldAccessor;
import jrockit.reflect.StaticIntFieldAccessor;
import jrockit.reflect.StaticLongFieldAccessor;
import jrockit.reflect.StaticObjectFieldAccessor;
import jrockit.reflect.StaticShortFieldAccessor;
import jrockit.reflect.VirtualNativeMethodInvoker;
import jrockit.vm.Reflect;
import jrockit.vm.VM;

public class MemberAccess {
    private static LangReflect langReflect;

    public static Class getClassFromFieldDesc(String string, ClassLoader classLoader) {
        return MemberAccess.getClassFromFieldDesc(string, 0, classLoader);
    }

    public static Class getReturnClassFromMethodDesc(String string, ClassLoader classLoader) {
        int n = 1;
        while (string.charAt(n++) != ')') {
        }
        return MemberAccess.getClassFromFieldDesc(string, n, classLoader);
    }

    private static Class getClassFromFieldDesc(String string, int n, ClassLoader classLoader) {
        try {
            switch (string.charAt(n)) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case '[': {
                    return Class.forName(string.substring(n).replace('/', '.'), false, classLoader);
                }
                case 'L': {
                    return Class.forName(string.substring(n + 1, string.length() - 1).replace('/', '.'), false, classLoader);
                }
            }
            throw new InternalError("invalid descriptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static int countParams(String string) {
        int n = 1;
        int n2 = 0;
        block6: while (true) {
            switch (string.charAt(n++)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++n2;
                    continue block6;
                }
                case '[': {
                    continue block6;
                }
                case 'L': {
                    while (string.charAt(n++) != ';') {
                    }
                    ++n2;
                    continue block6;
                }
                case ')': {
                    return n2;
                }
            }
            break;
        }
        throw new InternalError("invalid descriptor");
    }

    public static Class[] getClassesFromMethodDesc(String string, ClassLoader classLoader) {
        int n = 1;
        int n2 = 0;
        int n3 = MemberAccess.countParams(string);
        Class[] classArray = new Class[n3];
        while (true) {
            try {
                Class<Comparable<Byte>> clazz;
                switch (string.charAt(n)) {
                    case 'B': {
                        clazz = Byte.TYPE;
                        ++n;
                        break;
                    }
                    case 'Z': {
                        clazz = Boolean.TYPE;
                        ++n;
                        break;
                    }
                    case 'S': {
                        clazz = Short.TYPE;
                        ++n;
                        break;
                    }
                    case 'C': {
                        clazz = Character.TYPE;
                        ++n;
                        break;
                    }
                    case 'I': {
                        clazz = Integer.TYPE;
                        ++n;
                        break;
                    }
                    case 'J': {
                        clazz = Long.TYPE;
                        ++n;
                        break;
                    }
                    case 'F': {
                        clazz = Float.TYPE;
                        ++n;
                        break;
                    }
                    case 'D': {
                        clazz = Double.TYPE;
                        ++n;
                        break;
                    }
                    case '[': {
                        int n4 = n;
                        while (string.charAt(++n) == '[') {
                        }
                        if (string.charAt(n++) == 'L') {
                            while (string.charAt(n++) != ';') {
                            }
                            clazz = Class.forName(string.substring(n4, n).replace('/', '.'), false, classLoader);
                            break;
                        }
                        clazz = Class.forName(string.substring(n4, n), false, null);
                        break;
                    }
                    case 'L': {
                        int n4 = ++n;
                        while (string.charAt(n++) != ';') {
                        }
                        clazz = Class.forName(string.substring(n4, n - 1).replace('/', '.'), false, classLoader);
                        break;
                    }
                    case ')': {
                        return classArray;
                    }
                    default: {
                        throw new InternalError("invalid descriptor");
                    }
                }
                classArray[n2++] = clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static FieldAccessor newFieldAccessor(Field field) {
        Class<?> clazz = field.getType();
        if (Modifier.isStatic(field.getModifiers())) {
            if (clazz == Boolean.TYPE) {
                return new StaticBooleanFieldAccessor(field);
            }
            if (clazz == Byte.TYPE) {
                return new StaticByteFieldAccessor(field);
            }
            if (clazz == Short.TYPE) {
                return new StaticShortFieldAccessor(field);
            }
            if (clazz == Character.TYPE) {
                return new StaticCharFieldAccessor(field);
            }
            if (clazz == Integer.TYPE) {
                return new StaticIntFieldAccessor(field);
            }
            if (clazz == Long.TYPE) {
                return new StaticLongFieldAccessor(field);
            }
            if (clazz == Float.TYPE) {
                return new StaticFloatFieldAccessor(field);
            }
            if (clazz == Double.TYPE) {
                return new StaticDoubleFieldAccessor(field);
            }
            return new StaticObjectFieldAccessor(field);
        }
        if (clazz == Boolean.TYPE) {
            return new BooleanFieldAccessor(field);
        }
        if (clazz == Byte.TYPE) {
            return new ByteFieldAccessor(field);
        }
        if (clazz == Short.TYPE) {
            return new ShortFieldAccessor(field);
        }
        if (clazz == Character.TYPE) {
            return new CharFieldAccessor(field);
        }
        if (clazz == Integer.TYPE) {
            return new IntFieldAccessor(field);
        }
        if (clazz == Long.TYPE) {
            return new LongFieldAccessor(field);
        }
        if (clazz == Float.TYPE) {
            return new FloatFieldAccessor(field);
        }
        if (clazz == Double.TYPE) {
            return new DoubleFieldAccessor(field);
        }
        return new ObjectFieldAccessor(field);
    }

    public static FieldAccessor newFieldAccessor(Field field, boolean bl) {
        Reflect.IClass.ensureInitialized(field.getDeclaringClass());
        FieldAccessor fieldAccessor = MemberAccess.newFieldAccessor(field);
        if (bl) {
            fieldAccessor.isFinal = false;
        }
        return fieldAccessor;
    }

    private static MethodInvoker newMethodInvoker0(Method method) {
        if (MemberAccess.forceCompiledInvokers()) {
            return InvocationCompiler.compilerFor(method.getDeclaringClass().getClassLoader()).compileInvoker(method);
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return new NativeMethodInvoker(method);
        }
        return new VirtualNativeMethodInvoker(method);
    }

    public static MethodInvoker newMethodInvoker(Method method) {
        MethodInvoker methodInvoker = MemberAccess.newMethodInvoker0(method);
        return Reflect.IClass.isInitialized(method.getDeclaringClass()) ? methodInvoker : new InitialMethodInvoker(method, methodInvoker);
    }

    public static ConstructorInvoker newConstructorInvoker(Constructor constructor) {
        return MemberAccess.newConstructorInvoker(constructor, constructor.getDeclaringClass());
    }

    private static ConstructorInvoker newConstructorInvoker0(Constructor constructor, Class clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return new InstantiationExceptionConstructorInvoker(constructor);
        }
        if (!Reflect.IConstructor.isEmptyVoid(constructor)) {
            if (MemberAccess.forceCompiledInvokers()) {
                return InvocationCompiler.compilerFor(constructor.getDeclaringClass().getClassLoader()).compileInvoker(constructor, clazz);
            }
            return new NativeConstructorInvoker(constructor, clazz);
        }
        return new EmptyConstructorInvoker(constructor, clazz);
    }

    public static ConstructorInvoker newConstructorInvoker(Constructor constructor, Class clazz) {
        ConstructorInvoker constructorInvoker = MemberAccess.newConstructorInvoker0(constructor, clazz);
        return Reflect.IClass.isInitialized(clazz) ? constructorInvoker : new InitialConstructorInvoker(clazz, constructor, constructorInvoker);
    }

    public static Constructor newConstructorForSerialization(Constructor constructor, Class clazz) {
        if (!Reflect.IConstructor.isEmptyVoid(constructor)) {
            throw new IllegalArgumentException("cannot create serialization invoker for non-void constructor: " + constructor);
        }
        if (clazz != constructor.getDeclaringClass()) {
            constructor = MemberAccess.newConstructor(Reflect.IConstructor.getID(constructor));
            MemberAccess.setConstructorInvoker(constructor, MemberAccess.newConstructorInvoker(constructor, clazz));
        }
        return constructor;
    }

    public static boolean quickCheckAccess(Class clazz, int n) {
        return Modifier.isPublic(clazz.getModifiers() & n);
    }

    public static void ensureAccess(Class clazz, Class clazz2, Object object, int n) throws IllegalAccessException {
        if (clazz == null || clazz2 == null) {
            throw new InternalError();
        }
        if (!MemberAccess.verifyAccess(clazz, clazz2, object, n)) {
            throw new IllegalAccessException("Class " + clazz.getName() + " can not access a member of class " + clazz2.getName() + " with modifiers \"" + Modifier.toString(n) + "\"");
        }
    }

    public static boolean verifyAccess(Class clazz, Class clazz2, Object object, int n) {
        boolean bl = false;
        boolean bl2 = false;
        if (clazz == clazz2) {
            return true;
        }
        if (!Modifier.isPublic(Reflect.IClass.getAccessFlags(clazz2))) {
            bl2 = MemberAccess.isSameClassPackage(clazz, clazz2);
            bl = true;
            if (!bl2) {
                return false;
            }
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        boolean bl3 = false;
        if (Modifier.isProtected(n) && MemberAccess.isSubclassOf(clazz, clazz2)) {
            bl3 = true;
        }
        if (!bl3 && !Modifier.isPrivate(n)) {
            if (!bl) {
                bl2 = MemberAccess.isSameClassPackage(clazz, clazz2);
                bl = true;
            }
            if (bl2) {
                bl3 = true;
            }
        }
        if (!bl3) {
            return false;
        }
        if (Modifier.isProtected(n)) {
            Class<? extends Object> clazz3;
            Class<? extends Object> clazz4 = clazz3 = object == null ? clazz2 : object.getClass();
            if (clazz3 != clazz) {
                if (!bl) {
                    bl2 = MemberAccess.isSameClassPackage(clazz, clazz2);
                    bl = true;
                }
                if (!bl2 && !MemberAccess.isSubclassOf(clazz3, clazz)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isSameClassPackage(Class clazz, Class clazz2) {
        return MemberAccess.isSameClassPackage(Reflect.IClass.getID(clazz), Reflect.IClass.getID(clazz2));
    }

    private static boolean isSameClassPackage(int n, int n2) {
        if (Reflect.IClass.getClassLoaderID(n) != Reflect.IClass.getClassLoaderID(n2)) {
            return false;
        }
        return Reflect.IClass.isSamePackage(n, n2);
    }

    private static boolean isSameClassPackage(ClassLoader classLoader, String string, ClassLoader classLoader2, String string2) {
        int n;
        int n2;
        if (classLoader != classLoader2) {
            return false;
        }
        int n3 = string.lastIndexOf(46);
        int n4 = string2.lastIndexOf(46);
        if (n3 == -1 || n4 == -1) {
            return n3 == n4;
        }
        int n5 = 0;
        int n6 = 0;
        if (string.charAt(n5) == '[') {
            while (string.charAt(++n5) == '[') {
            }
            if (string.charAt(n5) != 'L') {
                throw new InternalError("Illegal class name " + string);
            }
        }
        if (string2.charAt(n6) == '[') {
            while (string2.charAt(++n6) == '[') {
            }
            if (string2.charAt(n6) != 'L') {
                throw new InternalError("Illegal class name " + string2);
            }
        }
        if ((n2 = n3 - n5) != (n = n4 - n6)) {
            return false;
        }
        return string.regionMatches(false, n5, string2, n6, n2);
    }

    static boolean isSubclassOf(Class clazz, Class clazz2) {
        return Reflect.IClass.isAssignableNormal(clazz2, clazz);
    }

    private static void illegal(int n, int n2, int n3) throws IllegalAccessException {
        throw new IllegalAccessException("Class " + Reflect.IClass.get(n).getName() + " can not access a member of class " + Reflect.IClass.get(n2).getName() + " with modifiers \"" + Modifier.toString(n3) + "\"");
    }

    private static void ensurePrivate(int n, int n2, int n3) throws IllegalAccessException {
        if (n != n2) {
            MemberAccess.illegal(n, n2, n3);
        }
    }

    private static void ensureProtected(int n, int n2, int n3) throws IllegalAccessException {
        if (!Reflect.IClassBlock.isAssignableNormal(n2, n)) {
            MemberAccess.ensurePackage(n, n2, n3);
        }
    }

    private static void ensurePackage(int n, int n2, int n3) throws IllegalAccessException {
        if (!MemberAccess.isSameClassPackage(n, n2)) {
            MemberAccess.illegal(n, n2, n3);
        }
    }

    public static Method newMethod(int n) {
        return MemberAccess.langReflect().newMethod(n);
    }

    public static Constructor newConstructor(int n) {
        return MemberAccess.langReflect().newConstructor(n);
    }

    public static Field newField(int n) {
        return MemberAccess.langReflect().newField(n);
    }

    public static Method copy(Method method) {
        return MemberAccess.langReflect().copy(method);
    }

    public static Constructor copy(Constructor constructor) {
        return MemberAccess.langReflect().copy(constructor);
    }

    public static Field copy(Field field) {
        return MemberAccess.langReflect().copy(field);
    }

    public static void setMethodInvoker(Method method, MethodInvoker methodInvoker) {
        MemberAccess.langReflect().setMethodInvoker(method, methodInvoker);
    }

    public static void setConstructorInvoker(Constructor constructor, ConstructorInvoker constructorInvoker) {
        MemberAccess.langReflect().setConstructorInvoker(constructor, constructorInvoker);
    }

    public static MethodInvoker getMethodInvoker(Method method) {
        return MemberAccess.langReflect().getMethodInvoker(method);
    }

    public static ConstructorInvoker getConstructorInvoker(Constructor constructor) {
        return MemberAccess.langReflect().getConstructorInvoker(constructor);
    }

    public static FieldAccessor getFieldAccessor(Field field) {
        return MemberAccess.langReflect().getFieldAccessor(field);
    }

    public static LangReflect langReflect() {
        if (langReflect == null) {
            try {
                Class<?> clazz = Class.forName("java.lang.reflect.LangReflectImpl", true, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InternalError("could not resolve reflection accessor");
            }
        }
        return langReflect;
    }

    public static void setLangReflect(LangReflect langReflect) {
        MemberAccess.langReflect = langReflect;
    }

    static boolean forceCompiledInvokers() {
        return VM.createCompiledInvokers && VM.compiledInvokerThreshold == 0;
    }

    public static abstract class LangReflect {
        public abstract Method newMethod(int var1);

        public abstract Constructor newConstructor(int var1);

        public abstract Field newField(int var1);

        public abstract Method copy(Method var1);

        public abstract Constructor copy(Constructor var1);

        public abstract Field copy(Field var1);

        public abstract void setMethodInvoker(Method var1, MethodInvoker var2);

        public abstract void setConstructorInvoker(Constructor var1, ConstructorInvoker var2);

        public abstract MethodInvoker getMethodInvoker(Method var1);

        public abstract ConstructorInvoker getConstructorInvoker(Constructor var1);

        public abstract FieldAccessor getFieldAccessor(Field var1);
    }
}

