/*
 * Decompiled with CFR 0.152.
 */
package jrockit.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jrockit.reflect.NativeMethodInvoker;
import jrockit.vm.Reflect;

class VirtualNativeMethodInvoker
extends NativeMethodInvoker {
    private final int typeClassBlock;

    VirtualNativeMethodInvoker(Method method) {
        super(method);
        this.typeClassBlock = Reflect.IClassBlock.getCB(method.getDeclaringClass());
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalArgumentException, InvocationTargetException {
        try {
            if (!Reflect.IClassBlock.isAssignable(this.typeClassBlock, object)) {
                throw new IllegalArgumentException();
            }
            return super.invoke(object, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(this.method.getDeclaringClass().getName() + "." + this.method.getName() + " invoked on null object");
        }
    }
}

