/*
 * Decompiled with CFR 0.152.
 */
package jrockit.rls;

import java.io.BufferedWriter;
import java.io.IOException;
import jrockit.rls.Action;
import jrockit.rls.Rls;
import jrockit.rls.State;

public final class VmAdapter {
    private static double previousMemory;
    private static BufferedWriter buf;
    private static Object gcEndedNotifyObject;

    public static native long getHeapSize();

    public static native long getCurrentFreeListSize();

    public static native boolean outOfMemoryHasOccurred();

    public static native void invokeGarbageCollection();

    public static native int getCurrentPhase();

    public static native int getGC();

    private VmAdapter() {
    }

    public static boolean approvedGC() {
        int n = 2;
        int n2 = 3;
        int n3 = VmAdapter.getGC();
        return n3 == n2 || n3 == n;
    }

    public static void measure() {
        previousMemory = 100.0;
    }

    public static State initState(State state) {
        double d;
        double d2 = 0.0;
        long[] lArray = state.getStateFeatureValues();
        boolean bl = true;
        int n = 0;
        d2 = VmAdapter.freeMemPercentage();
        if (state.isPresent(3)) {
            double d3 = previousMemory - d2;
            d = 0.0;
            while (bl) {
                if (d3 <= d) {
                    lArray[n] = 1L;
                    break;
                }
                d += 0.02;
                ++n;
                if (!(d > 0.1)) continue;
                lArray[n] = 1L;
                break;
            }
        }
        if (state.isPresent(2)) {
            double d4 = VmAdapter.fragmentedMemPercentage();
            d = 0.1;
            while (bl) {
                if (d4 <= d) {
                    lArray[n] = 1L;
                    break;
                }
                d += 0.1;
                ++n;
                if (!(d > 0.3)) continue;
                lArray[n] = 1L;
                break;
            }
        }
        if (state.isPresent(1)) {
            d = 0.08;
            while (bl) {
                if (d2 <= d) {
                    lArray[n] = 1L;
                    break;
                }
                d += 0.02;
                ++n;
                if (!(d > 0.18)) continue;
                lArray[n] = 1L;
                break;
            }
            previousMemory = d2;
        }
        return state;
    }

    public static double freeMemPercentage() {
        long l = VmAdapter.getHeapSize();
        long l2 = VmAdapter.getCurrentFreeListSize();
        double d = (double)l2 / (double)l;
        return d;
    }

    public static double fragmentedMemPercentage() {
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyGcEnded() {
        Object object = gcEndedNotifyObject;
        synchronized (object) {
            gcEndedNotifyObject.notify();
        }
    }

    public static double calculateReward(Action action) {
        double d = 0.0;
        switch (action.getID()) {
            case 0: {
                break;
            }
            case 1: {
                d += -10.0;
                break;
            }
            default: {
                System.err.println("No actions could be penalty evaluated.");
            }
        }
        if (VmAdapter.outOfMemoryHasOccurred()) {
            d += -500.0;
            System.out.println("Out of memory has occured");
        }
        try {
            buf.write(Rls.getCurrentTimeStep() + " " + d);
            buf.newLine();
        }
        catch (IOException iOException) {
            System.out.println("Error writing penalty info");
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void perform(Action action) {
        boolean bl = false;
        switch (action.getID()) {
            case 0: {
                break;
            }
            case 1: {
                VmAdapter.invokeGarbageCollection();
                bl = true;
                break;
            }
            default: {
                System.err.println("No action was performed.");
            }
        }
        if (bl) {
            try {
                Object object = gcEndedNotifyObject;
                synchronized (object) {
                    gcEndedNotifyObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("InterruptedException thrown in COMJRockitRLSThread.java");
            }
        }
    }

    static {
        gcEndedNotifyObject = new Object();
    }
}

