/*
 * Decompiled with CFR 0.152.
 */
package jrockit.vm;

import java.lang.ref.ReferenceQueue;
import jrockit.annotations.NoSafePoint;
import jrockit.vm.Intrinsics;
import jrockit.vm.Memory;
import jrockit.vm.ObjectMonitor;
import jrockit.vm.Reflect;
import jrockit.vm.Threads;
import jrockit.vm.VM;

public final class Locks
extends VM {
    public static final int STATE_ACTIVE = 0;
    public static final int STATE_WAITING = 1;
    public static final int STATE_BLOCKED = 2;
    public static final int STATE_SPINBLOCKED = 3;
    private static final int INITIAL_MON_SIZE = 16;
    public static ObjectMonitor[] monitors = new ObjectMonitor[16];
    private static int[] freeMonitors = new int[16];
    private static int maxUsedMonitor = 0;
    private static int nFreeMonitors = 0;
    private static Object monitorLock = new Object();
    public static boolean threadContentionMonitoringIsEnabled = false;
    private static ReferenceQueue omrq = new ReferenceQueue();

    public static native void monitorEnterUnmatched(Object var0);

    public static native void monitorExitUnmatched(Object var0);

    public static native void monitorExitUnmatchedPopFrame(Object var0, int var1);

    private static native void convertThinLockedToFatLocked(Object var0);

    private static native void convertFatLockedToThinLocked(Object var0);

    private static native void profMonitorWait(Object var0, long var1);

    private static native void profMonitorWaited(Object var0, boolean var1);

    private static native void profMonitorContendedEnter(Object var0);

    private static native void profMonitorContendedEntered(Object var0);

    private static native void jvmpiMonitorContendedExit(Object var0);

    public static native void notifyRawMonitor(int var0);

    public static boolean monitorEnterForced(Object object) {
        Object object2 = Locks.monitorEnter(object);
        return (Memory.objectAsAddress(object2) & 7) != 5;
    }

    public static void monitorExitForced(Object object) throws Throwable {
        if ((Memory.getInt(object, 4) & 1) == 1) {
            Locks.unlockFat(object, Threads.getCurrentVMThread(), Locks.getMonitorAndReserve(object));
        } else {
            Locks.monitorExit(Memory.getLockToken(object, 1));
        }
    }

    private static int getThinLockOwner(Object object) {
        short s = Memory.getShort(object, 4);
        if ((s & 1) == 0) {
            return s & 0xFFFE;
        }
        return -1;
    }

    private static void waitForSpinLockRelease(Object object) {
        while (true) {
            if (VM.isSMP) {
                for (int i = VM.monitorContendedPollCount; i > 0; --i) {
                    for (int j = VM.monitorContendedSpinCount; j > 0; --j) {
                        Intrinsics.microPause();
                    }
                    if ((Memory.getInt(object, 4) & 1) != 0) continue;
                    return;
                }
            } else if ((Memory.getInt(object, 4) & 1) == 0) {
                return;
            }
            Threads.shortNap(1);
        }
    }

    private static void spinLockEnter(Object object) {
        int n;
        int n2;
        int n3;
        while ((n3 = Memory.getInt(object, 4) & 0xFFFFFFFE) != (n2 = Memory.cas(object, 4, n3, n = n3 | 1))) {
            Locks.waitForSpinLockRelease(object);
        }
        return;
    }

    private static void spinLockExit(Object object) {
        short s = Memory.getShort(object, 4);
        s = (short)(s & 0xFFFFFFFE);
        Intrinsics.membar(0);
        Memory.setShort(object, 4, s);
    }

    private static void releaseMonitorReservation(Object object) {
        short s = Memory.getShort(object, 4);
        s = (short)(s & 0xFFFFFFFD);
        Intrinsics.membar(0);
        Memory.setShort(object, 4, s);
    }

    public static boolean isMonitorReserved(Object object) {
        int n = Memory.getInt(object, 4);
        return (n & 3) == 3;
    }

    public static void waitForMonitorRelease(Object object) {
        while (true) {
            if (VM.isSMP) {
                for (int i = VM.monitorContendedPollCount; i > 0; --i) {
                    for (int j = VM.monitorContendedSpinCount; j > 0; --j) {
                        Intrinsics.microPause();
                    }
                    if (Locks.isMonitorReserved(object)) continue;
                    return;
                }
            } else if (!Locks.isMonitorReserved(object)) {
                return;
            }
            Threads.shortNap(1);
        }
    }

    private static ObjectMonitor getMonitorAndReserve(Object object) {
        boolean bl = false;
        while (true) {
            int n;
            int n2;
            int n3 = Memory.getInt(object, 4);
            int n4 = (n3 & 0xFFFFFC) >>> 2;
            if ((n3 & 1) != 1) {
                return null;
            }
            if ((n3 &= 0xFFFFFFFD) == (n2 = Memory.cas(object, 4, n3, n = n3 | 2))) {
                if (VM.lockProfilingEnabled) {
                    int n5 = Reflect.IClassBlock.getCB(object);
                    if (bl) {
                        Reflect.IClassBlock.incrFLReserveBitContended(n5);
                    } else {
                        Reflect.IClassBlock.incrFLReserveBitUncontended(n5);
                    }
                }
                ObjectMonitor objectMonitor = monitors[n4];
                Intrinsics.prefetch(objectMonitor);
                return objectMonitor;
            }
            Locks.waitForMonitorRelease(object);
            if (!VM.lockProfilingEnabled) continue;
            bl = true;
        }
    }

    public static boolean isThinLocked(Object object) {
        short s = Memory.getShort(object, 4);
        return (s & 1) != 1 && (s & 0xFFFE) != 0;
    }

    public static int waitForThinRelease(Object object, int n) {
        while (Locks.isThinLocked(object)) {
            if (VM.isSMP && n > 0) {
                for (int i = VM.thinLockContendedPollCount; i > 0; --i) {
                    for (int j = VM.thinLockContendedSpinCount; j > 0; --j) {
                        Intrinsics.microPause();
                    }
                    if (Locks.isThinLocked(object)) continue;
                    return n;
                }
            }
            Threads.shortNap(n--);
        }
        return n;
    }

    public static Object monitorEnterSecondStage(Object object, int n) throws Throwable {
        ObjectMonitor objectMonitor;
        boolean bl = false;
        int n2 = Threads.getCurrentVMThread();
        Thread thread = Threads.getThread(n2);
        Object object2 = null;
        int n3 = VM.thinLockConvertToFatThreshold;
        long l = 0L;
        boolean bl2 = false;
        Threads.setThreadStatus(thread, 1025);
        if (VM.profMonitors) {
            Locks.profMonitorContendedEnter(object);
        }
        while ((n & 1) != 1 || (objectMonitor = Locks.getMonitorAndReserve(object)) == null || (object2 = Locks.lockFat(object, n2, objectMonitor, bl2)) == null) {
            Threads.setBlockingOnObject(thread, object);
            if (!bl2) {
                Threads.incrementMonitorBlockedCount(n2);
                bl2 = true;
            }
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                l = System.currentTimeMillis();
            }
            n3 = Locks.waitForThinRelease(object, n3);
            n = Memory.getInt(object, 4);
            if ((n & 1) == 1) continue;
            if (VM.profMonitors || n3 <= 0) {
                bl = true;
            }
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
                l = System.currentTimeMillis() - l;
                Threads.incrementMonitorBlockedTime(n2, l);
                l = 0L;
            }
            if ((object2 = Locks.lockThin(object, true)) != null) {
                if (!bl) break;
                Locks.createMonitor(object, false);
                object2 = Memory.getLockToken(object, 6);
                break;
            }
            Threads.setBlockingOnObject(thread, null);
            n = Memory.getInt(object, 4);
        }
        Threads.setBlockingOnObject(thread, null);
        Threads.setThreadStatus(thread, 5);
        if (VM.profMonitors) {
            Locks.profMonitorContendedEntered(object);
        }
        return object2;
    }

    public static void monitorExitSecondStage(Object object) throws Throwable {
        Object object2 = Memory.getObjectFromToken(object);
        if ((Memory.objectAsAddress(object) & 7) == 6) {
            Locks.unlockFat(object2, Threads.getCurrentVMThread(), Locks.getMonitorAndReserve(object2));
        } else {
            Locks.monitorExitUnmatched(object2);
        }
    }

    public static boolean hasFatLock(Object object) {
        return (Memory.getInt(object, 4) & 1) == 1;
    }

    public static ObjectMonitor createMonitor(Object object, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = -1;
        ObjectMonitor objectMonitor = new ObjectMonitor(object, omrq);
        Locks.spinLockEnter(monitorLock);
        do {
            if (nFreeMonitors == 0) {
                if (maxUsedMonitor == monitors.length) {
                    n3 = monitors.length;
                    Locks.spinLockExit(monitorLock);
                    ObjectMonitor[] objectMonitorArray = new ObjectMonitor[n3 * 2];
                    Locks.spinLockEnter(monitorLock);
                    if (monitors.length != n3) continue;
                    System.arraycopy(monitors, 0, objectMonitorArray, 0, n3);
                    monitors = objectMonitorArray;
                }
                n4 = maxUsedMonitor++;
                continue;
            }
            n4 = freeMonitors[--nFreeMonitors];
        } while (n4 == -1);
        Locks.monitors[n4] = objectMonitor;
        Locks.spinLockExit(monitorLock);
        objectMonitor.currentTIdx = Threads.getThreadIndex(Threads.getCurrentVMThread());
        objectMonitor.mIndex = n4;
        objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
        while ((n2 = Memory.cas(object, 4, n3 = Memory.getInt(object, 4), n = n3 & 0xFF000000 | n4 << 2 | 1 | (bl ? 2 : 0))) != n3) {
        }
        return objectMonitor;
    }

    private static ObjectMonitor createMonitorAndConvert(Object object, boolean bl) {
        ObjectMonitor objectMonitor = Locks.createMonitor(object, bl);
        Locks.convertThinLockedToFatLocked(object);
        return objectMonitor;
    }

    private static void deflateFatLockAndUnlock(Object object) {
        int n;
        int n2;
        int n3;
        do {
            n2 = Memory.getInt(object, 4);
            n = n2 & 0xFF000000;
            Intrinsics.membar(0);
        } while ((n3 = Memory.cas(object, 4, n2, n)) != n2);
    }

    static void releaseMonitor(ObjectMonitor objectMonitor) {
        int n = objectMonitor.mIndex;
        Thread thread = Thread.currentThread();
        Locks.spinLockEnter(monitorLock);
        if (monitors[n] != objectMonitor) {
            Locks.spinLockExit(monitorLock);
            return;
        }
        Locks.monitors[n] = null;
        while (nFreeMonitors == freeMonitors.length) {
            int n2 = freeMonitors.length;
            Locks.spinLockExit(monitorLock);
            int[] nArray = new int[n2 * 2];
            Locks.spinLockEnter(monitorLock);
            if (freeMonitors.length != n2 || nFreeMonitors != n2) continue;
            System.arraycopy(freeMonitors, 0, nArray, 0, n2);
            freeMonitors = nArray;
        }
        Locks.freeMonitors[Locks.nFreeMonitors] = n;
        ++nFreeMonitors;
        Locks.spinLockExit(monitorLock);
    }

    private static ObjectMonitor getMonitorWithCheck(Object object, Thread thread, boolean bl) throws IllegalMonitorStateException {
        ObjectMonitor objectMonitor = Locks.getMonitorAndReserve(object);
        int n = Threads.getThreadIndex(Threads.getVMThread(thread));
        boolean bl2 = false;
        if (objectMonitor != null && objectMonitor.currentTIdx == n) {
            bl2 = true;
            if (!bl) {
                Locks.releaseMonitorReservation(object);
            }
        } else if (objectMonitor == null && Locks.getThinLockOwner(object) == n) {
            bl2 = true;
        }
        if (!bl2) {
            if (objectMonitor != null) {
                Locks.releaseMonitorReservation(object);
            }
            throw new IllegalMonitorStateException();
        }
        return objectMonitor;
    }

    public static boolean isCurrentThreadHoldingLock(Object object) throws IllegalMonitorStateException {
        ObjectMonitor objectMonitor = Locks.getMonitorAndReserve(object);
        int n = Threads.getThreadIndex(Threads.getCurrentVMThread());
        boolean bl = false;
        if (objectMonitor != null) {
            if (objectMonitor.currentTIdx == n) {
                bl = true;
            }
            Locks.releaseMonitorReservation(object);
        } else if (Locks.getThinLockOwner(object) == n) {
            bl = true;
        }
        return bl;
    }

    public static void fatLockBlockOrSpin(int n, ObjectMonitor objectMonitor, int n2, int n3) {
        boolean bl;
        if (n3 == 3) {
            if (n2 < VM.numCPUs) {
                n3 = Locks.fatLockSpin(n);
            } else {
                Threads.shortNap(1);
                n3 = Threads.getLockState(n);
            }
        }
        if (n3 != 0 && (bl = n3 == 2 ? true : Threads.changeLockState(n, n3, 2))) {
            if (VM.useAdaptiveFatSpin) {
                objectMonitor.doNotSpin = true;
            }
            Threads.waitForSignal();
        }
    }

    public static Object lockFat(Object object, int n, ObjectMonitor objectMonitor, boolean bl) throws Throwable {
        int n2 = Threads.getThreadIndex(n);
        Thread thread = Threads.getThread(n);
        if (objectMonitor.currentTIdx == n2) {
            Locks.releaseMonitorReservation(object);
            if (VM.lockProfilingEnabled) {
                int n3 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrFatLockAcquiredRecursive(n3);
            }
            return Memory.getLockToken(object, 5);
        }
        if (objectMonitor.currentTIdx == 0 && (objectMonitor.lastHolderTIdx == 0 || objectMonitor.lastHolderTIdx == n2)) {
            boolean bl2;
            objectMonitor.currentTIdx = n2;
            boolean bl3 = bl2 = objectMonitor.lockQueue != null;
            if (VM.lockProfilingEnabled) {
                int n4 = Reflect.IClassBlock.getCB(object);
                if (bl2) {
                    Reflect.IClassBlock.incrFatLockAcquiredContended(n4);
                } else {
                    Reflect.IClassBlock.incrFatLockAcquired(n4);
                }
            }
            Locks.releaseMonitorReservation(object);
        } else {
            boolean bl4;
            long l = 0L;
            Threads.setBlockingOnObject(thread, object);
            boolean bl5 = bl4 = Threads.getBlockThreadStop(thread) == null;
            if (bl4) {
                Threads.setBlockThreadStop(thread, thread);
            }
            if (objectMonitor.lockLast != null) {
                Threads.setLockNext(objectMonitor.lockLast, thread);
            } else {
                objectMonitor.lockQueue = thread;
            }
            objectMonitor.lockLast = thread;
            int n5 = VM.useLockQueueLength ? objectMonitor.lockQueueLength++ : 1;
            int n6 = VM.useFatSpin ? (VM.useAdaptiveFatSpin ? (objectMonitor.doNotSpin ? 2 : 3) : 3) : 2;
            Threads.setLockState(n, n6);
            Locks.releaseMonitorReservation(object);
            if (!bl) {
                Threads.incrementMonitorBlockedCount(n);
                bl = true;
            }
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                l = System.currentTimeMillis();
            }
            Locks.fatLockBlockOrSpin(n, objectMonitor, n5, n6);
            Threads.setBlockingOnObject(thread, null);
            objectMonitor = Locks.fatLockReacquire(object, thread);
            if (objectMonitor == null) {
                if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
                    l = System.currentTimeMillis() - l;
                    Threads.incrementMonitorBlockedTime(n, l);
                }
                return null;
            }
            Locks.releaseMonitorReservation(object);
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
                l = System.currentTimeMillis() - l;
                Threads.incrementMonitorBlockedTime(n, l);
            }
            if (VM.lockProfilingEnabled) {
                int n7 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrFatLockAcquiredSleep(n7);
            }
            if (bl4) {
                Object object2 = Threads.getBlockThreadStop(thread);
                if (object2 != thread) {
                    Locks.unlockFatInternal(object, n, objectMonitor, true);
                    Threads.setBlockThreadStop(thread, null);
                    throw (Throwable)object2;
                }
                Threads.setBlockThreadStop(thread, null);
            }
        }
        return Memory.getLockToken(object, 6);
    }

    private static int fatLockSpin(int n) {
        int n2 = Threads.getLockState(n);
        for (int i = VM.fatLockContendedPollCount; i > 0 && n2 != 0; --i) {
            for (int j = VM.fatLockContendedSpinCount; j > 0; --j) {
                Intrinsics.microPause();
            }
            n2 = Threads.getLockState(n);
        }
        return n2;
    }

    private static ObjectMonitor fatLockReacquire(Object object, Thread thread) {
        Object var2_2 = null;
        int n = Threads.getVMThread(thread);
        int n2 = Threads.getThreadIndex(n);
        ObjectMonitor objectMonitor = Locks.getMonitorAndReserve(object);
        if (objectMonitor == null) {
            return objectMonitor;
        }
        if (VM.useFatLockDeflation) {
            objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
        }
        Threads.setBlockingOnObject(thread, object);
        while (objectMonitor.currentTIdx != 0) {
            Threads.setLockNext(thread, objectMonitor.lockQueue);
            objectMonitor.lockQueue = thread;
            if (objectMonitor.lockLast == null) {
                objectMonitor.lockLast = thread;
            }
            if (VM.useLockQueueLength) {
                ++objectMonitor.lockQueueLength;
            }
            objectMonitor.lastHolderTIdx = n2;
            int n3 = VM.useFatSpin ? (!VM.reacquireShouldAlwaysSpin && VM.useAdaptiveFatSpin ? (objectMonitor.doNotSpin ? 2 : 3) : 3) : 2;
            Threads.setLockState(n, n3);
            Locks.releaseMonitorReservation(object);
            Locks.fatLockBlockOrSpin(n, objectMonitor, 1, n3);
            objectMonitor = Locks.getMonitorAndReserve(object);
            if (objectMonitor == null) {
                Threads.setBlockingOnObject(thread, null);
                return objectMonitor;
            }
            if (!VM.useFatLockDeflation) continue;
            objectMonitor.fatLockDeflationCount = VM.fatLockDeflationThreshold;
        }
        objectMonitor.currentTIdx = n2;
        Threads.setBlockingOnObject(thread, null);
        return objectMonitor;
    }

    public static void unlockFat(Object object, int n, ObjectMonitor objectMonitor) throws Throwable {
        Thread thread = Threads.getThread(n);
        Threads.setBlockThreadStop(thread, thread);
        Locks.unlockFatInternal(object, n, objectMonitor, true);
        Object object2 = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object2 != thread) {
            throw (Throwable)object2;
        }
    }

    public static void unlockFatInternal(Object object, int n, ObjectMonitor objectMonitor, boolean bl) {
        int n2 = Threads.getThreadIndex(n);
        objectMonitor.currentTIdx = 0;
        if (objectMonitor.lockQueue == null) {
            int n3;
            objectMonitor.lastHolderTIdx = 0;
            if (VM.useAdaptiveFatSpin) {
                objectMonitor.doNotSpin = false;
            }
            if (VM.useFatLockDeflation && objectMonitor.waitQueue == null && (n3 = --objectMonitor.fatLockDeflationCount) == 0) {
                Locks.deflateFatLockAndUnlock(object);
                Locks.releaseMonitor(objectMonitor);
                return;
            }
            Locks.releaseMonitorReservation(object);
        } else if (objectMonitor.lastHolderTIdx == n2) {
            Locks.releaseMonitorReservation(object);
        } else {
            int n4;
            objectMonitor.lastHolderTIdx = n2;
            Thread thread = objectMonitor.lockQueue;
            int n5 = Threads.getVMThread(thread);
            objectMonitor.lockQueue = Threads.getLockNext(thread);
            Threads.setLockNext(thread, null);
            if (objectMonitor.lockQueue == null) {
                objectMonitor.lockLast = null;
            }
            if (VM.useLockQueueLength) {
                --objectMonitor.lockQueueLength;
            }
            Locks.releaseMonitorReservation(object);
            if (VM.jvmpiMonitors && bl) {
                Locks.jvmpiMonitorContendedExit(objectMonitor);
            }
            if ((n4 = Threads.getLockState(n5)) == 3 && !Threads.changeLockState(n5, n4, 0)) {
                n4 = 2;
            }
            if (n4 == 2) {
                Threads.setLockState(n5, 0);
                Threads.signalWaiter(n5);
            }
        }
    }

    private static void notify(Object object) throws Throwable {
        Thread thread = Thread.currentThread();
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, thread, false);
        if (objectMonitor == null) {
            return;
        }
        Threads.setBlockThreadStop(thread, thread);
        Thread thread2 = objectMonitor.waitQueue;
        if (thread2 != null) {
            int n = Threads.getVMThread(thread2);
            objectMonitor.waitQueue = Threads.getWaitNext(thread2);
            if (objectMonitor.waitQueue == null) {
                objectMonitor.waitLast = null;
            }
            if (Threads.changeLockState(n, 1, 2)) {
                objectMonitor = Locks.getMonitorAndReserve(object);
                if (objectMonitor.lockLast != null) {
                    Threads.setLockNext(objectMonitor.lockLast, thread2);
                } else {
                    objectMonitor.lockQueue = thread2;
                }
                objectMonitor.lockLast = thread2;
                Locks.releaseMonitorReservation(object);
            }
        }
        Object object2 = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object2 != thread) {
            throw (Throwable)object2;
        }
    }

    public static native void notifySpecific(Object var0, Thread var1);

    public static void notifySpecificInner(Object object, Thread thread) throws Throwable {
        int n;
        Object object2;
        Thread thread2 = Thread.currentThread();
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, thread2, false);
        if (objectMonitor == null) {
            return;
        }
        Threads.setBlockThreadStop(thread2, thread2);
        Object object3 = objectMonitor.waitQueue;
        if (object3 == thread) {
            objectMonitor.waitQueue = Threads.getWaitNext(thread);
            if (objectMonitor.waitQueue == null) {
                objectMonitor.waitLast = null;
            }
        } else {
            while (object3 != null) {
                object2 = Threads.getWaitNext((Thread)object3);
                if (object2 == thread) {
                    Thread thread3 = Threads.getWaitNext(thread);
                    Threads.setWaitNext((Thread)object3, thread3);
                    if (thread3 == null) {
                        objectMonitor.waitLast = object3;
                    }
                    object3 = thread;
                    break;
                }
                object3 = object2;
            }
        }
        if (object3 == thread && Threads.changeLockState(n = Threads.getVMThread(thread), 1, 2)) {
            objectMonitor = Locks.getMonitorAndReserve(object);
            if (objectMonitor.lockLast != null) {
                Threads.setLockNext(objectMonitor.lockLast, thread);
            } else {
                objectMonitor.lockQueue = thread;
            }
            objectMonitor.lockLast = thread;
            Locks.releaseMonitorReservation(object);
        }
        object2 = Threads.getBlockThreadStop(thread2);
        Threads.setBlockThreadStop(thread2, null);
        if (object2 != thread2) {
            throw (Throwable)object2;
        }
    }

    private static void notifyAll(Object object) throws Throwable {
        Object object2;
        Thread thread = Thread.currentThread();
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, thread, false);
        if (objectMonitor == null) {
            return;
        }
        Threads.setBlockThreadStop(thread, thread);
        Object object3 = objectMonitor.waitQueue;
        while (object3 != null) {
            object2 = Threads.getWaitNext((Thread)object3);
            int n = Threads.getVMThread((Thread)object3);
            if (Threads.changeLockState(n, 1, 2)) {
                objectMonitor = Locks.getMonitorAndReserve(object);
                if (objectMonitor.lockLast != null) {
                    Threads.setLockNext(objectMonitor.lockLast, (Thread)object3);
                } else {
                    objectMonitor.lockQueue = object3;
                }
                objectMonitor.lockLast = object3;
                Locks.releaseMonitorReservation(object);
            }
            object3 = object2;
        }
        objectMonitor.waitQueue = null;
        objectMonitor.waitLast = null;
        object2 = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object2 != thread) {
            throw (Throwable)object2;
        }
    }

    private static void removeFromWaitQueue(ObjectMonitor objectMonitor, Thread thread) {
        if (objectMonitor == null) {
            return;
        }
        Thread thread2 = objectMonitor.waitQueue;
        if (thread2 == thread) {
            objectMonitor.waitQueue = Threads.getWaitNext(thread);
            if (objectMonitor.waitQueue == null) {
                objectMonitor.waitLast = null;
            }
            return;
        }
        while (thread2 != null) {
            Thread thread3 = Threads.getWaitNext(thread2);
            if (thread3 == thread) {
                Thread thread4 = Threads.getWaitNext(thread);
                Threads.setWaitNext(thread2, thread4);
                if (thread4 == null) {
                    objectMonitor.waitLast = thread2;
                }
                return;
            }
            thread2 = thread3;
        }
    }

    public static void wait(Object object, long l) throws Throwable {
        Object object2;
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l == 0L) {
            object.wait();
            return;
        }
        Thread thread = Thread.currentThread();
        boolean bl3 = bl2 = (Threads.getThreadStatus(thread) & 4) == 4;
        if (bl2) {
            Threads.setThreadStatus(thread, 417);
        }
        if (VM.profMonitors) {
            Locks.profMonitorWait(object, l);
        }
        Threads.setBlockThreadStop(thread, thread);
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, thread, true);
        int n = Threads.getVMThread(thread);
        if (objectMonitor == null) {
            objectMonitor = Locks.createMonitorAndConvert(object, true);
        }
        Threads.setCurrentWaitingObject(thread, object);
        if (Threads.isInterrupted(thread, true)) {
            Threads.setCurrentWaitingObject(thread, null);
            Locks.releaseMonitorReservation(object);
            Object object3 = Threads.getBlockThreadStop(thread);
            Threads.setBlockThreadStop(thread, null);
            Threads.setThreadStatus(thread, 5);
            if (VM.profMonitors) {
                Locks.profMonitorWaited(object, false);
            }
            if (object3 != thread) {
                throw (Throwable)object3;
            }
            throw new InterruptedException();
        }
        Threads.setLockState(n, 1);
        Threads.setWaitNext(thread, null);
        if (objectMonitor.waitLast != null) {
            Threads.setWaitNext(objectMonitor.waitLast, thread);
        } else {
            objectMonitor.waitQueue = thread;
        }
        objectMonitor.waitLast = thread;
        Locks.unlockFatInternal(object, n, objectMonitor, true);
        long l2 = 0L;
        if (bl2) {
            Threads.incrementMonitorWaitedCount(n);
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                l2 = System.currentTimeMillis();
            }
        }
        if (Threads.getBlockThreadStop(thread) == thread) {
            Threads.waitForSignalWithTimeout(l);
        } else {
            Threads.setLockState(n, 0);
        }
        Threads.setCurrentWaitingObject(thread, null);
        objectMonitor = Locks.fatLockReacquire(object, thread);
        if (objectMonitor != null) {
            Locks.releaseMonitorReservation(object);
        }
        if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l2 > 0L) {
            l2 = System.currentTimeMillis() - l2;
            Threads.incrementMonitorWaitedTime(n, l2);
        }
        if ((bl = Threads.isTimeoutExpired(n)) || Threads.getBlockThreadStop(thread) != thread) {
            Threads.clearTimeoutExpired(n);
            Locks.removeFromWaitQueue(objectMonitor, thread);
        }
        if (objectMonitor == null && (Memory.objectAsAddress(object2 = Locks.monitorEnterSecondStage(object, Memory.getInt(object, 4))) & 7) == 1) {
            Locks.convertFatLockedToThinLocked(object);
        }
        Threads.setThreadStatus(thread, 5);
        if (VM.profMonitors) {
            Locks.profMonitorWaited(object, bl);
        }
        object2 = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object2 != thread) {
            throw (Throwable)object2;
        }
        if (Threads.isInterrupted(thread, true)) {
            throw new InterruptedException();
        }
    }

    public static void wait(Object object) throws Throwable {
        Object object2;
        boolean bl;
        Thread thread = Thread.currentThread();
        boolean bl2 = bl = (Threads.getThreadStatus(thread) & 4) == 4;
        if (bl) {
            Threads.setThreadStatus(thread, 401);
        }
        if (VM.profMonitors) {
            Locks.profMonitorWait(object, 0L);
        }
        Threads.setBlockThreadStop(thread, thread);
        ObjectMonitor objectMonitor = Locks.getMonitorWithCheck(object, thread, true);
        int n = Threads.getVMThread(thread);
        if (objectMonitor == null) {
            objectMonitor = Locks.createMonitorAndConvert(object, true);
        }
        Threads.setCurrentWaitingObject(thread, object);
        if (Threads.isInterrupted(thread, true)) {
            Threads.setCurrentWaitingObject(thread, null);
            Locks.releaseMonitorReservation(object);
            Object object3 = Threads.getBlockThreadStop(thread);
            Threads.setBlockThreadStop(thread, null);
            Threads.setThreadStatus(thread, 5);
            if (VM.profMonitors) {
                Locks.profMonitorWaited(object, false);
            }
            if (object3 != thread) {
                throw (Throwable)object3;
            }
            throw new InterruptedException();
        }
        Threads.setLockState(n, 1);
        Threads.setWaitNext(thread, null);
        if (objectMonitor.waitLast != null) {
            Threads.setWaitNext(objectMonitor.waitLast, thread);
        } else {
            objectMonitor.waitQueue = thread;
        }
        objectMonitor.waitLast = thread;
        Locks.unlockFatInternal(object, n, objectMonitor, true);
        long l = 0L;
        if (bl) {
            Threads.incrementMonitorWaitedCount(n);
            if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled) {
                l = System.currentTimeMillis();
                Threads.incrementMonitorWaitedCount(n);
            }
        }
        if (Threads.getBlockThreadStop(thread) == thread) {
            Threads.waitForSignal();
        } else {
            Threads.setLockState(n, 0);
        }
        Threads.setCurrentWaitingObject(thread, null);
        objectMonitor = Locks.fatLockReacquire(object, thread);
        if (objectMonitor != null) {
            Locks.releaseMonitorReservation(object);
        }
        if (VM.threadContentionMonitoringIsSupported && threadContentionMonitoringIsEnabled && l > 0L) {
            l = System.currentTimeMillis() - l;
            Threads.incrementMonitorWaitedTime(n, l);
        }
        if (Threads.getBlockThreadStop(thread) != thread) {
            Locks.removeFromWaitQueue(objectMonitor, thread);
        }
        if (objectMonitor == null && (Memory.objectAsAddress(object2 = Locks.monitorEnterSecondStage(object, Memory.getInt(object, 4))) & 7) == 1) {
            Locks.convertFatLockedToThinLocked(object);
        }
        Threads.setThreadStatus(thread, 5);
        if (VM.profMonitors) {
            Locks.profMonitorWaited(object, false);
        }
        object2 = Threads.getBlockThreadStop(thread);
        Threads.setBlockThreadStop(thread, null);
        if (object2 != thread) {
            throw (Throwable)object2;
        }
        if (Threads.isInterrupted(thread, true)) {
            throw new InterruptedException();
        }
    }

    public static Object lockThin(Object object, boolean bl) {
        int n;
        int n2 = Threads.getCurrentVMThread();
        int n3 = Threads.getThreadIndex(n2) << 0;
        int n4 = Memory.getInt(object, 4) & 0xFF000000;
        int n5 = Memory.cas(object, 4, n4, n = n4 | n3);
        if (n5 == n4) {
            if (VM.lockProfilingEnabled) {
                int n6 = Reflect.IClassBlock.getCB(object);
                if (bl) {
                    Reflect.IClassBlock.incrThinLockAcquiredContended(n6);
                } else {
                    Reflect.IClassBlock.incrThinLockAcquired(n6);
                }
            }
            return Memory.getLockToken(object, 1);
        }
        if (n5 == n) {
            if (VM.lockProfilingEnabled) {
                int n7 = Reflect.IClassBlock.getCB(object);
                Reflect.IClassBlock.incrThinLockAcquiredRecursive(n7);
            }
            return Memory.getLockToken(object, 5);
        }
        return null;
    }

    @NoSafePoint
    public static int getPrimitiveHashCode(Object object) {
        int n = Memory.getInt(object, 4) & 0xC0000000;
        if (n == Integer.MIN_VALUE) {
            return Memory.getInt(object, -4);
        }
        if (n == 0x40000000) {
            return Memory.objectAsAddress(object) >>> 3;
        }
        return Locks.getPrimitiveHashCode0(object);
    }

    private static native int getPrimitiveHashCode0(Object var0);

    public static Object monitorEnter(Object object) {
        Object object2 = Locks.lockThin(object, false);
        if (object2 == null) {
            try {
                object2 = Locks.monitorEnterSecondStage(object, Memory.getInt(object, 4));
            }
            catch (Throwable throwable) {
                object2 = null;
            }
        }
        return object2;
    }

    @NoSafePoint
    public static void monitorExit(Object object) throws Throwable {
        int n = Memory.objectAsAddress(object) & 7;
        if (n == 1) {
            Intrinsics.membar(0);
            Memory.setShort(object, 3, (short)0);
        } else if (n != 5) {
            Locks.monitorExitSecondStage(object);
        }
    }

    public static void monitorExitPopFrame(Object object, Object object2, int n) {
        int n2 = Memory.objectAsAddress(object2) & 7;
        if (n2 == 1) {
            Intrinsics.membar(0);
            Memory.setShort(object, 4, (short)0);
        } else if (n2 != 5) {
            if (n2 == 6) {
                Locks.unlockFatInternal(object, n, Locks.getMonitorAndReserve(object), false);
            } else {
                Locks.monitorExitUnmatchedPopFrame(object, n);
            }
        }
    }
}

