/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.remote.JMXConnectorServer;
import sun.management.AgentConfigurationError;
import sun.management.ConnectorAddressLink;
import sun.management.jmxremote.ConnectorBootstrap;
import sun.management.snmp.AdaptorBootstrap;

public class Agent {
    private static Properties mgmtProps;
    private static ResourceBundle messageRB;
    private static JMXConnectorServer localServer;
    private static JMXConnectorServer remoteServer;
    private static final String DEFAULT_AGENT_CLASS = "sun.management.Agent";
    private static final String CONFIG_FILE = "com.sun.management.config.file";
    private static final String SNMP_PORT = "com.sun.management.snmp.port";
    private static final String JMXREMOTE = "com.sun.management.jmxremote";
    private static final String JMXREMOTE_PORT = "com.sun.management.jmxremote.port";
    private static final String ENABLE_THREAD_CONTENTION_MONITORING = "com.sun.management.enableThreadContentionMonitoring";

    public static void premain(String string) throws Exception {
        Properties properties = Agent.getManagementProperties();
        if (properties == null) {
            return;
        }
        String string2 = properties.getProperty(SNMP_PORT);
        String string3 = properties.getProperty(JMXREMOTE);
        String string4 = properties.getProperty(JMXREMOTE_PORT);
        System.out.println("[JRockit] Starting remote JMX connector on port " + string4 + ".");
        String string5 = properties.getProperty(ENABLE_THREAD_CONTENTION_MONITORING);
        if (string5 != null) {
            ManagementFactory.getThreadMXBean().setThreadContentionMonitoringEnabled(true);
        }
        try {
            if (string2 != null) {
                AdaptorBootstrap.initialize((String)string2, (Properties)properties);
            }
            if (remoteServer != null || localServer != null) {
                Agent.stopAgent();
            }
            if (string3 != null || string4 != null) {
                if (string4 != null) {
                    remoteServer = ConnectorBootstrap.initialize(string4, properties);
                }
                localServer = ConnectorBootstrap.startLocalConnectorServer();
                ConnectorAddressLink.export((String)localServer.getAddress().toString());
            }
        }
        catch (AgentConfigurationError agentConfigurationError) {
            Agent.error(agentConfigurationError.getError(), agentConfigurationError.getParams());
        }
        catch (Exception exception) {
            Agent.error(exception);
        }
        System.out.println("[JRockit] Remote JMX connector on port " + string4 + " ready.");
    }

    public static Properties loadManagementProperties() {
        Properties properties = new Properties();
        Agent.readConfiguration(properties);
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    public static synchronized Properties getManagementProperties() {
        if (mgmtProps == null) {
            String string = System.getProperty(CONFIG_FILE);
            String string2 = System.getProperty(SNMP_PORT);
            String string3 = System.getProperty(JMXREMOTE);
            String string4 = System.getProperty(JMXREMOTE_PORT);
            if (string == null && string2 == null && string3 == null && string4 == null) {
                return null;
            }
            mgmtProps = Agent.loadManagementProperties();
        }
        return mgmtProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readConfiguration(Properties properties) {
        Object object;
        Object object2;
        String string = System.getProperty(CONFIG_FILE);
        if (string == null) {
            object2 = System.getProperty("java.home");
            if (object2 == null) {
                throw new Error("Can't find java.home ??");
            }
            object = new StringBuffer((String)object2);
            ((StringBuffer)object).append(File.separator).append("lib");
            ((StringBuffer)object).append(File.separator).append("management");
            ((StringBuffer)object).append(File.separator).append("management.properties");
            string = ((StringBuffer)object).toString();
        }
        if (!((File)(object2 = new File(string))).exists()) {
            Agent.error("agent.err.configfile.notfound", string);
        }
        object = null;
        try {
            object = new FileInputStream((File)object2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            properties.load(bufferedInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Agent.error("agent.err.configfile.failed", fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            Agent.error("agent.err.configfile.failed", iOException.getMessage());
        }
        catch (SecurityException securityException) {
            Agent.error("agent.err.configfile.access.denied", string);
        }
        finally {
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    Agent.error("agent.err.configfile.closed.failed", string);
                }
            }
        }
    }

    public static synchronized void startAgent() throws Exception {
        String string;
        String string2 = System.getProperty("com.sun.management.agent.class", DEFAULT_AGENT_CLASS);
        String[] stringArray = string2.split(":");
        if (stringArray.length < 1 || stringArray.length > 2) {
            Agent.error("agent.err.invalid.agentclass", "\"" + string2 + "\"");
        }
        String string3 = stringArray[0];
        String string4 = string = stringArray.length == 2 ? stringArray[1] : null;
        if (string3 == null || string3.length() == 0) {
            Agent.error("agent.err.invalid.agentclass", "\"" + string2 + "\"");
        }
        if (string3 != null) {
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string3);
                Method method = clazz.getMethod("premain", String.class);
                method.invoke(null, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Agent.error("agent.err.agentclass.notfound", "\"" + string3 + "\"");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Agent.error("agent.err.premain.notfound", "\"" + string3 + "\"");
            }
            catch (SecurityException securityException) {
                Agent.error("agent.err.agentclass.access.denied");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string5 = exception.getCause() == null ? exception.getMessage() : exception.getCause().getMessage();
                Agent.error("agent.err.agentclass.failed", string5);
            }
        }
    }

    public static void error(String string) {
        System.err.print(Agent.getText("agent.err.error") + ": " + Agent.getText(string));
        System.exit(1);
    }

    public static void error(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            Agent.error(string);
        } else {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(" " + stringArray[i]);
            }
            Agent.error(string, stringBuffer.toString());
        }
    }

    public static void error(String string, String string2) {
        System.err.print(Agent.getText("agent.err.error") + ": " + Agent.getText(string));
        System.err.println(": " + string2);
        System.exit(1);
    }

    public static void error(Exception exception) {
        exception.printStackTrace();
        System.err.print(Agent.getText("agent.err.exception") + ": " + exception.toString());
        System.exit(1);
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle("sun.management.resources.agent");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for management agent is missing");
        }
    }

    public static String getText(String string) {
        if (messageRB == null) {
            Agent.initResource();
        }
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing management agent resource bundle: key = \"" + string + "\"";
        }
    }

    public static String getText(String string, String ... stringArray) {
        String string2;
        if (messageRB == null) {
            Agent.initResource();
        }
        if ((string2 = messageRB.getString(string)) == null) {
            string2 = "missing resource key: key = \"" + string + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        return MessageFormat.format(string2, stringArray);
    }

    public static synchronized void stopAgent() {
        System.out.println("[JRockit] Stopping remote JMX connector.");
        if (localServer != null) {
            try {
                localServer.stop();
            }
            catch (IOException iOException) {
                System.err.print("The following error was encountered while shutting down the management server:");
                iOException.printStackTrace();
            }
            localServer = null;
        }
        if (remoteServer != null) {
            try {
                remoteServer.stop();
            }
            catch (IOException iOException) {
                System.err.print("The following error was encountered while shutting down the management server:");
                iOException.printStackTrace();
            }
            remoteServer = null;
        }
        ConnectorBootstrap.clearRegistry();
        System.out.println("[JRockit] Remote JMX connector stopped.");
    }
}

