/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.jdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;

public class JDPPacket {
    private static final char DELIMITER = '!';
    private String m_address;
    private int m_port;
    public static final int DEFAULT_PORT = 7095;
    public static final String DEFAULT_ADDRESS = "232.192.1.212";

    public JDPPacket(byte[] bytes) {
        this.decode(bytes);
    }

    public JDPPacket(String address, int port) {
        this.m_address = address;
        this.m_port = port;
    }

    public void decode(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        String payload = null;
        try {
            payload = dis.readUTF();
        }
        catch (IOException e) {
            this.m_address = null;
            this.m_port = 0;
            return;
        }
        StringTokenizer strTok = new StringTokenizer(payload, String.valueOf('!'), false);
        while (strTok.hasMoreTokens()) {
            this.setAddress(strTok.nextToken());
            try {
                this.setPort(Integer.parseInt(strTok.nextToken()));
            }
            catch (NumberFormatException nfe) {
                this.setPort(0);
            }
        }
    }

    public byte[] encode() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        if (!this.isComplete()) {
            return null;
        }
        try {
            dos.writeUTF('!' + this.getAddress() + '!' + String.valueOf(this.getPort()));
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        return bos.toByteArray();
    }

    public String getAddress() {
        return this.m_address;
    }

    public int getPort() {
        return this.m_port;
    }

    private void setAddress(String address) {
        this.m_address = address;
    }

    private void setPort(int port) {
        this.m_port = port;
    }

    private boolean isComplete() {
        return this.m_address != null && this.m_port != 0;
    }

    public String toString() {
        return "JDPPacket - ManagementServer exist at " + this.getAddress() + ":" + this.getPort();
    }

    public String getCanonicalName() {
        return this.getAddress() + ":" + this.getPort();
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        try {
            return this.getCanonicalName().equals(((JDPPacket)arg).getCanonicalName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return this.getCanonicalName().hashCode();
    }
}

