/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.rmp.JRockitConnectionLostException;
import com.jrockit.common.util.NativeToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.NumberFormat;

public class RmpPacket {
    public static final int PACKET_LENGTH_POS = 0;
    public static final int PACKET_TYPE_POS = 4;
    public static final int PACKET_ID_POS = 6;
    public static final int PACKET_TIMESTAMP_POS = 14;
    public static final int PACKET_DATA_POS = 22;
    public static final int PACKET_LENGTH_SIZE = 4;
    public static final int PACKET_TYPE_SIZE = 2;
    public static final int COMMAND_LENGTH = 4;
    public static final int ASPECT_NAME_LENGTH = 4;
    public static final int UPDATE_INTERVAL_LENGTH = 10;
    public static final short RMP_ERROR = -1;
    public static final short RMP_ACK = 0;
    public static final short RMP_COMMAND = 1;
    public static final short RMP_QUERY = 2;
    public static final short RMP_RESULT = 3;
    public static final short RMP_SUBSCRIPTION = 4;
    public static final short RMP_PUSH = 5;
    public static final short RMP_SYSTEM = 6;
    public static final String ACK_OK = "OK";
    public static final String ACK_NOT_OK = "NAK";
    public static final String RMP_ARGUMENT_DELIMITER = "#";
    public static final int RMP_DEFAULT_PORT = 7090;
    public static final long PUSHED_PKG_ID = -1L;
    public static final int MAX_WAIT_TIME = 10000;
    public static final int MAX_PACKET_LENGTH = 0xA00000;
    private short m_type;
    private long m_messageId;
    private String m_data;
    private long m_timestamp;

    public RmpPacket(short type, long messageId, String data) {
        this(type, messageId, data, System.currentTimeMillis());
    }

    public RmpPacket(short type, long messageId, String data, long timestamp) {
        this.setType(type);
        this.setMessageId(messageId);
        this.setData(data);
        this.m_timestamp = System.currentTimeMillis();
    }

    public static RmpPacket createUnsubscribePacket(long messageId, String aspectName) {
        RmpPacket packet = new RmpPacket(4, messageId, "UNSU" + aspectName);
        return packet;
    }

    public static RmpPacket createSubscribePacket(long messageId, String aspectData, int updateInterval, boolean forceUpdate) {
        String data = "SUBS" + RmpPacket.getIntervalAndUpdateString(updateInterval, forceUpdate) + aspectData;
        RmpPacket packet = new RmpPacket(4, messageId, data);
        return packet;
    }

    public static String getIntervalAndUpdateString(int updateInterval, boolean forceUpdate) {
        NumberFormat intervalStringFormat = NumberFormat.getNumberInstance();
        intervalStringFormat.setGroupingUsed(false);
        intervalStringFormat.setMinimumIntegerDigits(10);
        return intervalStringFormat.format(updateInterval).substring(0, 9) + (forceUpdate ? "1" : "0");
    }

    public RmpPacket() {
    }

    protected RmpPacket(byte[] pkg) {
        this.setType(NativeToolkit.getShortFromByteArray(pkg, 4));
        this.setTimestamp(NativeToolkit.getLongFromByteArray(pkg, 14));
        this.setMessageId(NativeToolkit.getLongFromByteArray(pkg, 6));
        this.setData(new String(pkg, 22, pkg.length - 22));
    }

    public byte[] toBytes() {
        byte[] dataBytes = this.getData().getBytes();
        int packetLength = 22 + dataBytes.length;
        byte[] pkg = new byte[packetLength];
        NativeToolkit.writeIntToByteArray(packetLength, pkg, 0);
        NativeToolkit.writeShortToByteArray(this.getType(), pkg, 4);
        NativeToolkit.writeLongToByteArray(this.getMessageId(), pkg, 6);
        NativeToolkit.writeLongToByteArray(this.getTimestamp(), pkg, 14);
        System.arraycopy(dataBytes, 0, pkg, 22, dataBytes.length);
        return pkg;
    }

    public static RmpPacket parseBytes(byte[] pkg, boolean checkLength) throws JRockitConnectionException {
        int length = NativeToolkit.getIntFromByteArray(pkg, 0);
        if (checkLength && length != pkg.length) {
            throw new JRockitConnectionException("Received packet has incorrect length");
        }
        if (pkg.length < 22) {
            throw new JRockitConnectionException("Received packet has incorrect format");
        }
        return new RmpPacket(pkg);
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    private void setTimestamp(long timestamp) {
        this.m_timestamp = timestamp;
    }

    public static RmpPacket parseBytes(byte[] pkg) throws JRockitConnectionException {
        RmpPacket rmpPacket = null;
        rmpPacket = RmpPacket.parseBytes(pkg, true);
        return rmpPacket;
    }

    public short getType() {
        return this.m_type;
    }

    public void setType(short type) {
        this.m_type = type;
    }

    public long getMessageId() {
        return this.m_messageId;
    }

    public void setMessageId(long messageId) {
        this.m_messageId = messageId;
    }

    public String getData() {
        return this.m_data;
    }

    public String getCommand() {
        return this.getData().substring(0, 4);
    }

    public boolean hasArgument() {
        return this.getAspectData().length() > 4;
    }

    public String getParameters() {
        return this.getData().substring(4);
    }

    public String getAspectName() {
        int index = this.getCommand().equals("SUBS") ? 14 : 4;
        return this.getData().substring(index, index + 4);
    }

    public String getAspectData() {
        return this.getData().substring(this.getCommand().equals("SUBS") ? 14 : 4);
    }

    public String getArgument() {
        return this.getData().substring(18);
    }

    public int getUpdateInterval() {
        int updateInterval = Integer.parseInt(this.getData().substring(4, 14)) / 10;
        return updateInterval * 10;
    }

    public boolean getForceUpdate() {
        int dataLength = 13;
        String data = this.getData();
        if (data.length() <= dataLength) {
            return false;
        }
        String flag = this.getData().substring(dataLength, dataLength + 1);
        return "1".equals(flag);
    }

    public void setData(String data) {
        this.m_data = data;
    }

    private static int readBytesFromInputStream(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int startPos = offset;
        int leftToRead = length;
        long maxWaitTime = System.currentTimeMillis() + 10000L;
        while (leftToRead > 0 && System.currentTimeMillis() < maxWaitTime) {
            int readThisTime = in.read(buffer, startPos, leftToRead);
            if (readThisTime < 0) {
                return readThisTime;
            }
            leftToRead -= readThisTime;
            startPos += readThisTime;
        }
        return length - leftToRead;
    }

    public static RmpPacket readFromStream(InputStream in, int maxLength) throws JRockitConnectionException, JRockitConnectionLostException, InterruptedIOException {
        byte[] pkg;
        byte[] array = RmpPacket.readPacketLengthFromInputStream(in);
        int length = NativeToolkit.getIntFromByteArray(array, 0);
        if (length < 22) {
            throw new JRockitConnectionException("Malformed RMP Packet: packet length is stated to be only " + length + " bytes, but " + 22 + " bytes was expected");
        }
        if (length > maxLength) {
            throw new JRockitConnectionException("Received packet lager than max length. Incoming RmpPacket says it is " + length + ". Max length for this read is " + maxLength + "!");
        }
        if (length > 22) {
            int rest = length - 22;
            pkg = new byte[length];
            System.arraycopy(array, 0, pkg, 0, 22);
            int actualRead = 0;
            try {
                actualRead = RmpPacket.readBytesFromInputStream(in, pkg, 22, rest);
            }
            catch (IOException e) {
                throw new JRockitConnectionException("Unexpected connection error.", e);
            }
            if (actualRead == -1) {
                throw new JRockitConnectionLostException("Connection closed.");
            }
            if (actualRead != rest) {
                throw new JRockitConnectionLostException("Connection unexpectedly closed.");
            }
        } else {
            pkg = array;
        }
        RmpPacket packet = RmpPacket.parseBytes(pkg);
        return packet;
    }

    public static RmpPacket readFromStream(InputStream in) throws JRockitConnectionException, JRockitConnectionLostException, InterruptedIOException {
        return RmpPacket.readFromStream(in, 0xA00000);
    }

    private static byte[] readPacketLengthFromInputStream(InputStream in) throws InterruptedIOException, JRockitConnectionLostException {
        int actualRead;
        byte[] array = new byte[22];
        try {
            actualRead = RmpPacket.readBytesFromInputStream(in, array, 0, 22);
        }
        catch (InterruptedIOException timeoutException) {
            throw timeoutException;
        }
        catch (IOException e) {
            throw new JRockitConnectionLostException("Connection unexpectedly closed.", e);
        }
        if (actualRead == -1) {
            throw new JRockitConnectionLostException("Connection closed.");
        }
        if (actualRead == 0) {
            throw new InterruptedIOException("Timeout waiting for RMP Packet");
        }
        if (actualRead != 22) {
            throw new JRockitConnectionLostException("Connection unexpectedly closed.");
        }
        return array;
    }

    public void writeToStream(OutputStream out) throws JRockitConnectionException {
        try {
            byte[] pkg = this.toBytes();
            out.write(pkg);
            out.flush();
        }
        catch (IOException e) {
            throw new JRockitConnectionException("Error while sending RMP packet.", e);
        }
    }

    public String toString() {
        return "RmpPacket[Type: " + this.getType() + ", ID: " + this.getMessageId() + ", Data: " + this.getData() + "]";
    }
}

