/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class GarbageCollectorStrategyWrapper {
    private String m_description;
    private Properties m_properties;
    private static final String DELIMITER = "#";

    public GarbageCollectorStrategyWrapper(String data) {
        this.importFromString(data);
    }

    public GarbageCollectorStrategyWrapper(String description, Properties properties) {
        this.m_description = description;
        this.m_properties = properties;
    }

    public String exportToString() {
        StringBuffer buf = new StringBuffer(150);
        buf.append(this.getDescription());
        buf.append(DELIMITER);
        buf.append(this.encodeProperties(this.getProperties()));
        return buf.toString();
    }

    public void importFromString(String data) {
        StringTokenizer tok = new StringTokenizer(data, DELIMITER, false);
        this.m_description = tok.nextToken();
        this.m_properties = this.decodeProperties(tok);
    }

    private String encodeProperties(Properties properties) {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> enumer = properties.propertyNames();
        while (enumer.hasMoreElements()) {
            String nextProp = (String)enumer.nextElement();
            String value = properties.getProperty(nextProp);
            buf.append(nextProp);
            buf.append(DELIMITER);
            buf.append(value);
            buf.append(DELIMITER);
        }
        return buf.toString();
    }

    private Properties decodeProperties(StringTokenizer tokenizer) {
        Properties props = new Properties();
        while (tokenizer.hasMoreTokens()) {
            props.setProperty(tokenizer.nextToken(), tokenizer.nextToken());
        }
        return props;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public String toString() {
        return this.getDescription();
    }
}

