/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

import com.jrockit.common.util.Debug;
import com.jrockit.common.util.MalformedDescriptorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MethodDescriptor {
    private String m_formalDescriptor;
    private String m_parameters;
    private String m_returnType;
    private String m_nonQualifiedReturnType;
    private String m_nonQualifiedParameters;

    public MethodDescriptor(String descriptor) throws MalformedDescriptorException {
        this.initializeFromDescriptor(descriptor);
    }

    public MethodDescriptor(Method method) {
        try {
            this.initializeFromDescriptor(MethodDescriptor.createFormalDescriptor(method));
        }
        catch (MalformedDescriptorException ignored) {
            Debug.exception(ignored);
        }
    }

    public MethodDescriptor(String parameters, String returnType) throws MalformedDescriptorException {
        this.m_parameters = parameters;
        this.m_returnType = returnType;
        this.createFormalDescriptor();
    }

    public static String createFormalDescriptor(Method method) {
        StringBuffer s = new StringBuffer("(");
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            MethodDescriptor.appendDescriptorForClass(parameters[i], s);
        }
        s.append(")");
        MethodDescriptor.appendDescriptorForClass(method.getReturnType(), s);
        return s.toString();
    }

    private void initializeFromDescriptor(String descriptor) throws MalformedDescriptorException {
        this.m_formalDescriptor = descriptor;
        HumanReadableForm hr = this.createHumanReadable(this.m_formalDescriptor, true);
        this.m_parameters = hr.m_parameters;
        this.m_returnType = hr.m_returnType;
        hr = this.createHumanReadable(this.m_formalDescriptor, false);
        this.m_nonQualifiedParameters = hr.m_parameters;
        this.m_nonQualifiedReturnType = hr.m_returnType;
    }

    private static void appendDescriptorForClass(Class aClass, StringBuffer s) {
        if (!aClass.isPrimitive()) {
            String className = aClass.getName();
            if (className.charAt(0) == '[') {
                s.append(className);
            } else {
                s.append("L");
                s.append(className);
                s.append(";");
            }
        } else if (aClass == Byte.TYPE) {
            s.append("B");
        } else if (aClass == Short.TYPE) {
            s.append("S");
        } else if (aClass == Character.TYPE) {
            s.append("C");
        } else if (aClass == Integer.TYPE) {
            s.append("I");
        } else if (aClass == Long.TYPE) {
            s.append("J");
        } else if (aClass == Float.TYPE) {
            s.append("F");
        } else if (aClass == Double.TYPE) {
            s.append("D");
        } else if (aClass == Boolean.TYPE) {
            s.append("Z");
        } else if (aClass == Void.TYPE) {
            s.append("V");
        }
    }

    private int convertOneVariableToHumanReadable(int position, StringBuffer source, StringBuffer destination, boolean fullyQualified) throws MalformedDescriptorException {
        char ch = source.charAt(position++);
        switch (ch) {
            case 'Z': {
                destination.append("boolean");
                break;
            }
            case 'B': {
                destination.append("byte");
                break;
            }
            case 'S': {
                destination.append("short");
                break;
            }
            case 'I': {
                destination.append("int");
                break;
            }
            case 'C': {
                destination.append("char");
                break;
            }
            case 'J': {
                destination.append("long");
                break;
            }
            case 'F': {
                destination.append("float");
                break;
            }
            case 'D': {
                destination.append("double");
                break;
            }
            case 'V': {
                destination.append("void");
                break;
            }
            case '[': {
                position = this.convertOneVariableToHumanReadable(position, source, destination, fullyQualified);
                destination.append("[]");
                break;
            }
            case 'L': {
                int classNameLength = source.substring(position).indexOf(59);
                if (classNameLength == -1) {
                    throw new MalformedDescriptorException("Class name (L) not terminated by ; in descriptor: " + source);
                }
                String fullyQualifiedName = source.substring(position, position + classNameLength);
                position += classNameLength + 1;
                if (fullyQualified) {
                    destination.append(fullyQualifiedName);
                    break;
                }
                destination.append(fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1));
                break;
            }
            default: {
                throw new MalformedDescriptorException("Unknown type designator: " + ch);
            }
        }
        return position;
    }

    private HumanReadableForm createHumanReadable(String descriptor, boolean fullyQualified) throws MalformedDescriptorException {
        HumanReadableForm humanReadable = new HumanReadableForm();
        StringBuffer source = new StringBuffer(descriptor);
        if (source.charAt(0) != '(') {
            throw new MalformedDescriptorException("Descriptor does not begin with '(': " + this.m_formalDescriptor);
        }
        StringBuffer parameters = new StringBuffer();
        int position = 1;
        while (position < source.length() && source.charAt(position) != ')') {
            if (position > 1) {
                parameters.append(",");
            }
            position = this.convertOneVariableToHumanReadable(position, source, parameters, fullyQualified);
        }
        if (position >= source.length()) {
            throw new MalformedDescriptorException("No ')' found in descriptor: " + this.m_formalDescriptor);
        }
        humanReadable.m_parameters = parameters.toString();
        if (++position >= source.length()) {
            throw new MalformedDescriptorException("No return type found in descriptor: " + this.m_formalDescriptor);
        }
        StringBuffer returnType = new StringBuffer();
        if ((position = this.convertOneVariableToHumanReadable(position, source, returnType, fullyQualified)) != source.length()) {
            throw new MalformedDescriptorException("No more input expected after return type in descriptor: " + this.m_formalDescriptor);
        }
        humanReadable.m_returnType = returnType.toString();
        return humanReadable;
    }

    private void createFormalDescriptor() throws MalformedDescriptorException {
        throw new MalformedDescriptorException("Conversion not handled yet!");
    }

    public String getHumanReadable(String methodName) {
        return this.getReturnType() + " " + methodName + "(" + this.getParameters() + ")";
    }

    public String getNonQualifiedHumanReadable(String methodName) {
        return this.getNonQualifiedReturnType() + " " + methodName + "(" + this.getNonQualifiedParameters() + ")";
    }

    public String getFormalDescriptor() {
        return this.m_formalDescriptor;
    }

    public String getParameters() {
        return this.m_parameters;
    }

    public Class[] getParameterTypes(ClassLoader cl) throws ClassNotFoundException {
        ArrayList<Class> parameters = new ArrayList<Class>();
        StringTokenizer tokenizer = new StringTokenizer(this.getParameters(), ",");
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            try {
                Class<?> aClass = Class.forName(parameter, true, cl);
                parameters.add(aClass);
            }
            catch (ClassNotFoundException e) {
                Class primitiveType = this.getPrimitiveParameterType(parameter);
                if (primitiveType != null) {
                    parameters.add(primitiveType);
                    continue;
                }
                throw e;
            }
        }
        Class[] parameterArray = new Class[parameters.size()];
        return parameters.toArray(parameterArray);
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public String getNonQualifiedParameters() {
        return this.m_nonQualifiedParameters;
    }

    public String getNonQualifiedReturnType() {
        return this.m_nonQualifiedReturnType;
    }

    public String toString() {
        return this.getHumanReadable("<method>");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor other = (MethodDescriptor)obj;
        return other.getFormalDescriptor().equals(this.getFormalDescriptor());
    }

    public int hashCode() {
        return this.getFormalDescriptor().hashCode();
    }

    private Class getPrimitiveParameterType(String parameter) {
        if (parameter.equals("int")) {
            return Integer.TYPE;
        }
        if (parameter.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (parameter.equals("double")) {
            return Double.TYPE;
        }
        if (parameter.equals("long")) {
            return Long.TYPE;
        }
        if (parameter.equals("float")) {
            return Float.TYPE;
        }
        if (parameter.equals("char")) {
            return Character.TYPE;
        }
        if (parameter.equals("short")) {
            return Short.TYPE;
        }
        if (parameter.equals("byte")) {
            return Byte.TYPE;
        }
        return null;
    }

    class HumanReadableForm {
        private String m_returnType;
        private String m_parameters;

        HumanReadableForm() {
        }

        public String getParameters() {
            return this.m_parameters;
        }

        public String getReturnType() {
            return this.m_returnType;
        }

        public void setParameters(String parameters) {
            this.m_parameters = parameters;
        }

        public void setReturnType(String returnType) {
            this.m_returnType = returnType;
        }
    }
}

