/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.common.util;

public final class NativeToolkit {
    private static final String DELIMITER = "#";

    private NativeToolkit() {
    }

    public static void writeShortToByteArray(short aShort, byte[] array, int position) {
        for (int i = 0; i < 2; ++i) {
            byte b;
            array[position + 1 - i] = b = (byte)(aShort & 0xFF);
            aShort = (short)(aShort >> 8);
        }
    }

    public static void writeIntToByteArray(int anInt, byte[] array, int position) {
        for (int i = 0; i < 4; ++i) {
            byte b;
            array[position + 3 - i] = b = (byte)(anInt & 0xFF);
            anInt >>= 8;
        }
    }

    public static void writeLongToByteArray(long aLong, byte[] array, int position) {
        for (int i = 0; i < 8; ++i) {
            byte b;
            array[position + 7 - i] = b = (byte)(aLong & 0xFFL);
            aLong >>= 8;
        }
    }

    public static void writeDoubleToByteArray(double aDouble, byte[] array, int position) {
        NativeToolkit.writeLongToByteArray(Double.doubleToLongBits(aDouble), array, position);
    }

    public static double getDoubleFromByteArray(byte[] array, int position) {
        return Double.longBitsToDouble(NativeToolkit.getLongFromByteArray(array, position));
    }

    public static long getLongFromByteArray(byte[] array, int position) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            byte b = array[position + i];
            result |= (long)b & 0xFFL;
        }
        return result;
    }

    public static short getShortFromByteArray(byte[] array, int position) {
        short result = 0;
        for (int i = 0; i < 2; ++i) {
            result = (short)(result << 8);
            byte b = array[position + i];
            result = (short)(result | (short)b & 0xFF);
        }
        return result;
    }

    public static int getIntFromByteArray(byte[] array, int position) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result <<= 8;
            byte b = array[position + i];
            result |= b & 0xFF;
        }
        return result;
    }

    public static String encodeBitMaskToString(int[] bitMask) {
        String encodedString = new String();
        for (int i = 0; i < bitMask.length; ++i) {
            int bit = bitMask[i];
            if (bit != 0 && bit != 1 && bit != 2) {
                throw new RuntimeException("Not a bit mask! Value at position " + i + " is " + bitMask[i]);
            }
            encodedString = encodedString + bit;
        }
        return encodedString;
    }

    public static int[] decodeStringToBitMask(String bitMaskString) {
        int[] bitMask = new int[bitMaskString.length()];
        for (int i = 0; i < bitMaskString.length(); ++i) {
            char bit = bitMaskString.charAt(i);
            if (bit == '0') {
                bitMask[i] = 0;
                continue;
            }
            if (bit == '1') {
                bitMask[i] = 1;
                continue;
            }
            if (bit == '2') {
                bitMask[i] = 2;
                continue;
            }
            throw new RuntimeException("String does not represent bit mask. Character was " + bit);
        }
        return bitMask;
    }
}

