/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.jdp;

import com.jrockit.common.jdp.JDPPacket;
import com.jrockit.common.util.NativeToolkit;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class JDPServer
implements Runnable {
    private String m_address;
    private int m_port;
    private int m_targetPort = 0;
    private long m_period;
    private int m_ttl;
    private DatagramPacket m_datagram;
    private boolean m_shutDown = false;
    private int m_errorCount = 0;
    private static final int MAX_ERROR_COUNT = 3;
    private static final String JDP_PREFIX = "[JDP] ";
    public static final String PROPERTY_PERIOD = "jrockit.managementserver.discovery.period";
    public static final String PROPERTY_TTL = "jrockit.managementserver.discovery.ttl";
    public static final String PROPERTY_ADDRESS = "jrockit.managementserver.discovery.address";
    public static final String PROPERTY_PORT = "jrockit.managementserver.discovery.port";
    public static final String PROPERTY_TARGET_PORT = "jrockit.managementserver.discovery.targetport";
    public static final String DEFAULT_PORT = "7091";
    public static final long DEFAULT_PERIOD = 5000L;
    public static final int DEFAULT_TTL = 1;

    public JDPServer() {
        this.updateSettingsFromProperties();
    }

    public void run() {
        MulticastSocket socket;
        this.m_errorCount = 0;
        try {
            socket = new MulticastSocket(this.getPort());
            socket.setTimeToLive(this.getTTL());
            socket.joinGroup(InetAddress.getByName(this.getAddress()));
        }
        catch (IOException e) {
            this.m_shutDown = true;
            JDPServer.printError("Warning: Could not create multicast socket.");
            return;
        }
        try {
            System.out.println("[JRockit] JDP server up. Broadcasting target " + this.getHost() + ":" + this.getTargetPort() + " every " + this.getPeriod() + " ms.");
        }
        catch (IOException e) {
            JDPServer.printError("JDP Startup failed. Message was: " + e.getMessage());
            return;
        }
        while (!this.m_shutDown) {
            try {
                socket.send(this.getDatagram());
            }
            catch (IOException e) {
                JDPServer.printError("Warning: Could not multicast JDPPacket! Message: " + e.getMessage());
                if (this.m_errorCount < 3) {
                    JDPServer.printError(3 - this.m_errorCount - 1 + " tries left.");
                } else {
                    JDPServer.printError("Too many errors. Exiting JDP service.");
                    this.m_shutDown = true;
                }
                ++this.m_errorCount;
            }
            try {
                Thread.sleep(this.getPeriod());
                Thread.yield();
            }
            catch (InterruptedException e) {}
        }
        JDPServer.printError("Exiting JDP service. Automatic detection of this JVM won't be possible.");
        try {
            socket.leaveGroup(InetAddress.getByName(this.getAddress()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateSettingsFromProperties() {
        this.m_address = System.getProperty(PROPERTY_ADDRESS, "232.192.1.212");
        this.m_period = 5000L;
        this.m_port = 7095;
        this.m_ttl = 1;
        try {
            this.m_period = Long.parseLong(System.getProperty(PROPERTY_PERIOD, String.valueOf(5000L)));
        }
        catch (NumberFormatException nfe) {
            JDPServer.numberParseError(PROPERTY_PERIOD, this.m_period);
        }
        try {
            this.m_port = Integer.parseInt(System.getProperty(PROPERTY_PORT, String.valueOf(7095)));
        }
        catch (NumberFormatException nfe) {
            JDPServer.numberParseError(PROPERTY_PORT, this.m_period);
        }
        try {
            this.m_port = Integer.parseInt(System.getProperty(PROPERTY_TTL, String.valueOf(7095)));
        }
        catch (NumberFormatException nfe) {
            JDPServer.numberParseError(PROPERTY_TTL, this.m_period);
        }
    }

    private static void numberParseError(String property, long usingNo) {
        System.err.println("[JDP] Warning: Could not parse " + property + " It's not a valid number! Using " + usingNo + "!");
    }

    public String getAddress() {
        return this.m_address;
    }

    public long getPeriod() {
        return this.m_period;
    }

    public int getPort() {
        return this.m_port;
    }

    public int getTTL() {
        return this.m_ttl;
    }

    public DatagramPacket getDatagram() throws UnknownHostException {
        if (this.m_datagram == null) {
            JDPPacket packet = new JDPPacket(this.getHost(), this.getTargetPort());
            byte[] pbytes = packet.encode();
            byte[] resultingBytes = new byte[pbytes.length + 2];
            short length = (short)pbytes.length;
            NativeToolkit.writeShortToByteArray(length, resultingBytes, 0);
            System.arraycopy(pbytes, 0, resultingBytes, 2, pbytes.length);
            this.m_datagram = new DatagramPacket(resultingBytes, resultingBytes.length, InetAddress.getByName(this.getAddress()), this.getPort());
        }
        return this.m_datagram;
    }

    public void shutDown() {
        this.m_shutDown = true;
    }

    private String getHost() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private int getTargetPort() {
        try {
            if (this.m_targetPort <= 0) {
                this.m_targetPort = Integer.parseInt(System.getProperty(PROPERTY_TARGET_PORT, DEFAULT_PORT));
            }
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return this.m_targetPort;
    }

    private static void printError(String message) {
        System.err.println(JDP_PREFIX + message);
    }
}

