/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;

abstract class RmpAbstractSubscription
implements RmpSubscription {
    private final String m_aspect;
    private final String m_argument;
    private int m_updateInterval;
    private final long m_subscriptionID;
    private final RmpServer m_server;

    RmpAbstractSubscription(RmpServer server, long messageID, String aspect, String argument, int updateInterval) {
        this.m_server = server;
        this.m_subscriptionID = messageID;
        this.m_aspect = aspect;
        this.m_argument = argument;
        this.setUpdateInterval(updateInterval);
    }

    public String getArgument() {
        return this.m_argument;
    }

    public String getAspect() {
        return this.m_aspect;
    }

    public long getSubscriptionID() {
        return this.m_subscriptionID;
    }

    public void setUpdateInterval(int updateInterval) {
        if (updateInterval % 100 != 0) {
            updateInterval = Math.max(100, Math.round((float)updateInterval / 100.0f) * 100);
        } else {
            this.m_updateInterval = updateInterval;
        }
    }

    public int getUpdateInterval() {
        return this.m_updateInterval;
    }

    protected void sendValue(String value, long timestamp, boolean isForceUpdate) {
        this.getServer().pushSubscriptionValue(this.getSubscriptionID(), this.getAspect(), value, timestamp, isForceUpdate);
    }

    private RmpServer getServer() {
        return this.m_server;
    }
}

