/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.JVMFactory;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.Debug;
import com.jrockit.management.rmp.RmpAbstractPollingSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;
import java.util.Collection;
import java.util.StringTokenizer;

public final class RmpExceptionSubscription
extends RmpAbstractPollingSubscription {
    private Collection m_throwableClasses;
    private boolean m_shouldIncludeSubclasses;

    RmpExceptionSubscription(RmpServer server, long messageID, String aspect, String argument, int updateInterval) throws ClassNotFoundException, ClassCastException {
        super(server, messageID, aspect, argument, updateInterval);
        StringTokenizer tokenizer = new StringTokenizer(argument, "#");
        String exceptionClassName = tokenizer.nextToken();
        this.m_shouldIncludeSubclasses = Boolean.valueOf(tokenizer.nextToken());
        this.m_throwableClasses = JVMFactory.getJVM().getClassLibrary().getAllClasses(exceptionClassName);
        if (this.m_throwableClasses.isEmpty()) {
            throw new ClassNotFoundException(exceptionClassName);
        }
        this.setExceptionCountEnabled(true);
    }

    public static boolean canHandle(RmpPacket requestPacket) {
        String aspect = requestPacket.getAspectName();
        return "EXCO".equals(aspect) && requestPacket.hasArgument();
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        try {
            return new RmpExceptionSubscription(server, requestPacket.getMessageId(), requestPacket.getAspectName(), requestPacket.getArgument(), requestPacket.getUpdateInterval());
        }
        catch (ClassNotFoundException e) {
            Debug.exception(e);
            return null;
        }
    }

    public void close() {
        this.setExceptionCountEnabled(false);
    }

    public void pushValue() {
        this.sendValue(this.getExceptionCount() + "", System.currentTimeMillis(), false);
    }

    private long getDataFromJRockit() {
        int count = 0;
        for (Class throwableClass : this.m_throwableClasses) {
            count = (int)((long)count + JVMFactory.getJVM().getProfilingSystem().getExceptionCount(throwableClass));
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getExceptionCount() {
        RmpExceptionSubscription rmpExceptionSubscription = this;
        synchronized (rmpExceptionSubscription) {
            if (this.isExceptionCountEnabled()) {
                return this.getDataFromJRockit();
            }
            return 0L;
        }
    }

    private void setExceptionCountEnabled(boolean enable) {
        boolean count = false;
        for (Class throwableClass : this.m_throwableClasses) {
            JVMFactory.getJVM().getProfilingSystem().setExceptionCountEnabled(throwableClass, enable, this.m_shouldIncludeSubclasses);
        }
    }

    private boolean isExceptionCountEnabled() {
        boolean countEnabled = false;
        for (Class throwableClass : this.m_throwableClasses) {
            countEnabled = JVMFactory.getJVM().getProfilingSystem().isExceptionCountEnabled(throwableClass);
            if (!countEnabled) continue;
            return countEnabled;
        }
        return countEnabled;
    }
}

