/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.GarbageCollector;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.event.GarbageCollectionStrategyChangeEvent;
import com.bea.jvm.event.GarbageCollectionStrategyChangeListener;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.GarbageCollectorChangeEventWrapper;
import com.jrockit.management.rmp.RmpAbstractCallbackSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;

public final class RmpGarbageCollectionChangeSubscription
extends RmpAbstractCallbackSubscription
implements GarbageCollectionStrategyChangeListener {
    private static final int NO_UPDATE_INTERVAL = -1;

    RmpGarbageCollectionChangeSubscription(RmpServer server, long messageID, String aspect) {
        super(server, messageID, aspect, null, -1);
        JVMFactory.getJVM().getMemorySystem().getGarbageCollector().addGarbageCollectionStrategyChangeListener((GarbageCollectionStrategyChangeListener)this);
    }

    public static boolean canHandle(RmpPacket requestPacket) {
        String aspect = requestPacket.getAspectName();
        return "GCCH".equals(aspect);
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        return new RmpGarbageCollectionChangeSubscription(server, requestPacket.getMessageId(), requestPacket.getAspectName());
    }

    public void close() {
        JVMFactory.getJVM().getMemorySystem().getGarbageCollector().removeGarbageCollectionStrategyChangeListener((GarbageCollectionStrategyChangeListener)this);
    }

    public void onGarbageCollectionStrategyChange(GarbageCollectionStrategyChangeEvent event) {
        this.sendValue(new GarbageCollectorChangeEventWrapper(event.getPrevious().getDescription(), event.getNext().getDescription(), event.getPrevious().getStrategyProperties(), event.getNext().getStrategyProperties()).exportToString(), event.getTime(), true);
    }

    public void pushInitialValue() {
        GarbageCollector gc = JVMFactory.getJVM().getMemorySystem().getGarbageCollector();
        this.onGarbageCollectionStrategyChange(new GarbageCollectionStrategyChangeEvent((Object)gc, System.currentTimeMillis(), gc.getGarbageCollectionStrategy(), gc.getGarbageCollectionStrategy()));
    }
}

