/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.event.GarbageCollectionEvent;
import com.bea.jvm.event.GarbageCollectionListener;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.management.rmp.RmpAbstractCallbackSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;

public final class RmpGcSubscription
extends RmpAbstractCallbackSubscription
implements GarbageCollectionListener {
    RmpGcSubscription(RmpServer server, long messageID, String aspect, int updateInterval) {
        super(server, messageID, aspect, null, updateInterval);
        JVMFactory.getJVM().getMemorySystem().getGarbageCollector().addGarbageCollectionListener((GarbageCollectionListener)this);
    }

    public static boolean canHandle(RmpPacket requestPacket) {
        String aspect = requestPacket.getAspectName();
        return "GCCM".equals(aspect);
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        return new RmpGcSubscription(server, requestPacket.getMessageId(), requestPacket.getAspectName(), requestPacket.getUpdateInterval());
    }

    public void onGarbageCollection(GarbageCollectionEvent event) {
        String value = event.getStartTime() + " " + event.getEndTime();
        this.sendValue(value, event.getEndTime(), true);
    }

    public void close() {
        JVMFactory.getJVM().getMemorySystem().getGarbageCollector().removeGarbageCollectionListener((GarbageCollectionListener)this);
    }
}

