/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.OptimizationLevel;
import com.bea.jvm.event.CompilationEvent;
import com.bea.jvm.event.CompilationListener;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.common.util.ReflectionToolkit;
import com.jrockit.management.rmp.RmpAbstractCallbackSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;
import java.lang.reflect.Method;

public final class RmpMethodCompiledSubscription
extends RmpAbstractCallbackSubscription
implements CompilationListener {
    private static final int NO_UPDATE_INTERVAL = -1;

    RmpMethodCompiledSubscription(RmpServer server, long messageID, String aspect) {
        super(server, messageID, aspect, null, -1);
        JVMFactory.getJVM().getCompilationSystem().addCompilationListener((CompilationListener)this);
    }

    public static boolean canHandle(RmpPacket requestPacket) {
        String aspect = requestPacket.getAspectName();
        return "COMP".equals(aspect);
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        return new RmpMethodCompiledSubscription(server, requestPacket.getMessageId(), requestPacket.getAspectName());
    }

    public void onMethodCompilation(CompilationEvent event) {
        long timestamp = System.currentTimeMillis();
        Method method = event.getMethod();
        OptimizationLevel level = event.getOptimizationLevel();
        MethodIdentifier[] identifierArray = new MethodIdentifier[]{new MethodIdentifier(method)};
        String value = ReflectionToolkit.encodeArrayToString(identifierArray);
        this.sendValue(value, timestamp, true);
    }

    public void close() {
        JVMFactory.getJVM().getCompilationSystem().removeCompilationListener((CompilationListener)this);
    }
}

