/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.JVMFactory;
import com.bea.jvm.UnapplicableMethodException;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.Assertion;
import com.jrockit.common.util.AssertionFailedException;
import com.jrockit.common.util.Debug;
import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.management.rmp.RmpAbstractPollingSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;
import com.jrockit.management.rmp.RmpToolkit;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public final class RmpMethodSubscription
extends RmpAbstractPollingSubscription {
    private Collection m_methods = new ArrayList(0);
    private long m_timestamp = System.currentTimeMillis();

    RmpMethodSubscription(RmpServer server, long messageID, String aspect, String argument, int updateInterval) throws ClassNotFoundException, NoSuchMethodException, UnapplicableMethodException {
        super(server, messageID, aspect, argument, updateInterval);
        this.m_methods = RmpMethodSubscription.getMethods(argument);
        if (this.m_methods.size() > 0) {
            this.setDataCollectingEnabled(true);
        } else {
            this.close();
        }
    }

    public static boolean canHandle(RmpPacket requestPacket) {
        String aspect = requestPacket.getAspectName();
        return aspect.startsWith("MP") && requestPacket.hasArgument();
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        if (RmpMethodSubscription.canBeProfiled(requestPacket.getArgument())) {
            try {
                return new RmpMethodSubscription(server, requestPacket.getMessageId(), requestPacket.getAspectName(), requestPacket.getArgument(), requestPacket.getUpdateInterval());
            }
            catch (ClassNotFoundException e) {
                Debug.exception(e);
                return null;
            }
            catch (NoSuchMethodException e) {
                Debug.exception(e);
                return null;
            }
            catch (UnapplicableMethodException e) {
                Debug.exception(e);
                return null;
            }
        }
        return null;
    }

    public void close() {
        try {
            this.setDataCollectingEnabled(false);
        }
        catch (UnapplicableMethodException e) {
            Assertion.assertTrue(false, "This should never happen!");
        }
    }

    public void pushValue() {
        this.sendValue(this.getValue() + "", System.currentTimeMillis(), false);
    }

    private static Collection getMethods(String argument) throws ClassNotFoundException, NoSuchMethodException {
        LinkedList<Method> methods = new LinkedList<Method>();
        StringTokenizer tokenizer = new StringTokenizer(argument, "#");
        String className = tokenizer.nextToken();
        String methodName = tokenizer.nextToken();
        String descriptor = tokenizer.nextToken();
        try {
            MethodIdentifier identifier = new MethodIdentifier(className, methodName, descriptor);
            Collection classes = JVMFactory.getJVM().getClassLibrary().getAllClasses(className);
            if (classes.isEmpty()) {
                throw new ClassNotFoundException(className);
            }
            for (Class aClass : classes) {
                methods.add(RmpToolkit.getMethod(aClass, identifier));
            }
        }
        catch (MalformedDescriptorException e) {
            Debug.exception(e);
        }
        return methods;
    }

    private static boolean canBeProfiled(String methodDescription) {
        try {
            return RmpMethodSubscription.getMethods(methodDescription).size() > 0;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void setDataCollectingEnabled(boolean enabled) throws UnapplicableMethodException {
        for (Method method : this.m_methods) {
            if (this.getAspect().equals("MPIN")) {
                JVMFactory.getJVM().getProfilingSystem().setInvocationCountEnabled(method, enabled);
                continue;
            }
            if (!this.getAspect().equals("MPTI")) continue;
            JVMFactory.getJVM().getProfilingSystem().setTimingEnabled(method, enabled);
        }
    }

    private boolean isDataCollectingEnabled() throws UnapplicableMethodException {
        boolean isEnabled = false;
        Iterator iter = this.m_methods.iterator();
        if (this.getAspect().equals("MPIN")) {
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                isEnabled = JVMFactory.getJVM().getProfilingSystem().isInvocationCountEnabled(method);
                if (!isEnabled) continue;
                return isEnabled;
            }
        } else if (this.getAspect().equals("MPTI")) {
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                isEnabled = JVMFactory.getJVM().getProfilingSystem().isTimingEnabled(method);
                if (!isEnabled) continue;
                return isEnabled;
            }
        } else {
            throw new AssertionFailedException("Invalid aspect type");
        }
        return isEnabled;
    }

    private long getDataFromJRockit() throws UnapplicableMethodException {
        long count = 0L;
        Iterator iter = this.m_methods.iterator();
        if (this.getAspect().equals("MPIN")) {
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                count += JVMFactory.getJVM().getProfilingSystem().getInvocationCount(method);
            }
        } else if (this.getAspect().equals("MPTI")) {
            while (iter.hasNext()) {
                Method method = (Method)iter.next();
                count += JVMFactory.getJVM().getProfilingSystem().getTiming(method);
            }
        } else {
            throw new AssertionFailedException("Invalid aspect type");
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getValue() {
        this.m_timestamp = System.currentTimeMillis();
        RmpMethodSubscription rmpMethodSubscription = this;
        synchronized (rmpMethodSubscription) {
            try {
                if (this.isDataCollectingEnabled()) {
                    return this.getDataFromJRockit();
                }
                return 0L;
            }
            catch (UnapplicableMethodException e) {
                Debug.println("Method suddenly turned unapplicable. Strange.");
                Debug.exception(e);
                this.close();
                return 0L;
            }
        }
    }
}

