/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.CPU;
import com.bea.jvm.GarbageCollectionStrategy;
import com.bea.jvm.JVMFactory;
import com.bea.jvm.NotAvailableException;
import com.bea.jvm.OptimizationLevel;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.Assertion;
import com.jrockit.common.util.Debug;
import com.jrockit.common.util.GarbageCollectionStrategyToolkit;
import com.jrockit.common.util.GarbageCollectorStrategyWrapper;
import com.jrockit.common.util.MalformedDescriptorException;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.common.util.NativeToolkit;
import com.jrockit.common.util.Print;
import com.jrockit.common.util.ReflectionToolkit;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpToolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import jrockit.internal.CtrlBreakHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RmpQueries {
    private static Map<String, RmpQuery> m_queries = new HashMap<String, RmpQuery>();
    private static Map<String, RmpCommand> m_commands = new HashMap<String, RmpCommand>();
    private static List<String> m_subscriptionTypes = new LinkedList<String>();

    private static void initCommands1(Map<String, RmpCommand> commands) {
        commands.put("OPEN", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                MethodIdentifier[] identifiers;
                List levels = JVMFactory.getJVM().getCompilationSystem().getOptimizationLevels();
                Assertion.assertTrue(levels.size() > 0, "No optimization levels!");
                OptimizationLevel highestLevel = (OptimizationLevel)levels.get(levels.size() - 1);
                try {
                    identifiers = ReflectionToolkit.decodeArrayFromString(argument);
                }
                catch (MalformedDescriptorException e) {
                    Debug.exception(e);
                    return false;
                }
                return RmpQueries.setOptimizationLevelForMethods(identifiers, highestLevel);
            }
        });
        commands.put("OPDI", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                MethodIdentifier[] identifiers;
                List levels = JVMFactory.getJVM().getCompilationSystem().getOptimizationLevels();
                Assertion.assertTrue(levels.size() > 0, "No optimization levels!");
                OptimizationLevel lowestLevel = (OptimizationLevel)levels.get(0);
                try {
                    identifiers = ReflectionToolkit.decodeArrayFromString(argument);
                }
                catch (MalformedDescriptorException e) {
                    Debug.exception(e);
                    return false;
                }
                return RmpQueries.setOptimizationLevelForMethods(identifiers, lowestLevel);
            }
        });
        commands.put("SAFF", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                int[] bitMask = NativeToolkit.decodeStringToBitMask(argument);
                List allCpus = JVMFactory.getJVM().getMachine().getCPUs();
                LinkedList<CPU> activeCpus = new LinkedList<CPU>();
                for (int i = 0; i < bitMask.length; ++i) {
                    if (bitMask[i] != 1) continue;
                    activeCpus.add((CPU)allCpus.get(i));
                }
                try {
                    JVMFactory.getJVM().suggestProcessAffinity(activeCpus);
                }
                catch (NotAvailableException e) {
                    return false;
                }
                return true;
            }
        });
    }

    private static void initCommands2(Map<String, RmpCommand> commands) {
        commands.put("SJRA", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                String filename = null;
                boolean noNativeSamples = false;
                boolean noMethodSampling = false;
                boolean noGcSampling = false;
                StringTokenizer tokenizer = new StringTokenizer(argument, "#");
                Integer recordingTime = new Integer(tokenizer.nextToken());
                if (tokenizer.hasMoreTokens()) {
                    filename = tokenizer.nextToken();
                }
                if (tokenizer.hasMoreTokens()) {
                    noMethodSampling = tokenizer.nextToken().equalsIgnoreCase("true");
                }
                if (tokenizer.hasMoreTokens()) {
                    noGcSampling = tokenizer.nextToken().equalsIgnoreCase("true");
                }
                if (tokenizer.hasMoreTokens()) {
                    noNativeSamples = tokenizer.nextToken().equalsIgnoreCase("true");
                }
                try {
                    Class<?> aClass = Class.forName("jrockit.jra.JraSystem");
                    Method[] methods = aClass.getMethods();
                    int i = 0;
                    while (!methods[i].getName().equals("startRecording")) {
                        ++i;
                    }
                    Method method = methods[i];
                    Object[] arguments = new Object[]{recordingTime, filename, noNativeSamples, noMethodSampling, noGcSampling};
                    Object result = method.invoke(null, arguments);
                    return (Boolean)result;
                }
                catch (ClassNotFoundException e) {
                    Debug.println("JRA recording probably not supported in this JRockit version: " + e.toString());
                    return false;
                }
                catch (Exception e) {
                    Debug.println("JRA recording could not start: " + e.toString());
                    return false;
                }
            }
        });
        commands.put("SJAP", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                Object filename = null;
                boolean noMethodSampling = false;
                boolean noGcSampling = false;
                StringTokenizer tokenizer = new StringTokenizer(argument, "#");
                if (tokenizer.hasMoreTokens()) {
                    noMethodSampling = tokenizer.nextToken().equalsIgnoreCase("true");
                }
                if (tokenizer.hasMoreTokens()) {
                    noGcSampling = tokenizer.nextToken().equalsIgnoreCase("true");
                }
                try {
                    Class<?> aClass = Class.forName("jrockit.jra.JraSystem");
                    Method[] methods = aClass.getMethods();
                    int i = 0;
                    while (!methods[i].getName().equals("startApplicationProfileRecording")) {
                        ++i;
                    }
                    Method method = methods[i];
                    Object[] arguments = new Object[]{noMethodSampling, noGcSampling};
                    Object result = method.invoke(null, arguments);
                    return (Boolean)result;
                }
                catch (ClassNotFoundException e) {
                    Debug.println("JAP recording probably not supported in this JRockit version: " + e.toString());
                    return false;
                }
                catch (Exception e) {
                    Debug.println("JAP recording could not start: " + e.toString());
                    return false;
                }
            }
        });
        commands.put("EJRA", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                try {
                    return RmpQueries.stopJraRecording();
                }
                catch (ClassNotFoundException e) {
                    Debug.println("Recording probably not supported in this JRockit version: " + e.toString());
                    return false;
                }
                catch (Exception e) {
                    Debug.println("JRA recording could not be stopped: " + e.toString());
                    return false;
                }
            }
        });
        commands.put("CTRB", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                CtrlBreakHandler.execute((String)argument);
                return true;
            }
        });
        commands.put("SGCC", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                GarbageCollectionStrategy strategy2;
                if (argument == null || "".equals(argument)) {
                    return false;
                }
                HashMap<String, GarbageCollectionStrategy> hashMap = new HashMap<String, GarbageCollectionStrategy>();
                for (GarbageCollectionStrategy strategy2 : JVMFactory.getJVM().getMemorySystem().getGarbageCollector().getGarbageCollectionStrategies()) {
                    hashMap.put(strategy2.getDescription(), strategy2);
                }
                GarbageCollectorStrategyWrapper gccw = new GarbageCollectorStrategyWrapper(argument);
                strategy2 = (GarbageCollectionStrategy)hashMap.get(gccw.getDescription());
                if (strategy2 == null) {
                    return false;
                }
                JVMFactory.getJVM().getMemorySystem().getGarbageCollector().suggestGarbageCollectionStrategy(strategy2);
                return true;
            }
        });
        commands.put("MESH", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                long size = -1L;
                try {
                    size = Long.parseLong(argument);
                }
                catch (NumberFormatException e) {
                    Debug.print("Suggest heap size got non parsable argument! arg = " + argument);
                    return false;
                }
                if (size < 0L) {
                    Debug.print("Suggest heap size got negative argument! size = " + size);
                    return false;
                }
                Debug.print("Suggesting new heapsize = " + size);
                JVMFactory.getJVM().getMemorySystem().suggestHeapSize(size);
                return true;
            }
        });
        commands.put("MESN", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                long size = -1L;
                try {
                    size = Long.parseLong(argument);
                }
                catch (NumberFormatException e) {
                    Debug.print("Set nursery size got non parsable argument! arg = " + argument);
                    return false;
                }
                if (size < 0L) {
                    Debug.print("Set nursery size got negative argument! size = " + size);
                    return false;
                }
                try {
                    JVMFactory.getJVM().getMemorySystem().getGarbageCollector().setNurserySize(size);
                }
                catch (NotAvailableException e) {
                    Debug.print("Tried to set nursery size when no nursery exists!");
                    return false;
                }
                return true;
            }
        });
        commands.put("EXOO", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                boolean val = false;
                val = Boolean.valueOf(argument);
                JVMFactory.getJVM().getMemorySystem().setExitOnOutOfMemory(val);
                Debug.print("Setting exit on oom to " + val);
                return true;
            }
        });
        commands.put("MELH", new RmpCommand(){

            public boolean doCommand(RmpServer server, String argument) {
                boolean val = false;
                val = Boolean.valueOf(argument);
                JVMFactory.getJVM().getMemorySystem().setHeapSizeLocked(val);
                Debug.print("Setting exit on oom to " + val);
                return true;
            }
        });
    }

    private static void initQueries1(Map<String, RmpQuery> queries) {
        queries.put("OSYS", new RmpQuery(){

            public String getResult(String argument) {
                return System.getProperty("os.name") + " " + System.getProperty("os.version");
            }
        });
        queries.put("SYSP", new RmpQuery(){

            public String getResult(String argument) {
                final StringWriter writer = new StringWriter();
                OutputStream ostream = new OutputStream(){

                    public void write(int b) throws IOException {
                        writer.write(b);
                    }
                };
                Properties properties = RmpQueries.getSafeSystemProperties();
                try {
                    properties.store(ostream, "The system properties. (Generated by the JRockit Management Console)");
                }
                catch (IOException e) {
                    Debug.exception(e);
                    return "";
                }
                return writer.getBuffer().toString();
            }
        });
        queries.put("JVER", new RmpQuery(){

            public String getResult(String argument) {
                return System.getProperty("java.vm.version");
            }
        });
        queries.put("#CPU", new RmpQuery(){

            public String getResult(String argument) {
                return Integer.toString(JVMFactory.getJVM().getMachine().getCPUs().size());
            }
        });
        queries.put("CPLD", new RmpQuery(){

            public String getResult(String argument) {
                List cpus = JVMFactory.getJVM().getMachine().getCPUs();
                double averageCpuLoad = 0.0;
                Iterator iter = cpus.iterator();
                while (iter.hasNext()) {
                    averageCpuLoad += ((CPU)iter.next()).getLoad();
                }
                return Double.toString((int)(averageCpuLoad / (double)cpus.size() * 100.0));
            }
        });
        queries.put("VMCP", new RmpQuery(){

            public String getResult(String argument) {
                double jvmLoad = JVMFactory.getJVM().getJVMLoad();
                return Double.toString(jvmLoad * 100.0);
            }
        });
        queries.put("AFFI", new RmpQuery(){

            public String getResult(String argument) {
                int noOfProcessors = JVMFactory.getJVM().getMachine().getCPUs().size();
                int[] bitMask = new int[noOfProcessors];
                try {
                    Collection activeCpus = JVMFactory.getJVM().getProcessAffinity();
                    List allCpus = JVMFactory.getJVM().getMachine().getCPUs();
                    for (int i = 0; i < allCpus.size(); ++i) {
                        bitMask[i] = activeCpus.contains(allCpus.get(i)) ? 1 : 0;
                    }
                }
                catch (NotAvailableException e) {
                    for (int i = 0; i < noOfProcessors; ++i) {
                        bitMask[i] = 2;
                    }
                }
                return NativeToolkit.encodeBitMaskToString(bitMask);
            }
        });
        queries.put("STIM", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getStartTime());
            }
        });
        queries.put("GCSY", new RmpQuery(){

            public String getResult(String argument) {
                return JVMFactory.getJVM().getMemorySystem().getGarbageCollector().getGarbageCollectionStrategy().getDescription();
            }
        });
        queries.put("THSY", new RmpQuery(){

            public String getResult(String argument) {
                return System.getProperty("java.vm.info");
            }
        });
    }

    private static void initQueries2(Map<String, RmpQuery> queries) {
        queries.put("METP", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMachine().getPhysicalMemory().getTotalMemory());
            }
        });
        queries.put("CRTM", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(System.currentTimeMillis());
            }
        });
        queries.put("MEUP", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMachine().getPhysicalMemory().getUsedMemory());
            }
        });
        queries.put("MEFP", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMachine().getPhysicalMemory().getTotalMemory() - JVMFactory.getJVM().getMachine().getPhysicalMemory().getUsedMemory());
            }
        });
        queries.put("METH", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMemorySystem().getTotalHeapSize());
            }
        });
        queries.put("MEUH", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMemorySystem().getUsedHeapSize());
            }
        });
        queries.put("MEFH", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMemorySystem().getTotalHeapSize() - JVMFactory.getJVM().getMemorySystem().getUsedHeapSize());
            }
        });
        queries.put("METN", new RmpQuery(){

            public String getResult(String argument) {
                try {
                    return Long.toString(JVMFactory.getJVM().getMemorySystem().getGarbageCollector().getNurserySize());
                }
                catch (NotAvailableException e) {
                    return "0";
                }
            }
        });
        queries.put("#GCS", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(JVMFactory.getJVM().getMemorySystem().getGarbageCollector().getTotalGarbageCollectionCount());
            }
        });
        queries.put("TH#N", new RmpQuery(){

            public String getResult(String argument) {
                return Integer.toString(JVMFactory.getJVM().getThreadSystem().getTotalThreadCount() - JVMFactory.getJVM().getThreadSystem().getDaemonThreadCount());
            }
        });
        queries.put("TH#T", new RmpQuery(){

            public String getResult(String argument) {
                return Integer.toString(JVMFactory.getJVM().getThreadSystem().getTotalThreadCount());
            }
        });
        queries.put("CRTM", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(System.currentTimeMillis());
            }
        });
        queries.put("EXCO", new RmpQuery(){

            public String getResult(String argument) {
                return Long.toString(System.currentTimeMillis());
            }
        });
    }

    private static void initQueries3(Map<String, RmpQuery> queries) {
        queries.put("VMSD", new RmpQuery(){

            public String getResult(String argument) {
                return JVMFactory.getJVM().getThreadSystem().getThreadStackDump();
            }
        });
        queries.put("RRCL", new RmpQuery(){

            public String getResult(String className) {
                Debug.println("Remote Reflection: " + className);
                return RmpToolkit.getEncodedClassAsString(className);
            }
        });
        queries.put("EXTH", new RmpQuery(){

            public String getResult(String className) {
                try {
                    Collection classes = JVMFactory.getJVM().getClassLibrary().getAllClasses(className);
                    if (classes.isEmpty()) {
                        return "";
                    }
                    Class testClass = (Class)classes.iterator().next();
                    return "" + Throwable.class.isAssignableFrom(testClass);
                }
                catch (ClassNotFoundException e) {
                    return "";
                }
            }
        });
        queries.put("IEOO", new RmpQuery(){

            public String getResult(String className) {
                return String.valueOf(JVMFactory.getJVM().getMemorySystem().isExitOnOutOfMemory());
            }
        });
        queries.put("MILH", new RmpQuery(){

            public String getResult(String className) {
                return String.valueOf(JVMFactory.getJVM().getMemorySystem().isHeapSizeLocked());
            }
        });
        queries.put("RUCL", new RmpQuery(){

            public String getResult(String argument) {
                return "BADM";
            }
        });
        queries.put("GGCS", new RmpQuery(){

            public String getResult(String argument) {
                Collection c = JVMFactory.getJVM().getMemorySystem().getGarbageCollector().getGarbageCollectionStrategies();
                ArrayList<GarbageCollectorStrategyWrapper> l = new ArrayList<GarbageCollectorStrategyWrapper>(5);
                if (c == null) {
                    return "BADM";
                }
                for (GarbageCollectionStrategy strategy : c) {
                    l.add(new GarbageCollectorStrategyWrapper(strategy.getDescription(), strategy.getStrategyProperties()));
                }
                return GarbageCollectionStrategyToolkit.exportToString(l);
            }
        });
        queries.put("EJRA", new RmpQuery(){

            public String getResult(String argument) {
                try {
                    int ch;
                    String fileName = RmpQueries.stopApplicationProfileRecording();
                    if ("".equals(fileName)) {
                        throw new RuntimeException("Recording filename is empty.");
                    }
                    File recordingFile = new File(fileName);
                    FileReader fileReader = new FileReader(recordingFile);
                    BufferedReader reader = new BufferedReader(fileReader);
                    StringWriter writer = new StringWriter();
                    while ((ch = reader.read()) != -1) {
                        writer.write(ch);
                    }
                    fileReader.close();
                    reader.close();
                    if (recordingFile.delete()) {
                        System.out.println("[JRockit] Deleted temporary recording file " + fileName);
                    } else {
                        System.out.println("[JRockit] Could not delete temporary recording file " + fileName);
                    }
                    return writer.toString();
                }
                catch (ClassNotFoundException e) {
                    Debug.println("Recording probably not supported in this JRockit version: " + e.toString());
                }
                catch (IOException e) {
                    Debug.println("Error reading recording file.");
                }
                catch (Exception e) {
                    Debug.println("JRA recording could not be stopped: " + e.toString());
                }
                return "";
            }
        });
    }

    private static void initSubscriptionTypes(List<String> subscriptionTypes) {
        subscriptionTypes.add("MPIN");
        subscriptionTypes.add("MPTI");
        subscriptionTypes.add("COMP");
        subscriptionTypes.add("GCCH");
        subscriptionTypes.add("GCCM");
        subscriptionTypes.add("EXCO");
    }

    private RmpQueries() {
    }

    public static Map getQueries() {
        return m_queries;
    }

    private static boolean setOptimizationLevelForMethods(MethodIdentifier[] identifiers, OptimizationLevel level) {
        try {
            for (int i = 0; i < identifiers.length; ++i) {
                MethodIdentifier identifier = identifiers[i];
                Method method = identifier.getClass().getDeclaredMethod(identifier.getMethodName(), identifier.getDescriptor().getParameterTypes(identifier.getClass().getClassLoader()));
                JVMFactory.getJVM().getCompilationSystem().forceCompilation(method, level);
            }
        }
        catch (Exception e) {
            Debug.exception(e);
            return false;
        }
        return true;
    }

    public static String getQueryResult(String aspectName, String argument) {
        RmpQuery query = (RmpQuery)RmpQueries.getQueries().get(aspectName);
        Assertion.assertNotNull(query, "Unknown aspect name: " + aspectName);
        try {
            String queryResult = query.getResult(argument);
            return queryResult;
        }
        catch (NotAvailableException e) {
            Print.error("Program error: Unimplemented functionality in the Management API: " + e.toString());
            Debug.exception(e);
            return "";
        }
    }

    public static List getSubscriptionTypes() {
        return m_subscriptionTypes;
    }

    public static Boolean executeRmpCommand(RmpPacket inPacket, RmpServer rmpServer) {
        RmpCommand command = m_commands.get(inPacket.getCommand());
        if (command == null) {
            return null;
        }
        boolean actionOk = command.doCommand(rmpServer, inPacket.getParameters());
        return new Boolean(actionOk);
    }

    public static String executeQuery(RmpPacket inPacket) {
        RmpQuery query = (RmpQuery)RmpQueries.getQueries().get(inPacket.getCommand());
        if (query != null) {
            try {
                String responseString = query.getResult(inPacket.getParameters());
                return responseString;
            }
            catch (NotAvailableException e) {
                Debug.println("*** RmpServer.handleQuery: Something in the Management API was not available ***");
                Debug.exception(e);
            }
        }
        return null;
    }

    public static boolean subscribedAspectExists(String aspectName) {
        return RmpQueries.getQueries().containsKey(aspectName) || RmpQueries.getSubscriptionTypes().contains(aspectName);
    }

    static Properties getSafeSystemProperties() {
        Properties props = (Properties)System.getProperties().clone();
        Object[] keys = props.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String val = props.get(keys[i]).toString();
            if (!(keys[i] instanceof String)) {
                props.remove(keys[i]);
                keys[i] = keys[i].toString();
            }
            props.put(keys[i], val);
        }
        return props;
    }

    private static boolean stopJraRecording() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = Class.forName("jrockit.jra.JraSystem");
        Method[] methods = aClass.getMethods();
        int i = 0;
        while (!methods[i].getName().equals("stopRecording")) {
            ++i;
        }
        Method method = methods[i];
        Object[] arguments = new Object[]{};
        Object result = method.invoke(null, arguments);
        boolean isStopped = (Boolean)result;
        return isStopped;
    }

    private static String stopApplicationProfileRecording() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Class<?> aClass = Class.forName("jrockit.jra.JraSystem");
        Method[] methods = aClass.getMethods();
        int i = 0;
        while (!methods[i].getName().equals("stopApplicationProfileRecording")) {
            ++i;
        }
        Method method = methods[i];
        Object[] arguments = new Object[]{};
        Object result = method.invoke(null, arguments);
        String filename = (String)result;
        return filename;
    }

    static {
        RmpQueries.initQueries1(m_queries);
        RmpQueries.initQueries2(m_queries);
        RmpQueries.initQueries3(m_queries);
        RmpQueries.initCommands1(m_commands);
        RmpQueries.initCommands2(m_commands);
        RmpQueries.initSubscriptionTypes(m_subscriptionTypes);
    }

    private static abstract class RmpQuery {
        private RmpQuery() {
        }

        public abstract String getResult(String var1);
    }

    public static abstract class RmpCommand {
        public abstract boolean doCommand(RmpServer var1, String var2);
    }
}

