/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.Debug;
import com.jrockit.common.util.Print;
import com.jrockit.management.rmp.RmpGarbageCollectionChangeSubscription;
import com.jrockit.management.rmp.RmpQueries;
import com.jrockit.management.rmp.RmpSocketListener;
import com.jrockit.management.rmp.RmpSubscription;
import com.jrockit.management.rmp.RmpSubscriptionFactory;
import com.jrockit.management.rmp.RmpSubscriptionThread;
import com.jrockit.management.rmp.RmpWriterThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmpServer
implements Runnable {
    private final Socket m_socket;
    private boolean m_alive = true;
    private boolean m_hasExceededMaxConnections = false;
    private InputStream m_in;
    private final int m_maxNumberOfConnections;
    private final RmpSocketListener m_socketListener;
    private final Map<Long, String> m_lastSubscriptionValueMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, RmpSubscription> m_subscriptionMap = new HashMap<String, RmpSubscription>();
    private RmpSubscriptionThread m_subscriptionThread;
    private RmpWriterThread m_writerThread;
    private final ShutdownHook m_shutdownHook = new ShutdownHook();

    RmpServer(Socket incoming, RmpSocketListener socketListener) {
        this(incoming, socketListener, -1);
    }

    RmpServer(Socket incoming, RmpSocketListener socketListener, int maxNoOfConnections) {
        this.m_socket = incoming;
        if (maxNoOfConnections > 0) {
            this.m_hasExceededMaxConnections = true;
        }
        this.m_maxNumberOfConnections = maxNoOfConnections;
        this.m_socketListener = socketListener;
        try {
            int timeout = Integer.parseInt(System.getProperty("jrockit.managementserver.timeout", "4000"));
            Debug.println("[JRockit] Using timeout: " + timeout);
            this.m_socket.setSoTimeout(timeout);
            this.m_socket.setTcpNoDelay(true);
            this.m_socket.setSoLinger(true, 10000);
            this.m_in = this.m_socket.getInputStream();
            this.m_writerThread = new RmpWriterThread(this, this.m_socket.getOutputStream());
        }
        catch (Exception e) {
            Print.error("Can't open streams on socket. Abnormal quit. " + e);
            this.closeDownStreams();
            return;
        }
        Runtime.getRuntime().addShutdownHook(this.m_shutdownHook);
        Thread serverThread = new Thread(this.getSocketListener().getManagementServerThreadGroup(), this, "[JRockit] Management Server");
        serverThread.setDaemon(true);
        serverThread.start();
    }

    public boolean isConnected() {
        return this.m_alive;
    }

    public void close() {
        this.closeDownStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initiateConnection();
        if (this.isConnected()) {
            if (this.hasExceededMaxConnections()) {
                this.handleRefusedConnection();
            } else {
                this.runConnectionLoop();
            }
        }
        this.closeSocket();
        RmpSocketListener rmpSocketListener = this.m_socketListener;
        synchronized (rmpSocketListener) {
            this.m_socketListener.notify();
        }
        Print.info("Management Server connection closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushSubscriptionValue(long subscriptionID, String aspectName, String aspectValue, long timestamp, boolean forceUpdate) {
        String lastValue = this.m_lastSubscriptionValueMap.get(new Long(subscriptionID));
        if (forceUpdate || !aspectValue.equals(lastValue)) {
            this.m_lastSubscriptionValueMap.put(new Long(subscriptionID), aspectValue);
            RmpPacket aPacket = new RmpPacket(5, subscriptionID, aspectName + aspectValue, timestamp);
            Socket socket = this.m_socket;
            synchronized (socket) {
                if (this.isConnected()) {
                    this.queuePacket(aPacket);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.isConnected()) {
            this.closeDownStreams();
            this.closeSocket();
        }
    }

    private RmpPacket createHandshakeReply(RmpPacket inPacket) {
        RmpPacket replyPacket = this.hasExceededMaxConnections() ? new RmpPacket(0, inPacket.getMessageId(), "MAXE" + this.m_maxNumberOfConnections) : this.createAckPacket(inPacket, true);
        return replyPacket;
    }

    private Map<String, RmpSubscription> getSubscriptionMap() {
        return this.m_subscriptionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDownStreams() {
        this.m_alive = false;
        Socket socket = this.m_socket;
        synchronized (socket) {
            try {
                if (this.m_in != null) {
                    this.m_in.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.m_writerThread.close();
            try {
                this.m_socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Socket socket = this.m_socket;
        synchronized (socket) {
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleCommand(RmpPacket inPacket) {
        if ("EXIT".equals(inPacket.getCommand())) {
            this.handleExit(inPacket);
            return;
        }
        Boolean commandOK = RmpQueries.executeRmpCommand(inPacket, this);
        RmpPacket replyPacket = commandOK == null ? new RmpPacket(-1, inPacket.getMessageId(), "BADM") : this.createAckPacket(inPacket, commandOK);
        this.queuePacket(replyPacket);
    }

    private void runConnectionLoop() {
        this.m_subscriptionThread = new RmpSubscriptionThread(this);
        while (this.isConnected()) {
            try {
                RmpPacket inPacket = RmpPacket.readFromStream(this.m_in);
                if (inPacket.getType() == 2) {
                    this.handleQuery(inPacket);
                    continue;
                }
                if (inPacket.getType() == 1) {
                    this.handleCommand(inPacket);
                    continue;
                }
                if (inPacket.getType() == 4) {
                    this.handleSubscription(inPacket);
                    continue;
                }
                this.handleIllegalPacket(inPacket);
            }
            catch (InterruptedIOException timeoutException) {
            }
            catch (JRockitConnectionException e) {
                Print.warning("Management Server connection lost. Exception: " + e.getMessage());
                Debug.exception(e);
                this.closeDownStreams();
            }
        }
        this.shutDownSubscriptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExit(RmpPacket inPacket) {
        Socket socket = this.m_socket;
        synchronized (socket) {
            try {
                this.m_writerThread.sendNowAndCloseQueue(this.createAckPacket(inPacket, true));
            }
            catch (JRockitConnectionException ignored) {
                Debug.exception(ignored);
            }
            this.closeDownStreams();
        }
    }

    private void handleIllegalPacket(RmpPacket inPacket) {
        RmpPacket replyPacket = new RmpPacket(-1, inPacket.getMessageId(), "Illegal packet type");
        Debug.println("Illegal packet type received: " + inPacket);
        this.queuePacket(replyPacket);
    }

    private void handleQuery(RmpPacket inPacket) {
        String responseString = RmpQueries.executeQuery(inPacket);
        RmpPacket replyPacket = responseString == null ? new RmpPacket(-1, inPacket.getMessageId(), "BADM") : new RmpPacket(3, inPacket.getMessageId(), responseString);
        this.queuePacket(replyPacket);
    }

    private void handleRefusedConnection() {
        RmpPacket packet = new RmpPacket(6, -1L, "MAXE" + this.m_maxNumberOfConnections);
        try {
            this.queuePacket(packet);
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closeDownStreams();
    }

    private void handleSubscription(RmpPacket inPacket) {
        RmpPacket replyPacket = this.createAckPacket(inPacket, true);
        String command = inPacket.getCommand();
        String aspectName = inPacket.getAspectName();
        String aspectData = inPacket.getAspectData();
        if (!RmpQueries.subscribedAspectExists(aspectName)) {
            replyPacket = new RmpPacket(-1, inPacket.getMessageId(), "BADM");
        } else if ("SUBS".equals(command)) {
            int updateInterval = inPacket.getUpdateInterval();
            RmpSubscription subscription = this.getSubscriptionMap().get(aspectData);
            if (subscription == null) {
                subscription = RmpSubscriptionFactory.createSubscription(this, inPacket);
                if (subscription == null) {
                    replyPacket = this.createAckPacket(inPacket, false);
                } else {
                    this.m_subscriptionThread.registerSubscription(subscription);
                    this.getSubscriptionMap().put(aspectData, subscription);
                    if (!subscription.usesCallback()) {
                        subscription.pushValue();
                    } else if (subscription instanceof RmpGarbageCollectionChangeSubscription) {
                        ((RmpGarbageCollectionChangeSubscription)subscription).pushInitialValue();
                    }
                }
            } else {
                this.m_subscriptionThread.changeUpdateInterval(subscription, updateInterval);
            }
        } else if ("UNSU".equals(command)) {
            RmpSubscription subscription = this.getSubscriptionMap().get(aspectData);
            if (subscription != null) {
                this.m_subscriptionThread.unregisterSubscription(subscription);
                this.getSubscriptionMap().remove(aspectData);
                subscription.close();
                this.m_lastSubscriptionValueMap.remove(new Long(subscription.getSubscriptionID()));
            } else {
                Debug.println("NAK NAK");
                replyPacket = this.createAckPacket(inPacket, false);
            }
        } else {
            replyPacket = new RmpPacket(-1, inPacket.getMessageId(), "BADM");
        }
        this.queuePacket(replyPacket);
    }

    private RmpPacket createAckPacket(RmpPacket inPacket, boolean ackOk) {
        String response = ackOk ? "OK" : "NAK";
        return new RmpPacket(0, inPacket.getMessageId(), response);
    }

    private boolean handshake() {
        try {
            RmpPacket inPacket = RmpPacket.readFromStream(this.m_in, 22 + "HELO".length() + 6);
            if (inPacket.getType() == 1 && "HELO".equals(inPacket.getCommand())) {
                RmpPacket replyPacket = this.createHandshakeReply(inPacket);
                this.queuePacket(replyPacket);
                return true;
            }
        }
        catch (InterruptedIOException timeoutException) {
            Print.error("Timeout while handshaking with Management Client.");
            Debug.exception(timeoutException);
        }
        catch (JRockitConnectionException e) {
            Print.error("Error while handshaking with Management Client.");
            Debug.exception(e);
        }
        return false;
    }

    private boolean hasExceededMaxConnections() {
        return this.m_hasExceededMaxConnections;
    }

    private void initiateConnection() {
        if (!this.handshake()) {
            Print.warning("Management Server connection: Handshaking failed!");
            this.m_alive = false;
            return;
        }
    }

    private void queuePacket(RmpPacket rmpPacket) {
        this.m_writerThread.addForWriting(rmpPacket);
    }

    private void shutDownSubscriptions() {
        if (this.m_subscriptionThread != null) {
            this.m_subscriptionThread.stop();
        }
        Iterator<String> iterator = this.getSubscriptionMap().keySet().iterator();
        while (iterator.hasNext()) {
            String aspectName = iterator.next();
            RmpSubscription subscription = this.getSubscriptionMap().get(aspectName);
            subscription.close();
            iterator.remove();
        }
    }

    public RmpSocketListener getSocketListener() {
        return this.m_socketListener;
    }

    private class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("[JRockit] Management Server Shutdown Hook");
        }

        public void run() {
            RmpPacket packet = new RmpPacket(6, -1L, "JRockit has finished running the started Java program, and is therefore shutting down.");
            RmpServer.this.queuePacket(packet);
            RmpServer.this.close();
        }
    }
}

