/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.util.Assertion;
import com.jrockit.common.util.Debug;
import com.jrockit.common.util.NativeToolkit;
import com.jrockit.common.util.Print;
import com.jrockit.management.jdp.JDPServer;
import com.jrockit.management.rmp.RmpQueries;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpServerProperties;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmpSocketListener
implements Runnable {
    private static final int ACCEPTED_NO_OF_REFUSED = 3;
    private ServerSocket m_listenerSocket;
    private InetAddress m_listenerAddress;
    private int m_maxNumberOfConnections;
    private int m_port;
    private int m_backlog;
    private List<RmpServer> m_serverConnections = new ArrayList<RmpServer>();
    private List<RmpServer> m_refusedConnections = new ArrayList<RmpServer>();
    private static final long START_TIME = System.currentTimeMillis();
    private JDPServer m_jdpServer;
    private ThreadGroup m_managementServerThreadGroup = new ThreadGroup("[JRockit Management Server]");
    private static RmpSocketListener m_instance = null;

    public RmpSocketListener() {
        this.setupPort();
        this.setupMaxNumberOfConnections();
        this.setupAddress();
        this.setupBacklog();
        if (this.setupSocket(this.getAddress(), this.getPort(), this.getBackLog(), this.getMaxNumberOfConnections())) {
            Thread t = new Thread((Runnable)this, "[JRockit] Connection Listener");
            t.setDaemon(true);
            t.start();
        }
        m_instance = this;
    }

    private boolean setupSocket(InetAddress address, int serverPort, int backlog, int maxNoOfConnections) {
        this.m_maxNumberOfConnections = maxNoOfConnections;
        try {
            this.m_listenerSocket = new ServerSocket(serverPort, backlog, address);
            this.setupClasses();
            Print.info("Management Server started on " + this.getServerShortName(address, serverPort, backlog) + ".");
        }
        catch (BindException portNotAvailableException) {
            Print.error("Management Server could not be started on " + this.getServerShortName(address, serverPort, backlog) + ".");
            Print.error("This port is probably already in use on this system, or the address is not valid.");
            return false;
        }
        catch (IOException e) {
            Print.error("Management Server could not be started (on " + this.getServerShortName(address, serverPort, backlog) + ").");
            Print.exception(e);
            return false;
        }
        boolean useJDP = Boolean.valueOf(System.getProperty("jrockit.managementserver.autodiscovery", "false"));
        if (useJDP) {
            this.m_jdpServer = new JDPServer();
            Thread jdpThread = new Thread(this.getManagementServerThreadGroup(), this.m_jdpServer, "[JRockit] Management Server auto discovery beacon");
            jdpThread.setDaemon(true);
            jdpThread.start();
            Print.info("Started auto discovery beacon.");
        }
        return true;
    }

    private String getServerShortName(InetAddress address, int serverPort, int backlog) {
        return (address != null ? System.getProperty("jrockit.managementserver.address") + ":" + serverPort : "port " + serverPort) + (backlog == 0 ? "" : " using backlog size = " + String.valueOf(backlog));
    }

    public static long getStartTime() {
        return START_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Socket incoming;
                try {
                    incoming = this.m_listenerSocket.accept();
                }
                catch (AccessControlException e) {
                    Print.warning("Management Server connection refused. " + e.getMessage());
                    continue;
                }
                catch (SocketException se) {
                    Print.warning("Management Server shutting down.");
                    try {
                        this.m_listenerSocket.close();
                        if (this.m_jdpServer == null) return;
                        this.m_jdpServer.shutDown();
                        return;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    return;
                }
                if (this.okToAddConnection()) {
                    Print.info("New Management Server connection from " + incoming.getInetAddress().getHostName());
                    this.getServerConnections().add(new RmpServer(incoming, this));
                    continue;
                }
                if (this.okToAddRefused()) {
                    Print.warning("Management Server connection refused. Connection number limit is " + this.getMaxNumberOfConnections());
                    this.getRefusedConnections().add(new RmpServer(incoming, this, this.getMaxNumberOfConnections()));
                    continue;
                }
                Print.warning("Management Server connection ignored. Connection number limit is " + this.getMaxNumberOfConnections());
                incoming.close();
                RmpSocketListener rmpSocketListener = this;
                synchronized (rmpSocketListener) {
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.println("Incoming Management Server connection could not be handled");
            Debug.exception(e);
            return;
        }
        finally {
            try {
                this.m_listenerSocket.close();
                if (this.m_jdpServer != null) {
                    this.m_jdpServer.shutDown();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean okToAddConnection() {
        if (this.getServerConnections().size() < this.getMaxNumberOfConnections()) {
            return true;
        }
        Iterator<RmpServer> iter = this.getServerConnections().iterator();
        while (iter.hasNext()) {
            RmpServer server = iter.next();
            if (server.isConnected()) continue;
            iter.remove();
        }
        return this.getServerConnections().size() < this.getMaxNumberOfConnections();
    }

    public boolean okToAddRefused() {
        if (this.getRefusedConnections().size() < 3) {
            return true;
        }
        Iterator<RmpServer> iter = this.getRefusedConnections().iterator();
        while (iter.hasNext()) {
            RmpServer server = iter.next();
            if (server.isConnected()) continue;
            iter.remove();
        }
        return this.getRefusedConnections().size() < 3;
    }

    private void setupMaxNumberOfConnections() {
        String maxConnectString = null;
        try {
            maxConnectString = System.getProperty("jrockit.managementserver.maxconnect");
            this.m_maxNumberOfConnections = maxConnectString == null ? 4 : Integer.parseInt(maxConnectString);
        }
        catch (NumberFormatException e) {
            Print.error("Invalid maximum number of connections for Management Server: " + maxConnectString);
            Print.error("Using default value 4 instead.");
            this.m_maxNumberOfConnections = 4;
        }
    }

    private void setupBacklog() {
        String backlogString = null;
        try {
            backlogString = System.getProperty("jrockit.managementserver.backlog");
            if (backlogString == null) {
                return;
            }
            this.m_backlog = Integer.parseInt(backlogString);
        }
        catch (NumberFormatException e) {
            Print.error("Invalid backlog buffer length: " + backlogString);
            Print.error("Using default value instead.");
            this.m_maxNumberOfConnections = 4;
        }
    }

    private void setupPort() {
        String portString = null;
        try {
            portString = System.getProperty("jrockit.managementserver.port", RmpServerProperties.DEFAULT_PORT);
            this.m_port = Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            Print.error("Invalid port number specified for Management Server: " + portString);
            Print.error("Using default port 7090 instead.");
            this.m_port = 7090;
        }
    }

    private void setupClasses() {
        if (!Boolean.valueOf(System.getProperty("jrockit.managementserver.preinit", "true")).booleanValue()) {
            return;
        }
        Debug.println("Preloading classes...");
        StringBuffer idiotBuffer = new StringBuffer();
        try {
            RmpQueries.getQueryResult("SYSP", "");
            RmpQueries.getQueryResult("CPLD", "");
            Assertion.assertNotNull(Class.forName("com.jrockit.common.rmp.RmpPacket"));
            Assertion.assertNotNull(Class.forName("com.jrockit.common.rmp.RmpCommands"));
            Assertion.assertNotNull(Class.forName("com.jrockit.management.rmp.RmpAbstractSubscription"));
            Assertion.assertNotNull(Class.forName("com.jrockit.management.rmp.RmpServerProperties"));
            Assertion.assertNotNull(Class.forName("com.jrockit.management.rmp.RmpServer"));
        }
        catch (ClassNotFoundException e) {
            Print.error("Failed to initialize one of the management server classes: " + e.getMessage());
        }
        try {
            byte[] localhost = new byte[]{127, 0, 0, 1};
            int[] bitmask = new int[]{1, 0, 1, 0, 1, 1, 0};
            idiotBuffer.append(InetAddress.getByAddress(localhost).getHostName());
            Socket s = new Socket();
            idiotBuffer.append(this.okToAddConnection());
            s.setSoLinger(true, 10);
            s.setKeepAlive(false);
            idiotBuffer.append(Double.toString(1.0000001));
            idiotBuffer.append(NativeToolkit.encodeBitMaskToString(bitmask));
            if (idiotBuffer.toString().getBytes().length == 0) {
                Debug.print("...and I'm donald duck!");
            }
        }
        catch (IOException e) {
            Debug.println("Failed to run dummy socket init methods. " + e.getMessage());
            e.printStackTrace();
        }
        Debug.println("Preloading complete.");
    }

    public ThreadGroup getManagementServerThreadGroup() {
        return this.m_managementServerThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Class<RmpSocketListener> clazz = RmpSocketListener.class;
        synchronized (RmpSocketListener.class) {
            if (this.m_jdpServer != null) {
                this.m_jdpServer.shutDown();
            }
            try {
                this.m_listenerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            m_instance = null;
            return;
        }
    }

    public static synchronized RmpSocketListener getInstance() {
        if (!RmpSocketListener.hasInstance()) {
            m_instance = new RmpSocketListener();
        }
        return m_instance;
    }

    public static synchronized boolean hasInstance() {
        return m_instance != null;
    }

    private void setupAddress() {
        String address = System.getProperty("jrockit.managementserver.address");
        if (address == null) {
            this.m_listenerAddress = null;
            return;
        }
        try {
            this.m_listenerAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            Print.error("Management server could not bind to IP " + address + ". Will default to accepting connection on all IP's.");
            this.m_listenerAddress = null;
        }
    }

    private List<RmpServer> getServerConnections() {
        return this.m_serverConnections;
    }

    private List<RmpServer> getRefusedConnections() {
        return this.m_refusedConnections;
    }

    private int getBackLog() {
        return this.m_backlog;
    }

    private int getMaxNumberOfConnections() {
        return this.m_maxNumberOfConnections;
    }

    private int getPort() {
        return this.m_port;
    }

    private InetAddress getAddress() {
        return this.m_listenerAddress;
    }
}

