/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.management.rmp.RmpExceptionSubscription;
import com.jrockit.management.rmp.RmpGarbageCollectionChangeSubscription;
import com.jrockit.management.rmp.RmpGcSubscription;
import com.jrockit.management.rmp.RmpGenericSubscription;
import com.jrockit.management.rmp.RmpMethodCompiledSubscription;
import com.jrockit.management.rmp.RmpMethodSubscription;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;

public final class RmpSubscriptionFactory {
    private RmpSubscriptionFactory() {
    }

    public static RmpSubscription createSubscription(RmpServer server, RmpPacket requestPacket) {
        if (RmpMethodSubscription.canHandle(requestPacket)) {
            return RmpMethodSubscription.createSubscription(server, requestPacket);
        }
        if (RmpGcSubscription.canHandle(requestPacket)) {
            return RmpGcSubscription.createSubscription(server, requestPacket);
        }
        if (RmpExceptionSubscription.canHandle(requestPacket)) {
            return RmpExceptionSubscription.createSubscription(server, requestPacket);
        }
        if (RmpMethodCompiledSubscription.canHandle(requestPacket)) {
            return RmpMethodCompiledSubscription.createSubscription(server, requestPacket);
        }
        if (RmpGarbageCollectionChangeSubscription.canHandle(requestPacket)) {
            return RmpGarbageCollectionChangeSubscription.createSubscription(server, requestPacket);
        }
        return RmpGenericSubscription.createSubscription(server, requestPacket);
    }
}

