/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.util.Assertion;
import com.jrockit.management.rmp.RmpServer;
import com.jrockit.management.rmp.RmpSubscription;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmpSubscriptionThread
implements Runnable {
    private boolean m_isAlive = true;
    private int m_highestUpdateInterval = 0;
    private Map<Integer, Vector<RmpSubscription>> m_subscriptionsMap = new HashMap<Integer, Vector<RmpSubscription>>();

    public RmpSubscriptionThread(RmpServer rmpServer) {
        Thread t = new Thread(rmpServer.getSocketListener().getManagementServerThreadGroup(), this, "[JRockit] Subscription Update");
        t.setDaemon(true);
        t.start();
    }

    public void changeUpdateInterval(RmpSubscription subscription, int newInterval) {
        this.unregisterSubscription(subscription);
        subscription.setUpdateInterval(newInterval);
        this.registerSubscription(subscription);
    }

    public void registerSubscription(RmpSubscription subscription) {
        if (subscription.usesCallback()) {
            return;
        }
        this.setHighestUpdateInterval(Math.max(this.getHighestUpdateInterval(), subscription.getUpdateInterval()));
        Integer key = new Integer(subscription.getUpdateInterval());
        Vector<RmpSubscription> subscriptions = this.getSubscriptionsMap().get(key);
        if (subscriptions == null) {
            subscriptions = new Vector();
            this.getSubscriptionsMap().put(key, subscriptions);
        }
        subscriptions.add(subscription);
    }

    @Override
    public void run() {
        int time = 0;
        long timeSpentHandlingLoop = 0L;
        long rest = 0L;
        while (this.isAlive()) {
            try {
                rest = Math.max(0L, rest);
                Thread.sleep(rest);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            long startTime = System.currentTimeMillis();
            time += 100;
            for (int i = 100; i <= time; i += 100) {
                if (time % i != 0) continue;
                Integer key = new Integer(i);
                Vector<RmpSubscription> subscriptions = this.getSubscriptionsMap().get(key);
                this.handleSubscriptions(subscriptions);
            }
            if (time >= this.getHighestUpdateInterval()) {
                time = 0;
            }
            timeSpentHandlingLoop = System.currentTimeMillis() - startTime;
            rest = 100L - timeSpentHandlingLoop;
        }
    }

    public void stop() {
        this.m_isAlive = false;
    }

    public void unregisterSubscription(RmpSubscription subscription) {
        if (subscription.usesCallback()) {
            return;
        }
        Integer key = new Integer(subscription.getUpdateInterval());
        Vector<RmpSubscription> subscriptions = this.getSubscriptionsMap().get(key);
        if (subscriptions != null) {
            subscriptions.remove(subscription);
        } else {
            Assertion.fail("Trying to unregister a subscription that hasn't been registered! " + subscription);
        }
    }

    private boolean isAlive() {
        return this.m_isAlive;
    }

    private void setHighestUpdateInterval(int newValue) {
        this.m_highestUpdateInterval = newValue;
    }

    private int getHighestUpdateInterval() {
        return this.m_highestUpdateInterval;
    }

    private Map<Integer, Vector<RmpSubscription>> getSubscriptionsMap() {
        return this.m_subscriptionsMap;
    }

    private void handleSubscriptions(Vector<RmpSubscription> subscriptions) {
        if (subscriptions == null) {
            return;
        }
        for (RmpSubscription subscription : subscriptions) {
            subscription.pushValue();
        }
    }
}

