/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.bea.jvm.JVMFactory;
import com.jrockit.common.util.MethodIdentifier;
import com.jrockit.common.util.Print;
import com.jrockit.common.util.ReflectionToolkit;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

public final class RmpToolkit {
    private static long m_diffTimeMajor;
    private static long m_diffTimeMinor;

    public static void resetTime() {
        m_diffTimeMinor = m_diffTimeMajor = System.currentTimeMillis();
    }

    public static void printDiff(int marker) {
        long newTime = System.currentTimeMillis();
        Print.info(marker + " Time: " + (newTime - m_diffTimeMajor) + " Since last: " + (newTime - m_diffTimeMinor));
        m_diffTimeMinor = newTime;
    }

    private RmpToolkit() {
    }

    public static String getEncodedClassAsString(String className) {
        String encodedArray;
        try {
            encodedArray = ReflectionToolkit.encodeArrayToString(RmpToolkit.getMethodsFromClass(className));
        }
        catch (ClassNotFoundException e) {
            return "";
        }
        return className + "!" + encodedArray;
    }

    private static MethodIdentifier[] getMethodsFromClass(String className) throws ClassNotFoundException {
        Collection classes = JVMFactory.getJVM().getClassLibrary().getAllClasses(className);
        if (classes.isEmpty()) {
            throw new ClassNotFoundException();
        }
        Class c = (Class)classes.iterator().next();
        Method[] declaredMethods = c.getDeclaredMethods();
        ArrayList<MethodIdentifier> methodIdentifiers = new ArrayList<MethodIdentifier>();
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = declaredMethods[i];
            if (Modifier.isNative(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methodIdentifiers.add(new MethodIdentifier(method));
        }
        MethodIdentifier[] identMethods = new MethodIdentifier[methodIdentifiers.size()];
        for (int i = 0; i < methodIdentifiers.size(); ++i) {
            identMethods[i] = (MethodIdentifier)methodIdentifiers.get(i);
        }
        return identMethods;
    }

    public static Method getMethod(Class c, MethodIdentifier methodIdentifier) throws NoSuchMethodException, ClassNotFoundException {
        return c.getDeclaredMethod(methodIdentifier.getMethodName(), methodIdentifier.getDescriptor().getParameterTypes(c.getClassLoader()));
    }
}

