/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.management.rmp;

import com.jrockit.common.rmp.JRockitConnectionException;
import com.jrockit.common.rmp.RmpPacket;
import com.jrockit.common.util.Debug;
import com.jrockit.management.rmp.RmpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RmpWriterThread
implements Runnable {
    private boolean m_alive = true;
    private final List<RmpPacket> m_queue = Collections.synchronizedList(new LinkedList());
    private final RmpServer m_rmpServer;
    private final OutputStream m_out;

    public RmpWriterThread(RmpServer rmpServer, OutputStream out) {
        this.m_rmpServer = rmpServer;
        this.m_out = out;
        Thread t = new Thread(rmpServer.getSocketListener().getManagementServerThreadGroup(), this, "[JRockit] Write Queue");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addForWriting(RmpPacket rmpPacket) {
        if (this.m_alive) {
            this.m_queue.add(rmpPacket);
        }
        RmpWriterThread rmpWriterThread = this;
        synchronized (rmpWriterThread) {
            this.notifyAll();
        }
    }

    public void sendNowAndCloseQueue(RmpPacket rmpPacket) throws JRockitConnectionException {
        this.m_alive = false;
        this.m_queue.clear();
        this.sendPacket(rmpPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.m_alive = false;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        try {
            object = this.m_out;
            synchronized (object) {
                this.m_out.close();
            }
        }
        catch (IOException ignored) {
            Debug.exception(ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.m_alive) {
            Object rmpPacket;
            while (!this.m_queue.isEmpty()) {
                rmpPacket = this.dequeue();
                try {
                    this.sendPacket((RmpPacket)rmpPacket);
                }
                catch (JRockitConnectionException e) {
                    Debug.println("Can't send queued RmpPacket due to: " + e);
                    this.m_rmpServer.close();
                }
            }
            if (!this.m_alive) continue;
            try {
                rmpPacket = this;
                synchronized (rmpPacket) {
                    this.wait(10000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private RmpPacket dequeue() {
        RmpPacket rmpPacket = this.m_queue.remove(0);
        return rmpPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(RmpPacket replyPacket) throws JRockitConnectionException {
        OutputStream outputStream = this.m_out;
        synchronized (outputStream) {
            replyPacket.writeToStream(this.m_out);
        }
    }
}

