/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.security.action.GetPropertyAction;

class XPStyle {
    private static XPStyle xp;
    private static Boolean themeActive;
    private HashMap map = new HashMap();
    private String styleFile;
    private String themeFile;

    static synchronized void invalidateStyle() {
        xp = null;
        themeActive = null;
    }

    static synchronized XPStyle getXP() {
        if (themeActive == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            themeActive = (Boolean)toolkit.getDesktopProperty("win.xpstyle.themeActive");
            if (themeActive == null) {
                themeActive = Boolean.FALSE;
            }
            if (themeActive.booleanValue() && AccessController.doPrivileged(new GetPropertyAction("swing.noxp")) == null && !(UIManager.getLookAndFeel() instanceof WindowsClassicLookAndFeel)) {
                xp = new XPStyle();
            }
        }
        return xp;
    }

    private static String getString(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = string;
        int n2 = string.lastIndexOf(46);
        if (n2 > 0 && string.length() > n2 + 1) {
            int n3;
            string2 = string.substring(0, n2);
            string4 = string.substring(n2 + 1);
            n2 = string2.lastIndexOf(40);
            if (n2 > 0 && (n3 = string2.indexOf(41, n2)) == string2.length() - 1) {
                string3 = string2.substring(n2 + 1, n3);
                string2 = string2.substring(0, n2);
            }
        }
        return XPStyle.getString(string2, string3, string4);
    }

    static String getString(String string, String string2, String string3) {
        int n2;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("win.xpstyle.resources.strings");
        String string4 = string == null || string.length() == 0 ? (String)map.get(string3) : (string2 == null || string2.length() == 0 ? (String)map.get(string + "." + string3) : (String)map.get(string + "(" + string2 + ")." + string3));
        if (string4 == null && (n2 = string.lastIndexOf(46)) > 0) {
            string4 = XPStyle.getString(string.substring(0, n2), string2, string3);
        }
        if (string4 == null && string2 != null && string2.length() > 0) {
            string4 = XPStyle.getString(string, "", string3);
        }
        return string4;
    }

    static BufferedImage getBitmapResource(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Map map = (Map)toolkit.getDesktopProperty("win.xpstyle.resources.images");
        return (BufferedImage)map.get(string);
    }

    int getInt(String string, int n2) {
        return this.parseInt(XPStyle.getString(string), n2);
    }

    private int parseInt(String string, int n2) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.abandonXP();
            }
        }
        return n2;
    }

    synchronized Dimension getDimension(String string) {
        String string2;
        Dimension dimension = (Dimension)this.map.get("Dimension " + string);
        if (dimension == null && (string2 = XPStyle.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            dimension = new Dimension(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Dimension " + string, dimension);
        }
        return dimension;
    }

    synchronized Point getPoint(String string) {
        String string2;
        Point point = (Point)this.map.get("Point " + string);
        if (point == null && (string2 = XPStyle.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            point = new Point(this.parseInt(stringTokenizer.nextToken(), 0), this.parseInt(stringTokenizer.nextToken(), 0));
            this.map.put("Point " + string, point);
        }
        return point;
    }

    synchronized Insets getMargin(String string) {
        String string2;
        Insets insets = (Insets)this.map.get("Margin " + string);
        if (insets == null && (string2 = XPStyle.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            insets = new Insets(0, 0, 0, 0);
            insets.left = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.right = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.top = this.parseInt(stringTokenizer.nextToken(), 0);
            insets.bottom = this.parseInt(stringTokenizer.nextToken(), 0);
            this.map.put("Margin " + string, insets);
        }
        return insets;
    }

    synchronized Color getColor(String string, Color color) {
        String string2;
        Color color2 = (Color)this.map.get("Color " + string);
        if (color2 == null && (string2 = XPStyle.getString(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t,");
            int n2 = this.parseInt(stringTokenizer.nextToken(), 0);
            int n3 = this.parseInt(stringTokenizer.nextToken(), 0);
            int n4 = this.parseInt(stringTokenizer.nextToken(), 0);
            if (n2 >= 0 && n3 >= 0 && n4 >= 0) {
                color2 = new ColorUIResource(n2, n3, n4);
                this.map.put("Color " + string, color2);
            }
        }
        return color2 != null ? color2 : color;
    }

    synchronized Border getBorder(String string) {
        if (string == "menu") {
            if (this.getBoolean("sysmetrics.flatmenus") == Boolean.TRUE) {
                return new XPFillBorder(UIManager.getColor("InternalFrame.borderShadow"), 1);
            }
            return null;
        }
        Border border = (Border)this.map.get("Border " + string);
        if (border == null) {
            Insets insets;
            String string2 = XPStyle.getString(string + ".bgtype");
            if ("borderfill".equalsIgnoreCase(string2)) {
                int n2 = this.getInt(string + ".bordersize", 1);
                Color color = this.getColor(string + ".bordercolor", Color.black);
                border = new XPFillBorder(color, n2);
            } else if ("imagefile".equalsIgnoreCase(string2) && (insets = this.getMargin(string + ".sizingmargins")) != null) {
                border = this.getBoolean(string + ".borderonly") == Boolean.TRUE ? new XPImageBorder(string) : new XPEmptyBorder(insets);
            }
            if (border != null) {
                this.map.put("Border " + string, border);
            }
        }
        return border;
    }

    synchronized Skin getSkin(String string) {
        Skin skin = (Skin)this.map.get("Skin " + string);
        if (skin == null) {
            skin = new Skin(string);
            this.map.put("Skin " + string, skin);
        }
        return skin;
    }

    private XPStyle() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.styleFile = (String)toolkit.getDesktopProperty("win.xpstyle.dllName");
        if (this.styleFile != null) {
            this.themeFile = XPStyle.getString("themeFile");
        }
    }

    private synchronized Image getImage(String string, Boolean bl2, Color color) {
        String string2 = XPStyle.getString(string);
        if (string2 == null) {
            return null;
        }
        String string3 = "Image " + string2;
        BufferedImage bufferedImage = (BufferedImage)this.map.get(string3);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        bufferedImage = XPStyle.getBitmapResource(string2);
        if (bufferedImage == null) {
            return null;
        }
        int n2 = bufferedImage.getColorModel().getTransparency();
        if (bl2 == Boolean.FALSE && n2 != 1) {
            bufferedImage = this.convertToOpaque(bufferedImage);
        } else if (bl2 == Boolean.TRUE && n2 == 1) {
            bufferedImage = this.convertToTransparent(bufferedImage, color);
        }
        this.map.put(string3, bufferedImage);
        return bufferedImage;
    }

    private BufferedImage convertToOpaque(BufferedImage bufferedImage) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        ColorConvertOp colorConvertOp = new ColorConvertOp(bufferedImage.getColorModel().getColorSpace(), bufferedImage2.getColorModel().getColorSpace(), null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private BufferedImage convertToTransparent(BufferedImage bufferedImage, Color color) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(n2, n3, 2);
        int n4 = color != null ? color.getRGB() | 0xFF000000 : -65281;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            bufferedImage.getRGB(0, i2, n2, 1, nArray, 0, n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                if (nArray[i3] != n4) continue;
                nArray[i3] = 0;
            }
            bufferedImage2.setRGB(0, i2, n2, 1, nArray, 0, n2);
        }
        return bufferedImage2;
    }

    private Boolean getBoolean(String string) {
        String string2 = XPStyle.getString(string);
        return string2 != null ? Boolean.valueOf("true".equalsIgnoreCase(string2)) : null;
    }

    private void abandonXP() {
        if (AccessController.doPrivileged(new GetPropertyAction("swing.debug")) != null) {
            System.err.println("An error occured in XPStyle while reading resource " + this.themeFile + " in " + this.styleFile);
            new Exception().printStackTrace();
        }
        xp = null;
    }

    static {
        themeActive = null;
        XPStyle.invalidateStyle();
    }

    static class GlyphButton
    extends JButton {
        private Skin skin;
        private Image glyphImage;
        private boolean vertical;

        public GlyphButton(String string) {
            XPStyle xPStyle = XPStyle.getXP();
            this.skin = xPStyle.getSkin(string);
            this.glyphImage = xPStyle.getImage(string + ".glyphimagefile", xPStyle.getBoolean(string + ".glyphtransparent"), null);
            this.setBorder(null);
            this.setContentAreaFilled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintComponent(Graphics graphics) {
            int n2 = 0;
            if (!this.isEnabled()) {
                n2 = 3;
            } else if (this.getModel().isPressed()) {
                n2 = 2;
            } else if (this.getModel().isRollover()) {
                n2 = 1;
            }
            Dimension dimension = this.getSize();
            this.skin.paintSkin(graphics, 0, 0, dimension.width, dimension.height, n2);
        }

        protected void paintBorder(Graphics graphics) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    class Skin {
        private String category;
        private Image image;
        private Insets contentMargin;
        private int w;
        private int h;
        private String imageSelectType;
        private Image scaledImage;
        private int nScaledImages;
        private int scaledToWidth = 0;
        private int scaledToHeight = 0;
        private Image glyphImage;
        private int frameCount;
        private Insets paintMargin;
        private boolean tile;
        private boolean sourceShrink;
        private boolean verticalFrames;

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (this.scaledImage != null) {
                return this.scaledImage;
            }
            return null;
        }

        Insets getContentMargin() {
            return this.paintMargin;
        }

        int getWidth() {
            return this.w;
        }

        int getHeight() {
            return this.h;
        }

        private Skin(String string) {
            this.category = string;
            XPStyle xPStyle2 = XPStyle.getXP();
            this.image = xPStyle2.getImage(string + ".imagefile", XPStyle.this.getBoolean(string + ".transparent"), xPStyle2.getColor(string + ".transparentcolor", null));
            this.nScaledImages = 0;
            while (true) {
                if (XPStyle.getString(string + ".imagefile" + (this.nScaledImages + 1)) == null) break;
                ++this.nScaledImages;
            }
            if (this.nScaledImages > 0) {
                int n2 = this.nScaledImages / 2 + 1;
                this.imageSelectType = XPStyle.getString(string + ".imageselecttype").toLowerCase();
                if ("dpi".equals(this.imageSelectType)) {
                    int n3 = Toolkit.getDefaultToolkit().getScreenResolution();
                    n2 = 1;
                    for (int i2 = this.nScaledImages; i2 >= 1; --i2) {
                        int n4 = xPStyle2.getInt(string + ".mindpi" + i2, -1);
                        if (n4 <= 0 || n3 < n4) continue;
                        n2 = i2;
                        break;
                    }
                }
                this.scaledImage = this.getScaledImage(n2);
            }
            this.frameCount = XPStyle.this.getInt(string + ".imagecount", 1);
            this.paintMargin = XPStyle.this.getMargin(string + ".sizingmargins");
            this.contentMargin = XPStyle.this.getMargin(string + ".contentmargins");
            this.tile = "tile".equalsIgnoreCase(XPStyle.getString(string + ".sizingtype"));
            this.sourceShrink = XPStyle.this.getBoolean(string + ".sourceshrink") == Boolean.TRUE;
            this.verticalFrames = "vertical".equalsIgnoreCase(XPStyle.getString(string + ".imagelayout"));
            this.glyphImage = xPStyle2.getImage(string + ".glyphimagefile", xPStyle2.getBoolean(string + ".glyphtransparent"), null);
            Image image = this.image;
            if (image == null && this.scaledImage != null) {
                image = this.scaledImage;
            }
            if (image != null) {
                if (this.frameCount < 1) {
                    XPStyle.this.abandonXP();
                }
                this.w = this.getImageWidth(image);
                this.h = this.getImageHeight(image);
            }
        }

        private int getImageWidth(Image image) {
            return image.getWidth(null) / (this.verticalFrames ? 1 : this.frameCount);
        }

        private int getImageHeight(Image image) {
            return image.getHeight(null) / (this.verticalFrames ? this.frameCount : 1);
        }

        private Image getScaledImage(int n2) {
            Boolean bl2 = xp.getBoolean(this.category + ".transparent");
            if (bl2 == null) {
                bl2 = xp.getBoolean(this.category + ".glyphtransparent");
            }
            return xp.getImage(this.category + ".imagefile" + n2, bl2, xp.getColor(this.category + ".transparentcolor", null));
        }

        private Image getScaledImage(int n2, int n3) {
            if ("size".equals(this.imageSelectType) && this.nScaledImages > 1 && (this.scaledToWidth != n2 || this.scaledToHeight != n3)) {
                this.scaledImage = this.getScaledImage(1);
                for (int i2 = 2; i2 <= this.nScaledImages; ++i2) {
                    Image image = this.getScaledImage(i2);
                    int n4 = n2;
                    int n5 = n3;
                    if (this.contentMargin != null) {
                        n4 -= this.contentMargin.left + this.contentMargin.right;
                        n5 -= this.contentMargin.top + this.contentMargin.bottom;
                    }
                    if (this.getImageWidth(image) > n4 || this.getImageHeight(image) > n5) break;
                    this.scaledImage = image;
                }
                this.scaledToWidth = n2;
                this.scaledToHeight = n3;
            }
            return this.scaledImage;
        }

        void paintSkin(Graphics graphics, int n2, int n3, int n4) {
            this.paintSkin(graphics, n2, n3, this.w, this.h, n4);
        }

        void paintSkin(Graphics graphics, Rectangle rectangle, int n2) {
            this.paintSkin(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n2);
        }

        void paintSkin(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
            Image image;
            if (!(this.image == null && this.scaledImage == null && this.glyphImage == null || n6 >= 0 && n6 < this.frameCount)) {
                XPStyle.this.abandonXP();
            }
            if (this.image != null) {
                int n7 = 0;
                if (this.h - (this.paintMargin != null ? this.paintMargin.top + this.paintMargin.bottom : 0) > n5 && this.tile && !this.sourceShrink) {
                    n7 = this.h - n5;
                }
                this.paint9(graphics, this.image, n2, n3, n4, n5, this.verticalFrames ? 0 : n6 * this.w, (this.verticalFrames ? n6 * this.h : 0) + n7, this.w, this.h, this.paintMargin, this.tile, this.sourceShrink);
            }
            if ((image = this.getScaledImage(n4, n5)) == null) {
                image = this.glyphImage;
            }
            if (image != null) {
                int n8 = this.getImageWidth(image);
                int n9 = this.getImageHeight(image);
                int n10 = this.verticalFrames ? 0 : n6 * n8;
                int n11 = this.verticalFrames ? n6 * n9 : 0;
                graphics.drawImage(image, n2 += (n4 - n8) / 2, n3 += (n5 - n9) / 2, n2 + n8, n3 + n9, n10, n11, n10 + n8, n11 + n9, null);
            }
        }

        private void paint9(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Insets insets, boolean bl2, boolean bl3) {
            int n10;
            int n11;
            int n12;
            int n13;
            if (insets != null) {
                n13 = insets.top;
                n12 = insets.bottom;
                n11 = insets.left;
                n10 = insets.right;
            } else {
                n10 = 0;
                n11 = 0;
                n12 = 0;
                n13 = 0;
            }
            if (bl2) {
                this.paintTile(graphics, image, n2 + n11, n3 + n13, n4 - n11 - n10, n5 - n13 - n12, n6 + n11, n7 + n13, n8 - n11 - n10, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2, n3 + n13, n11, n5 - n13 - n12, n6, n7 + n13, n11, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2 + n4 - n10, n3 + n13, n10, n5 - n13 - n12, n6 + n8 - n10, n7 + n13, n10, n9 - n13 - n12, bl3);
                this.paintTile(graphics, image, n2 + n11, n3, n4 - n11 - n10, n13, n6 + n11, n7, n8 - n11 - n10, n13, bl3);
                this.paintTile(graphics, image, n2 + n11, n3 + n5 - n12, n4 - n11 - n10, n12, n6 + n11, n7 + n9 - n12, n8 - n11 - n10, n12, bl3);
            } else {
                graphics.drawImage(image, n2 + n11, n3 + n13, n2 + n4 - n10, n3 + n5 - n12, n6 + n11, n7 + n13, n6 + n8 - n10, n7 + n9 - n12, null);
                graphics.drawImage(image, n2, n3 + n13, n2 + n11, n3 + n5 - n12, n6, n7 + n13, n6 + n11, n7 + n9 - n12, null);
                graphics.drawImage(image, n2 + n4 - n10, n3 + n13, n2 + n4, n3 + n5 - n12, n6 + n8 - n10, n7 + n13, n6 + n8, n7 + n9 - n12, null);
                graphics.drawImage(image, n2 + n11, n3, n2 + n4 - n10, n3 + n13, n6 + n11, n7, n6 + n8 - n10, n7 + n13, null);
                graphics.drawImage(image, n2 + n11, n3 + n5 - n12, n2 + n4 - n10, n3 + n5, n6 + n11, n7 + n9 - n12, n6 + n8 - n10, n7 + n9, null);
            }
            graphics.drawImage(image, n2, n3, n2 + n11, n3 + n13, n6, n7, n6 + n11, n7 + n13, null);
            graphics.drawImage(image, n2 + n4 - n10, n3, n2 + n4, n3 + n13, n6 + n8 - n10, n7, n6 + n8, n7 + n13, null);
            graphics.drawImage(image, n2, n3 + n5 - n12, n2 + n11, n3 + n5, n6, n7 + n9 - n12, n6 + n11, n7 + n9, null);
            graphics.drawImage(image, n2 + n4 - n10, n3 + n5 - n12, n2 + n4, n3 + n5, n6 + n8 - n10, n7 + n9 - n12, n6 + n8, n7 + n9, null);
        }

        private void paintTile(Graphics graphics, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
            if (n4 <= 0 || n5 <= 0 || n8 <= 0 || n9 <= 0) {
                return;
            }
            if (bl2 && (n8 > n4 || n9 > n5)) {
                if (n8 > n4 && n9 > n5) {
                    graphics.drawImage(image, n2, n3, n2 + n4, n3 + n5, n6, n7, n6 + n8, n7 + n9, null);
                } else if (n9 > n5) {
                    int n10;
                    BufferedImage bufferedImage = new BufferedImage(n8, n5, 2);
                    Graphics graphics2 = bufferedImage.getGraphics();
                    graphics2.drawImage(image, 0, 0, n8, n5, n6, n7, n6 + n8, n7 + n9, null);
                    for (int i2 = n2; i2 < n2 + n4; i2 += n10) {
                        n10 = Math.min(n8, n2 + n4 - i2);
                        graphics.drawImage(bufferedImage, i2, n3, i2 + n10, n3 + n5, 0, 0, n10, n5, null);
                    }
                    graphics2.dispose();
                } else {
                    BufferedImage bufferedImage = new BufferedImage(n4, n9, 2);
                    Graphics graphics3 = bufferedImage.getGraphics();
                    graphics3.drawImage(image, 0, 0, n4, n9, n6, n7, n6 + n8, n7 + n9, null);
                    for (int i3 = n3; i3 < n3 + n5; i3 += n9) {
                        n9 = Math.min(n9, n3 + n5 - i3);
                        graphics.drawImage(bufferedImage, n2, i3, n2 + n4, i3 + n9, 0, 0, n4, n9, null);
                    }
                    graphics3.dispose();
                }
            } else {
                for (int i4 = n3; i4 < n3 + n5; i4 += n9) {
                    int n11;
                    n9 = Math.min(n9, n3 + n5 - i4);
                    for (int i5 = n2; i5 < n2 + n4; i5 += n11) {
                        n11 = Math.min(n8, n2 + n4 - i5);
                        graphics.drawImage(image, i5, i4, i5 + n11, i4 + n9, n6, n7, n6 + n11, n7 + n9, null);
                    }
                }
            }
        }
    }

    private class XPEmptyBorder
    extends EmptyBorder
    implements UIResource {
        XPEmptyBorder(Insets insets) {
            super(insets.top + 2, insets.left + 2, insets.bottom + 2, insets.right + 2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, this.getBorderInsets());
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            if (insets2 != null) {
                insets.top = insets2.top + 2;
                insets.left = insets2.left + 2;
                insets.bottom = insets2.bottom + 2;
                insets.right = insets2.right + 2;
            }
            return insets;
        }
    }

    private class XPFillBorder
    extends LineBorder
    implements UIResource {
        XPFillBorder(Color color, int n2) {
            super(color, n2);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + this.thickness;
            insets.left = (insets2 != null ? insets2.left : 0) + this.thickness;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + this.thickness;
            insets.right = (insets2 != null ? insets2.right : 0) + this.thickness;
            return insets;
        }
    }

    private class XPImageBorder
    extends AbstractBorder
    implements UIResource {
        Skin skin;

        XPImageBorder(String string) {
            this.skin = XPStyle.this.getSkin(string);
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            this.skin.paintSkin(graphics, n2, n3, n4, n5, 0);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            Insets insets3 = this.skin.getContentMargin();
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            } else if (component instanceof JToolBar) {
                insets2 = ((JToolBar)component).getMargin();
            } else if (component instanceof JTextComponent) {
                insets2 = ((JTextComponent)component).getMargin();
            }
            insets.top = (insets2 != null ? insets2.top : 0) + insets3.top;
            insets.left = (insets2 != null ? insets2.left : 0) + insets3.left;
            insets.bottom = (insets2 != null ? insets2.bottom : 0) + insets3.bottom;
            insets.right = (insets2 != null ? insets2.right : 0) + insets3.right;
            return insets;
        }
    }
}

