/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SnmpOid
extends SnmpValue {
    protected long[] components = null;
    protected int componentCount = 0;
    static final String name = "Object Identifier";
    private static SnmpOidTable meta = null;
    static final long serialVersionUID = 8956237235607885096L;

    public SnmpOid() {
        this.components = new long[15];
        this.componentCount = 0;
    }

    public SnmpOid(long[] lArray) {
        this.components = (long[])lArray.clone();
        this.componentCount = this.components.length;
    }

    public SnmpOid(long l2) {
        this.components = new long[1];
        this.components[0] = l2;
        this.componentCount = this.components.length;
    }

    public SnmpOid(long l2, long l3, long l4, long l5) {
        this.components = new long[4];
        this.components[0] = l2;
        this.components[1] = l3;
        this.components[2] = l4;
        this.components[3] = l5;
        this.componentCount = this.components.length;
    }

    public SnmpOid(String string) throws IllegalArgumentException {
        String string2 = string;
        if (!string.startsWith(".")) {
            try {
                string2 = this.resolveVarName(string);
            }
            catch (SnmpStatusException snmpStatusException) {
                throw new IllegalArgumentException(snmpStatusException.getMessage());
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", false);
        this.componentCount = stringTokenizer.countTokens();
        if (this.componentCount == 0) {
            this.components = new long[15];
        } else {
            this.components = new long[this.componentCount];
            try {
                for (int i2 = 0; i2 < this.componentCount; ++i2) {
                    try {
                        this.components[i2] = Long.parseLong(stringTokenizer.nextToken());
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string);
            }
        }
    }

    public int getLength() {
        return this.componentCount;
    }

    public long[] longValue() {
        long[] lArray = new long[this.componentCount];
        System.arraycopy(this.components, 0, lArray, 0, this.componentCount);
        return lArray;
    }

    public final long[] longValue(boolean bl2) {
        if (bl2) {
            return this.longValue();
        }
        if (this.componentCount == this.components.length) {
            return this.components;
        }
        this.components = this.longValue();
        this.componentCount = this.components.length;
        return this.components;
    }

    public final long getOidArc(int n2) throws SnmpStatusException {
        try {
            return this.components[n2];
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public Long toLong() {
        if (this.componentCount != 1) {
            throw new IllegalArgumentException();
        }
        return new Long(this.components[0]);
    }

    public Integer toInteger() {
        if (this.componentCount != 1 || this.components[0] > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return new Integer((int)this.components[0]);
    }

    public String toString() {
        String string = "";
        if (this.componentCount >= 1) {
            for (int i2 = 0; i2 < this.componentCount - 1; ++i2) {
                string = string + this.components[i2] + ".";
            }
            string = string + this.components[this.componentCount - 1];
        }
        return string;
    }

    public Boolean toBoolean() {
        if (this.componentCount != 1 && this.components[0] != 1L && this.components[0] != 2L) {
            throw new IllegalArgumentException();
        }
        return new Boolean(this.components[0] == 1L);
    }

    public Byte[] toByte() {
        Byte[] byteArray = new Byte[this.componentCount];
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byteArray[i2] = new Byte((byte)this.components[i2]);
        }
        return byteArray;
    }

    public SnmpOid toOid() {
        long[] lArray = new long[this.componentCount];
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            lArray[i2] = this.components[i2];
        }
        return new SnmpOid(lArray);
    }

    public static SnmpOid toOid(long[] lArray, int n2) throws SnmpStatusException {
        try {
            if (lArray[n2] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            int n3 = (int)lArray[n2++];
            long[] lArray2 = new long[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                lArray2[i2] = lArray[n2 + i2];
            }
            return new SnmpOid(lArray2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n2) throws SnmpStatusException {
        try {
            int n3;
            if (lArray[n2] > Integer.MAX_VALUE) {
                throw new SnmpStatusException(2);
            }
            if ((n2 += (n3 = (int)lArray[n2++])) <= lArray.length) {
                return n2;
            }
            throw new SnmpStatusException(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        snmpOid2.append(snmpOid.getLength());
        snmpOid2.append(snmpOid);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public Object clone() {
        try {
            SnmpOid snmpOid = (SnmpOid)super.clone();
            snmpOid.components = new long[this.componentCount];
            System.arraycopy(this.components, 0, snmpOid.components, 0, this.componentCount);
            return snmpOid;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void insert(long l2) {
        this.enlargeIfNeeded(1);
        for (int i2 = this.componentCount - 1; i2 >= 0; --i2) {
            this.components[i2 + 1] = this.components[i2];
        }
        this.components[0] = l2;
        ++this.componentCount;
    }

    public void insert(int n2) {
        this.insert((long)n2);
    }

    public void append(SnmpOid snmpOid) {
        this.enlargeIfNeeded(snmpOid.componentCount);
        for (int i2 = 0; i2 < snmpOid.componentCount; ++i2) {
            this.components[this.componentCount + i2] = snmpOid.components[i2];
        }
        this.componentCount += snmpOid.componentCount;
    }

    public void append(long l2) {
        this.enlargeIfNeeded(1);
        this.components[this.componentCount] = l2;
        ++this.componentCount;
    }

    public void addToOid(String string) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(string);
        this.append(snmpOid);
    }

    public void addToOid(long[] lArray) throws SnmpStatusException {
        SnmpOid snmpOid = new SnmpOid(lArray);
        this.append(snmpOid);
    }

    public boolean isValid() {
        return this.componentCount >= 2 && 0L <= this.components[0] && this.components[0] < 3L && 0L <= this.components[1] && this.components[1] < 40L;
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object instanceof SnmpOid) {
            SnmpOid snmpOid = (SnmpOid)object;
            if (snmpOid.componentCount == this.componentCount) {
                int n2;
                long[] lArray = snmpOid.components;
                for (n2 = 0; n2 < this.componentCount && this.components[n2] == lArray[n2]; ++n2) {
                }
                bl2 = n2 == this.componentCount;
            }
        }
        return bl2;
    }

    public int hashCode() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            l2 = l2 * 31L + this.components[i2];
        }
        return (int)l2;
    }

    public int compareTo(SnmpOid snmpOid) {
        int n2 = 0;
        int n3 = 0;
        int n4 = Math.min(this.componentCount, snmpOid.componentCount);
        long[] lArray = snmpOid.components;
        for (n3 = 0; n3 < n4 && this.components[n3] == lArray[n3]; ++n3) {
        }
        n2 = n3 == this.componentCount && n3 == snmpOid.componentCount ? 0 : (n3 == this.componentCount ? -1 : (n3 == snmpOid.componentCount ? 1 : (this.components[n3] < lArray[n3] ? -1 : 1)));
        return n2;
    }

    public String resolveVarName(String string) throws SnmpStatusException {
        int n2 = string.indexOf(46);
        try {
            return this.handleLong(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (meta == null) {
                throw new SnmpStatusException(2);
            }
            if (n2 <= 0) {
                SnmpOidRecord snmpOidRecord = meta.resolveVarName(string);
                return snmpOidRecord.getOid();
            }
            SnmpOidRecord snmpOidRecord = meta.resolveVarName(string.substring(0, n2));
            return snmpOidRecord.getOid() + string.substring(n2);
        }
    }

    public String getTypeName() {
        return name;
    }

    public static SnmpOidTable getSnmpOidTable() {
        return meta;
    }

    public static void setSnmpOidTable(SnmpOidTable snmpOidTable) {
        meta = snmpOidTable;
    }

    public String toOctetString() {
        return new String(this.tobyte());
    }

    private byte[] tobyte() {
        byte[] byArray = new byte[this.componentCount];
        for (int i2 = 0; i2 < this.componentCount; ++i2) {
            if (this.components[0] > 255L) {
                throw new IllegalArgumentException();
            }
            byArray[i2] = (byte)this.components[i2];
        }
        return byArray;
    }

    private void enlargeIfNeeded(int n2) {
        int n3;
        for (n3 = this.components.length; this.componentCount + n2 > n3; n3 *= 2) {
        }
        if (n3 > this.components.length) {
            long[] lArray = new long[n3];
            for (int i2 = 0; i2 < this.components.length; ++i2) {
                lArray[i2] = this.components[i2];
            }
            this.components = lArray;
        }
    }

    private String handleLong(String string, int n2) throws NumberFormatException, SnmpStatusException {
        String string2 = n2 > 0 ? string.substring(0, n2) : string;
        Long.parseLong(string2);
        return string;
    }
}

