/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node {
    private String file_name;
    private String package_name;
    private String source_file_name = "<Unknown>";
    private int class_name_index;
    private int superclass_name_index;
    private String class_name;
    private String superclass_name;
    private int major;
    private int minor;
    private ConstantPool constant_pool;
    private int[] interfaces;
    private String[] interface_names;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private byte source = 1;
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    static boolean debug = false;
    static char sep = (char)47;

    public JavaClass(int n2, int n3, String string, int n4, int n5, int n6, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray, byte by) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (attributeArray == null) {
            this.attributes = new Attribute[0];
        }
        if (fieldArray == null) {
            fieldArray = new Field[]{};
        }
        if (methodArray == null) {
            methodArray = new Method[]{};
        }
        this.class_name_index = n2;
        this.superclass_name_index = n3;
        this.file_name = string;
        this.major = n4;
        this.minor = n5;
        this.access_flags = n6;
        this.constant_pool = constantPool;
        this.interfaces = nArray;
        this.fields = fieldArray;
        this.methods = methodArray;
        this.attributes = attributeArray;
        this.source = by;
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (!(attributeArray[i2] instanceof SourceFile)) continue;
            this.source_file_name = ((SourceFile)attributeArray[i2]).getSourceFileName();
            break;
        }
        this.class_name = constantPool.getConstantString(n2, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        int n7 = this.class_name.lastIndexOf(46);
        this.package_name = n7 < 0 ? "" : this.class_name.substring(0, n7);
        if (n3 > 0) {
            this.superclass_name = constantPool.getConstantString(n3, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[nArray.length];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            String string2 = constantPool.getConstantString(nArray[i3], (byte)7);
            this.interface_names[i3] = Utility.compactClassName(string2, false);
        }
    }

    public JavaClass(int n2, int n3, String string, int n4, int n5, int n6, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray) {
        this(n2, n3, string, n4, n5, n6, constantPool, nArray, fieldArray, methodArray, attributeArray, 1);
    }

    public void accept(Visitor visitor) {
        visitor.visitJavaClass(this);
    }

    static final void Debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public void dump(File file) throws IOException {
        File file2;
        String string = file.getParent();
        if (string != null && (file2 = new File(string)) != null) {
            file2.mkdirs();
        }
        this.dump(new DataOutputStream(new FileOutputStream(file)));
    }

    public void dump(String string) throws IOException {
        this.dump(new File(string));
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.dump(dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void dump(OutputStream outputStream) throws IOException {
        this.dump(new DataOutputStream(outputStream));
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n2;
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constant_pool.dump(dataOutputStream);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.class_name_index);
        dataOutputStream.writeShort(this.superclass_name_index);
        dataOutputStream.writeShort(this.interfaces.length);
        for (n2 = 0; n2 < this.interfaces.length; ++n2) {
            dataOutputStream.writeShort(this.interfaces[n2]);
        }
        dataOutputStream.writeShort(this.fields.length);
        for (n2 = 0; n2 < this.fields.length; ++n2) {
            this.fields[n2].dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.length);
        for (n2 = 0; n2 < this.methods.length; ++n2) {
            this.methods[n2].dump(dataOutputStream);
        }
        if (this.attributes != null) {
            dataOutputStream.writeShort(this.attributes.length);
            for (n2 = 0; n2 < this.attributes.length; ++n2) {
                this.attributes[n2].dump(dataOutputStream);
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.close();
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getPackageName() {
        return this.package_name;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.file_name;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public int getMajor() {
        return this.major;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSourceFileName() {
        return this.source_file_name;
    }

    public String getSuperclassName() {
        return this.superclass_name;
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setClassNameIndex(int n2) {
        this.class_name_index = n2;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setFileName(String string) {
        this.file_name = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.interface_names = stringArray;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public void setMajor(int n2) {
        this.major = n2;
    }

    public void setMethods(Method[] methodArray) {
        this.methods = methodArray;
    }

    public void setMinor(int n2) {
        this.minor = n2;
    }

    public void setSourceFileName(String string) {
        this.source_file_name = string;
    }

    public void setSuperclassName(String string) {
        this.superclass_name = string;
    }

    public void setSuperclassNameIndex(int n2) {
        this.superclass_name_index = n2;
    }

    public String toString() {
        int n2;
        String string = Utility.accessToString(this.access_flags, true);
        string = string.equals("") ? "" : string + " ";
        StringBuffer stringBuffer = new StringBuffer(string + Utility.classOrInterface(this.access_flags) + " " + this.class_name + " extends " + Utility.compactClassName(this.superclass_name, false) + '\n');
        int n3 = this.interfaces.length;
        if (n3 > 0) {
            stringBuffer.append("implements\t\t");
            for (n2 = 0; n2 < n3; ++n2) {
                stringBuffer.append(this.interface_names[n2]);
                if (n2 >= n3 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("filename\t\t" + this.file_name + '\n');
        stringBuffer.append("compiled from\t\t" + this.source_file_name + '\n');
        stringBuffer.append("compiler version\t" + this.major + "." + this.minor + '\n');
        stringBuffer.append("access flags\t\t" + this.access_flags + '\n');
        stringBuffer.append("constant pool\t\t" + this.constant_pool.getLength() + " entries\n");
        stringBuffer.append("ACC_SUPER flag\t\t" + this.isSuper() + "\n");
        if (this.attributes.length > 0) {
            stringBuffer.append("\nAttribute(s):\n");
            for (n2 = 0; n2 < this.attributes.length; ++n2) {
                stringBuffer.append(JavaClass.indent(this.attributes[n2]));
            }
        }
        if (this.fields.length > 0) {
            stringBuffer.append("\n" + this.fields.length + " fields:\n");
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                stringBuffer.append("\t" + this.fields[n2] + '\n');
            }
        }
        if (this.methods.length > 0) {
            stringBuffer.append("\n" + this.methods.length + " methods:\n");
            for (n2 = 0; n2 < this.methods.length; ++n2) {
                stringBuffer.append("\t" + this.methods[n2] + '\n');
            }
        }
        return stringBuffer.toString();
    }

    private static final String indent(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "\n");
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\t" + stringTokenizer.nextToken() + "\n");
        }
        return stringBuffer.toString();
    }

    public JavaClass copy() {
        int n2;
        JavaClass javaClass = null;
        try {
            javaClass = (JavaClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        javaClass.constant_pool = this.constant_pool.copy();
        javaClass.interfaces = (int[])this.interfaces.clone();
        javaClass.interface_names = (String[])this.interface_names.clone();
        javaClass.fields = new Field[this.fields.length];
        for (n2 = 0; n2 < this.fields.length; ++n2) {
            javaClass.fields[n2] = this.fields[n2].copy(javaClass.constant_pool);
        }
        javaClass.methods = new Method[this.methods.length];
        for (n2 = 0; n2 < this.methods.length; ++n2) {
            javaClass.methods[n2] = this.methods[n2].copy(javaClass.constant_pool);
        }
        javaClass.attributes = new Attribute[this.attributes.length];
        for (n2 = 0; n2 < this.attributes.length; ++n2) {
            javaClass.attributes[n2] = this.attributes[n2].copy(javaClass.constant_pool);
        }
        return javaClass;
    }

    public final boolean instanceOf(JavaClass javaClass) {
        return Repository.instanceOf(this, javaClass);
    }

    public final boolean isSuper() {
        return (this.access_flags & 0x20) != 0;
    }

    public final boolean isClass() {
        return (this.access_flags & 0x200) == 0;
    }

    public final byte getSource() {
        return this.source;
    }

    static {
        sep = File.separatorChar;
    }
}

