/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.JsrInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.ReturnaddressType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.PassVerifier;
import com.sun.org.apache.bcel.internal.verifier.VerificationResult;
import com.sun.org.apache.bcel.internal.verifier.Verifier;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.VerifierConstraintViolatedException;
import com.sun.org.apache.bcel.internal.verifier.structurals.ControlFlowGraph;
import com.sun.org.apache.bcel.internal.verifier.structurals.ExceptionHandler;
import com.sun.org.apache.bcel.internal.verifier.structurals.ExecutionVisitor;
import com.sun.org.apache.bcel.internal.verifier.structurals.Frame;
import com.sun.org.apache.bcel.internal.verifier.structurals.InstConstraintVisitor;
import com.sun.org.apache.bcel.internal.verifier.structurals.InstructionContext;
import com.sun.org.apache.bcel.internal.verifier.structurals.LocalVariables;
import com.sun.org.apache.bcel.internal.verifier.structurals.OperandStack;
import com.sun.org.apache.bcel.internal.verifier.structurals.UninitializedObjectType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;

public final class Pass3bVerifier
extends PassVerifier {
    private static final boolean DEBUG = true;
    private Verifier myOwner;
    private int method_no;

    public Pass3bVerifier(Verifier verifier, int n2) {
        this.myOwner = verifier;
        this.method_no = n2;
    }

    private void circulationPump(ControlFlowGraph controlFlowGraph, InstructionContext instructionContext, Frame frame, InstConstraintVisitor instConstraintVisitor, ExecutionVisitor executionVisitor) {
        int n2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Random random = new Random();
        InstructionContextQueue instructionContextQueue = new InstructionContextQueue();
        instructionContext.execute(frame, new ArrayList(), instConstraintVisitor, executionVisitor);
        instructionContextQueue.add(instructionContext, new ArrayList());
        while (!instructionContextQueue.isEmpty()) {
            Object object6;
            object5 = instructionContextQueue.getIC(0);
            object4 = instructionContextQueue.getEC(0);
            instructionContextQueue.remove(0);
            object3 = (ArrayList)((ArrayList)object4).clone();
            object2 = (ArrayList)((ArrayList)object4).clone();
            ((ArrayList)object2).add(object5);
            if (object5.getInstruction().getInstruction() instanceof RET) {
                object = (RET)object5.getInstruction().getInstruction();
                ReturnaddressType returnaddressType = (ReturnaddressType)object5.getOutFrame((ArrayList)object3).getLocals().get(((RET)object).getIndex());
                object6 = controlFlowGraph.contextOf(returnaddressType.getTarget());
                InstructionContext instructionContext2 = null;
                int n3 = 0;
                for (int i2 = ((ArrayList)object3).size() - 1; i2 >= 0; --i2) {
                    if (n3 < 0) {
                        throw new AssertionViolatedException("More RET than JSR in execution chain?!");
                    }
                    if (((InstructionContext)((ArrayList)object3).get(i2)).getInstruction().getInstruction() instanceof JsrInstruction) {
                        if (n3 == 0) {
                            instructionContext2 = (InstructionContext)((ArrayList)object3).get(i2);
                            break;
                        }
                        --n3;
                    }
                    if (!(((InstructionContext)((ArrayList)object3).get(i2)).getInstruction().getInstruction() instanceof RET)) continue;
                    ++n3;
                }
                if (instructionContext2 == null) {
                    throw new AssertionViolatedException("RET without a JSR before in ExecutionChain?! EC: '" + object3 + "'.");
                }
                JsrInstruction jsrInstruction = (JsrInstruction)instructionContext2.getInstruction().getInstruction();
                if (object6 != controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor())) {
                    throw new AssertionViolatedException("RET '" + object5.getInstruction() + "' info inconsistent: jump back to '" + object6 + "' or '" + controlFlowGraph.contextOf(jsrInstruction.physicalSuccessor()) + "'?");
                }
                if (object6.execute(object5.getOutFrame((ArrayList)object3), (ArrayList)object2, instConstraintVisitor, executionVisitor)) {
                    instructionContextQueue.add((InstructionContext)object6, (ArrayList)((ArrayList)object2).clone());
                }
            } else {
                object = object5.getSuccessors();
                for (n2 = 0; n2 < ((InstructionContext[])object).length; ++n2) {
                    object6 = object[n2];
                    if (!object6.execute(object5.getOutFrame((ArrayList)object3), (ArrayList)object2, instConstraintVisitor, executionVisitor)) continue;
                    instructionContextQueue.add((InstructionContext)object6, (ArrayList)((ArrayList)object2).clone());
                }
            }
            object = object5.getExceptionHandlers();
            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                object6 = controlFlowGraph.contextOf(((ExceptionHandler)object[n2]).getHandlerStart());
                if (!object6.execute(new Frame(object5.getOutFrame((ArrayList)object3).getLocals(), new OperandStack(object5.getOutFrame((ArrayList)object3).getStack().maxStack(), ((ExceptionHandler)object[n2]).getExceptionType() == null ? Type.THROWABLE : ((ExceptionHandler)object[n2]).getExceptionType())), new ArrayList(), instConstraintVisitor, executionVisitor)) continue;
                instructionContextQueue.add((InstructionContext)object6, new ArrayList());
            }
        }
        object5 = instructionContext.getInstruction();
        do {
            if (!(((InstructionHandle)object5).getInstruction() instanceof ReturnInstruction) || controlFlowGraph.isDead((InstructionHandle)object5)) continue;
            object4 = controlFlowGraph.contextOf((InstructionHandle)object5);
            object3 = object4.getOutFrame(new ArrayList());
            object2 = ((Frame)object3).getLocals();
            for (int i3 = 0; i3 < ((LocalVariables)object2).maxLocals(); ++i3) {
                if (!(((LocalVariables)object2).get(i3) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object4 + "' may leave method with an uninitialized object in the local variables array '" + object2 + "'.");
            }
            object = ((Frame)object3).getStack();
            for (n2 = 0; n2 < ((OperandStack)object).size(); ++n2) {
                if (!(((OperandStack)object).peek(n2) instanceof UninitializedObjectType)) continue;
                this.addMessage("Warning: ReturnInstruction '" + object4 + "' may leave method with an uninitialized object on the operand stack '" + object + "'.");
            }
        } while ((object5 = ((InstructionHandle)object5).getNext()) != null);
    }

    public VerificationResult do_verify() {
        if (!this.myOwner.doPass3a(this.method_no).equals(VerificationResult.VR_OK)) {
            return VerificationResult.VR_NOTYET;
        }
        JavaClass javaClass = Repository.lookupClass(this.myOwner.getClassName());
        ConstantPoolGen constantPoolGen = new ConstantPoolGen(javaClass.getConstantPool());
        InstConstraintVisitor instConstraintVisitor = new InstConstraintVisitor();
        instConstraintVisitor.setConstantPoolGen(constantPoolGen);
        ExecutionVisitor executionVisitor = new ExecutionVisitor();
        executionVisitor.setConstantPoolGen(constantPoolGen);
        Method[] methodArray = javaClass.getMethods();
        try {
            MethodGen methodGen = new MethodGen(methodArray[this.method_no], this.myOwner.getClassName(), constantPoolGen);
            instConstraintVisitor.setMethodGen(methodGen);
            if (!methodGen.isAbstract() && !methodGen.isNative()) {
                ControlFlowGraph controlFlowGraph = new ControlFlowGraph(methodGen);
                Frame frame = new Frame(methodGen.getMaxLocals(), methodGen.getMaxStack());
                if (!methodGen.isStatic()) {
                    if (methodGen.getName().equals("<init>")) {
                        Frame._this = new UninitializedObjectType(new ObjectType(javaClass.getClassName()));
                        frame.getLocals().set(0, Frame._this);
                    } else {
                        Frame._this = null;
                        frame.getLocals().set(0, new ObjectType(javaClass.getClassName()));
                    }
                }
                Type[] typeArray = methodGen.getArgumentTypes();
                int n2 = 0;
                for (int i2 = 0; i2 < typeArray.length; ++i2) {
                    if (typeArray[i2] == Type.SHORT || typeArray[i2] == Type.BYTE || typeArray[i2] == Type.CHAR || typeArray[i2] == Type.BOOLEAN) {
                        typeArray[i2] = Type.INT;
                    }
                    frame.getLocals().set(n2 + i2 + (methodGen.isStatic() ? 0 : 1), typeArray[i2]);
                    if (typeArray[i2].getSize() != 2) continue;
                    frame.getLocals().set(++n2 + i2 + (methodGen.isStatic() ? 0 : 1), Type.UNKNOWN);
                }
                this.circulationPump(controlFlowGraph, controlFlowGraph.contextOf(methodGen.getInstructionList().getStart()), frame, instConstraintVisitor, executionVisitor);
            }
        }
        catch (VerifierConstraintViolatedException verifierConstraintViolatedException) {
            verifierConstraintViolatedException.extendMessage("Constraint violated in method '" + methodArray[this.method_no] + "':\n", "");
            return new VerificationResult(2, verifierConstraintViolatedException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            runtimeException.printStackTrace(printWriter);
            throw new AssertionViolatedException("Some RuntimeException occured while verify()ing class '" + javaClass.getClassName() + "', method '" + methodArray[this.method_no] + "'. Original RuntimeException's stack trace:\n---\n" + stringWriter + "---\n");
        }
        return VerificationResult.VR_OK;
    }

    public int getMethodNo() {
        return this.method_no;
    }

    private static final class InstructionContextQueue {
        private Vector ics = new Vector();
        private Vector ecs = new Vector();

        private InstructionContextQueue() {
        }

        public void add(InstructionContext instructionContext, ArrayList arrayList) {
            this.ics.add(instructionContext);
            this.ecs.add(arrayList);
        }

        public boolean isEmpty() {
            return this.ics.isEmpty();
        }

        public void remove() {
            this.remove(0);
        }

        public void remove(int n2) {
            this.ics.remove(n2);
            this.ecs.remove(n2);
        }

        public InstructionContext getIC(int n2) {
            return (InstructionContext)this.ics.get(n2);
        }

        public ArrayList getEC(int n2) {
            return (ArrayList)this.ecs.get(n2);
        }

        public int size() {
            return this.ics.size();
        }
    }
}

