/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

public class SuballocatedByteVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected byte[][] m_map;
    protected int m_firstFree = 0;
    protected byte[] m_map0;

    public SuballocatedByteVector() {
        this(2048);
    }

    public SuballocatedByteVector(int n2) {
        this.m_blocksize = n2;
        this.m_map0 = new byte[n2];
        this.m_map = new byte[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedByteVector(int n2, int n3) {
        this(n2);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int n2) {
        if (this.m_firstFree < n2) {
            this.m_firstFree = n2;
        }
    }

    public void addElement(byte by) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = by;
        } else {
            byte[] byArray;
            int n2 = this.m_firstFree / this.m_blocksize;
            int n3 = this.m_firstFree % this.m_blocksize;
            ++this.m_firstFree;
            if (n2 >= this.m_map.length) {
                int n4 = n2 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n4][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n2])) {
                this.m_map[n2] = new byte[this.m_blocksize];
                byArray = this.m_map[n2];
            }
            byArray[n3] = by;
        }
    }

    private void addElements(byte by, int n2) {
        if (this.m_firstFree + n2 < this.m_blocksize) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.m_map0[this.m_firstFree++] = by;
            }
        } else {
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n2;
            while (n2 > 0) {
                byte[] byArray;
                if (n3 >= this.m_map.length) {
                    int n5 = n3 + this.m_numblocks;
                    byte[][] byArrayArray = new byte[n5][];
                    System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                    this.m_map = byArrayArray;
                }
                if (null == (byArray = this.m_map[n3])) {
                    this.m_map[n3] = new byte[this.m_blocksize];
                    byArray = this.m_map[n3];
                }
                int n6 = this.m_blocksize - n4 < n2 ? this.m_blocksize - n4 : n2;
                n2 -= n6;
                while (n6-- > 0) {
                    byArray[n4++] = by;
                }
                ++n3;
                n4 = 0;
            }
        }
    }

    private void addElements(int n2) {
        int n3 = this.m_firstFree + n2;
        if (n3 > this.m_blocksize) {
            int n4 = this.m_firstFree % this.m_blocksize;
            int n5 = (this.m_firstFree + n2) % this.m_blocksize;
            for (int i2 = n4 + 1; i2 <= n5; ++i2) {
                this.m_map[i2] = new byte[this.m_blocksize];
            }
        }
        this.m_firstFree = n3;
    }

    private void insertElementAt(byte by, int n2) {
        if (n2 == this.m_firstFree) {
            this.addElement(by);
        } else if (n2 > this.m_firstFree) {
            byte[] byArray;
            int n3 = n2 / this.m_blocksize;
            if (n3 >= this.m_map.length) {
                int n4 = n3 + this.m_numblocks;
                byte[][] byArrayArray = new byte[n4][];
                System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
                this.m_map = byArrayArray;
            }
            if (null == (byArray = this.m_map[n3])) {
                this.m_map[n3] = new byte[this.m_blocksize];
                byArray = this.m_map[n3];
            }
            int n5 = n2 % this.m_blocksize;
            byArray[n5] = by;
            this.m_firstFree = n5 + 1;
        } else {
            int n6 = this.m_firstFree + 1 / this.m_blocksize;
            ++this.m_firstFree;
            int n7 = n2 % this.m_blocksize;
            for (int i2 = n2 / this.m_blocksize; i2 <= n6; ++i2) {
                byte by2;
                int n8 = this.m_blocksize - n7 - 1;
                byte[] byArray = this.m_map[i2];
                if (null == byArray) {
                    by2 = 0;
                    this.m_map[i2] = new byte[this.m_blocksize];
                    byArray = this.m_map[i2];
                } else {
                    by2 = byArray[this.m_blocksize - 1];
                    System.arraycopy(byArray, n7, byArray, n7 + 1, n8);
                }
                byArray[n7] = by;
                by = by2;
                n7 = 0;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(byte by) {
        int n2 = this.indexOf(by, 0);
        if (n2 < 0) {
            return false;
        }
        this.removeElementAt(n2);
        return true;
    }

    private void removeElementAt(int n2) {
        if (n2 < this.m_firstFree) {
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = n2 % this.m_blocksize;
            for (int i2 = n2 / this.m_blocksize; i2 <= n3; ++i2) {
                int n5 = this.m_blocksize - n4 - 1;
                byte[] byArray = this.m_map[i2];
                if (null == byArray) {
                    this.m_map[i2] = new byte[this.m_blocksize];
                    byArray = this.m_map[i2];
                } else {
                    System.arraycopy(byArray, n4 + 1, byArray, n4, n5);
                }
                if (i2 < n3) {
                    byte[] byArray2 = this.m_map[i2 + 1];
                    if (byArray2 != null) {
                        byArray[this.m_blocksize - 1] = byArray2 != null ? byArray2[0] : (byte)0;
                    }
                } else {
                    byArray[this.m_blocksize - 1] = 0;
                }
                n4 = 0;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(byte by, int n2) {
        byte[] byArray;
        if (n2 < this.m_blocksize) {
            this.m_map0[n2] = by;
            return;
        }
        int n3 = n2 / this.m_blocksize;
        int n4 = n2 % this.m_blocksize;
        if (n3 >= this.m_map.length) {
            int n5 = n3 + this.m_numblocks;
            byte[][] byArrayArray = new byte[n5][];
            System.arraycopy(this.m_map, 0, byArrayArray, 0, this.m_map.length);
            this.m_map = byArrayArray;
        }
        if (null == (byArray = this.m_map[n3])) {
            this.m_map[n3] = new byte[this.m_blocksize];
            byArray = this.m_map[n3];
        }
        byArray[n4] = by;
        if (n2 >= this.m_firstFree) {
            this.m_firstFree = n2 + 1;
        }
    }

    public byte elementAt(int n2) {
        if (n2 < this.m_blocksize) {
            return this.m_map0[n2];
        }
        return this.m_map[n2 / this.m_blocksize][n2 % this.m_blocksize];
    }

    private boolean contains(byte by) {
        return this.indexOf(by, 0) >= 0;
    }

    public int indexOf(byte by, int n2) {
        int n3;
        byte[] byArray;
        if (n2 >= this.m_firstFree) {
            return -1;
        }
        int n4 = n2 % this.m_blocksize;
        int n5 = this.m_firstFree / this.m_blocksize;
        for (int i2 = n2 / this.m_blocksize; i2 < n5; ++i2) {
            byArray = this.m_map[i2];
            if (byArray != null) {
                for (n3 = n4; n3 < this.m_blocksize; ++n3) {
                    if (byArray[n3] != by) continue;
                    return n3 + i2 * this.m_blocksize;
                }
            }
            n4 = 0;
        }
        n3 = this.m_firstFree % this.m_blocksize;
        byArray = this.m_map[n5];
        for (int i3 = n4; i3 < n3; ++i3) {
            if (byArray[i3] != by) continue;
            return i3 + n5 * this.m_blocksize;
        }
        return -1;
    }

    public int indexOf(byte by) {
        return this.indexOf(by, 0);
    }

    private int lastIndexOf(byte by) {
        int n2 = this.m_firstFree % this.m_blocksize;
        for (int i2 = this.m_firstFree / this.m_blocksize; i2 >= 0; --i2) {
            byte[] byArray = this.m_map[i2];
            if (byArray != null) {
                for (int i3 = n2; i3 >= 0; --i3) {
                    if (byArray[i3] != by) continue;
                    return i3 + i2 * this.m_blocksize;
                }
            }
            n2 = 0;
        }
        return -1;
    }
}

