/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.ImageMediaEntry;
import java.awt.MediaEntry;
import java.io.Serializable;

public class MediaTracker
implements Serializable {
    Component target;
    MediaEntry head;
    private static final long serialVersionUID = -483174189758638095L;
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    static final int DONE = 14;

    public MediaTracker(Component component) {
        this.target = component;
    }

    public void addImage(Image image, int n2) {
        this.addImage(image, n2, -1, -1);
    }

    public synchronized void addImage(Image image, int n2, int n3, int n4) {
        this.head = MediaEntry.insert(this.head, new ImageMediaEntry(this, image, n2, n3, n4));
    }

    public boolean checkAll() {
        return this.checkAll(false, true);
    }

    public boolean checkAll(boolean bl2) {
        return this.checkAll(bl2, true);
    }

    private synchronized boolean checkAll(boolean bl2, boolean bl3) {
        MediaEntry mediaEntry = this.head;
        boolean bl4 = true;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(bl2, bl3) & 0xE) == 0) {
                bl4 = false;
            }
            mediaEntry = mediaEntry.next;
        }
        return bl4;
    }

    public synchronized boolean isErrorAny() {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, true) & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsAny() {
        MediaEntry mediaEntry = this.head;
        int n2 = 0;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, true) & 4) != 0) {
                ++n2;
            }
            mediaEntry = mediaEntry.next;
        }
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = new Object[n2];
        mediaEntry = this.head;
        n2 = 0;
        while (mediaEntry != null) {
            if ((mediaEntry.getStatus(false, false) & 4) != 0) {
                objectArray[n2++] = mediaEntry.getMedia();
            }
            mediaEntry = mediaEntry.next;
        }
        return objectArray;
    }

    public void waitForAll() throws InterruptedException {
        this.waitForAll(0L);
    }

    public synchronized boolean waitForAll(long l2) throws InterruptedException {
        long l3 = System.currentTimeMillis() + l2;
        boolean bl2 = true;
        int n2;
        while (((n2 = this.statusAll(bl2, bl2)) & 1) != 0) {
            long l4;
            bl2 = false;
            if (l2 == 0L) {
                l4 = 0L;
            } else {
                l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) {
                    return false;
                }
            }
            this.wait(l4);
        }
        return n2 == 8;
    }

    public int statusAll(boolean bl2) {
        return this.statusAll(bl2, true);
    }

    private synchronized int statusAll(boolean bl2, boolean bl3) {
        MediaEntry mediaEntry = this.head;
        int n2 = 0;
        while (mediaEntry != null) {
            n2 |= mediaEntry.getStatus(bl2, bl3);
            mediaEntry = mediaEntry.next;
        }
        return n2;
    }

    public boolean checkID(int n2) {
        return this.checkID(n2, false, true);
    }

    public boolean checkID(int n2, boolean bl2) {
        return this.checkID(n2, bl2, true);
    }

    private synchronized boolean checkID(int n2, boolean bl2, boolean bl3) {
        MediaEntry mediaEntry = this.head;
        boolean bl4 = true;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n2 && (mediaEntry.getStatus(bl2, bl3) & 0xE) == 0) {
                bl4 = false;
            }
            mediaEntry = mediaEntry.next;
        }
        return bl4;
    }

    public synchronized boolean isErrorID(int n2) {
        MediaEntry mediaEntry = this.head;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n2 && (mediaEntry.getStatus(false, true) & 4) != 0) {
                return true;
            }
            mediaEntry = mediaEntry.next;
        }
        return false;
    }

    public synchronized Object[] getErrorsID(int n2) {
        MediaEntry mediaEntry = this.head;
        int n3 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n2 && (mediaEntry.getStatus(false, true) & 4) != 0) {
                ++n3;
            }
            mediaEntry = mediaEntry.next;
        }
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray = new Object[n3];
        mediaEntry = this.head;
        n3 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n2 && (mediaEntry.getStatus(false, false) & 4) != 0) {
                objectArray[n3++] = mediaEntry.getMedia();
            }
            mediaEntry = mediaEntry.next;
        }
        return objectArray;
    }

    public void waitForID(int n2) throws InterruptedException {
        this.waitForID(n2, 0L);
    }

    public synchronized boolean waitForID(int n2, long l2) throws InterruptedException {
        long l3 = System.currentTimeMillis() + l2;
        boolean bl2 = true;
        int n3;
        while (((n3 = this.statusID(n2, bl2, bl2)) & 1) != 0) {
            long l4;
            bl2 = false;
            if (l2 == 0L) {
                l4 = 0L;
            } else {
                l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) {
                    return false;
                }
            }
            this.wait(l4);
        }
        return n3 == 8;
    }

    public int statusID(int n2, boolean bl2) {
        return this.statusID(n2, bl2, true);
    }

    private synchronized int statusID(int n2, boolean bl2, boolean bl3) {
        MediaEntry mediaEntry = this.head;
        int n3 = 0;
        while (mediaEntry != null) {
            if (mediaEntry.getID() == n2) {
                n3 |= mediaEntry.getStatus(bl2, bl3);
            }
            mediaEntry = mediaEntry.next;
        }
        return n3;
    }

    public synchronized void removeImage(Image image) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getMedia() == image) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    public synchronized void removeImage(Image image, int n2) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getID() == n2 && mediaEntry.getMedia() == image) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    public synchronized void removeImage(Image image, int n2, int n3, int n4) {
        MediaEntry mediaEntry = this.head;
        MediaEntry mediaEntry2 = null;
        while (mediaEntry != null) {
            MediaEntry mediaEntry3 = mediaEntry.next;
            if (mediaEntry.getID() == n2 && mediaEntry instanceof ImageMediaEntry && ((ImageMediaEntry)mediaEntry).matches(image, n3, n4)) {
                if (mediaEntry2 == null) {
                    this.head = mediaEntry3;
                } else {
                    mediaEntry2.next = mediaEntry3;
                }
                mediaEntry.cancel();
            } else {
                mediaEntry2 = mediaEntry;
            }
            mediaEntry = mediaEntry3;
        }
        this.notifyAll();
    }

    synchronized void setDone() {
        this.notifyAll();
    }
}

