/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size = 0;
    private final Comparator<? super E> comparator;
    private transient int modCount = 0;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int n2) {
        this(n2, null);
    }

    public PriorityQueue(int n2, Comparator<? super E> comparator) {
        if (n2 < 1) {
            throw new IllegalArgumentException();
        }
        this.queue = new Object[n2 + 1];
        this.comparator = comparator;
    }

    private void initializeArray(Collection<? extends E> collection) {
        int n2 = collection.size();
        int n3 = (int)Math.min((long)n2 * 110L / 100L, 0x7FFFFFFEL);
        if (n3 < 1) {
            n3 = 1;
        }
        this.queue = new Object[n3 + 1];
    }

    private void fillFromSorted(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.queue[++this.size] = iterator.next();
        }
    }

    private void fillFromUnsorted(Collection<? extends E> collection) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.queue[++this.size] = iterator.next();
        }
        this.heapify();
    }

    public PriorityQueue(Collection<? extends E> collection) {
        this.initializeArray(collection);
        if (collection instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)collection;
            this.comparator = sortedSet.comparator();
            this.fillFromSorted(sortedSet);
        } else if (collection instanceof PriorityQueue) {
            PriorityQueue priorityQueue = (PriorityQueue)collection;
            this.comparator = priorityQueue.comparator();
            this.fillFromSorted(priorityQueue);
        } else {
            this.comparator = null;
            this.fillFromUnsorted(collection);
        }
    }

    public PriorityQueue(PriorityQueue<? extends E> priorityQueue) {
        this.initializeArray(priorityQueue);
        this.comparator = priorityQueue.comparator();
        this.fillFromSorted(priorityQueue);
    }

    public PriorityQueue(SortedSet<? extends E> sortedSet) {
        this.initializeArray(sortedSet);
        this.comparator = sortedSet.comparator();
        this.fillFromSorted(sortedSet);
    }

    private void grow(int n2) {
        int n3 = this.queue.length;
        if (n2 < n3) {
            return;
        }
        if (n2 == Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        while (n3 <= n2) {
            if (n3 >= 0x3FFFFFFF) {
                n3 = Integer.MAX_VALUE;
                continue;
            }
            n3 <<= 2;
        }
        Object[] objectArray = new Object[n3];
        System.arraycopy(this.queue, 0, objectArray, 0, this.queue.length);
        this.queue = objectArray;
    }

    @Override
    public boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        ++this.modCount;
        ++this.size;
        if (this.size >= this.queue.length) {
            this.grow(this.size);
        }
        this.queue[this.size] = e2;
        this.fixUp(this.size);
        return true;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return (E)this.queue[1];
    }

    @Override
    public boolean add(E e2) {
        return this.offer(e2);
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        if (this.comparator == null) {
            for (int i2 = 1; i2 <= this.size; ++i2) {
                if (((Comparable)this.queue[i2]).compareTo(object) != 0) continue;
                this.removeAt(i2);
                return true;
            }
        } else {
            for (int i3 = 1; i3 <= this.size; ++i3) {
                if (this.comparator.compare(this.queue[i3], object) != 0) continue;
                this.removeAt(i3);
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        Object object = this.queue[1];
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        if (this.size > 1) {
            this.fixDown(1);
        }
        return (E)object;
    }

    private E removeAt(int n2) {
        Object object;
        assert (n2 > 0 && n2 <= this.size);
        ++this.modCount;
        this.queue[n2] = object = this.queue[this.size];
        this.queue[this.size--] = null;
        if (n2 <= this.size) {
            this.fixDown(n2);
            if (this.queue[n2] == object) {
                this.fixUp(n2);
                if (this.queue[n2] != object) {
                    return (E)object;
                }
            }
        }
        return null;
    }

    private void fixUp(int n2) {
        if (this.comparator == null) {
            int n3;
            while (n2 > 1 && ((Comparable)this.queue[n3 = n2 >> 1]).compareTo(this.queue[n2]) > 0) {
                Object object = this.queue[n3];
                this.queue[n3] = this.queue[n2];
                this.queue[n2] = object;
                n2 = n3;
            }
        } else {
            int n4;
            while (n2 > 1 && this.comparator.compare(this.queue[n4 = n2 >>> 1], this.queue[n2]) > 0) {
                Object object = this.queue[n4];
                this.queue[n4] = this.queue[n2];
                this.queue[n2] = object;
                n2 = n4;
            }
        }
    }

    private void fixDown(int n2) {
        if (this.comparator == null) {
            int n3;
            while ((n3 = n2 << 1) <= this.size && n3 > 0) {
                if (n3 < this.size && ((Comparable)this.queue[n3]).compareTo(this.queue[n3 + 1]) > 0) {
                    ++n3;
                }
                if (((Comparable)this.queue[n2]).compareTo(this.queue[n3]) > 0) {
                    Object object = this.queue[n3];
                    this.queue[n3] = this.queue[n2];
                    this.queue[n2] = object;
                    n2 = n3;
                    continue;
                }
                break;
            }
        } else {
            int n4;
            while ((n4 = n2 << 1) <= this.size && n4 > 0) {
                if (n4 < this.size && this.comparator.compare(this.queue[n4], this.queue[n4 + 1]) > 0) {
                    ++n4;
                }
                if (this.comparator.compare(this.queue[n2], this.queue[n4]) > 0) {
                    Object object = this.queue[n4];
                    this.queue[n4] = this.queue[n2];
                    this.queue[n2] = object;
                    n2 = n4;
                    continue;
                }
                break;
            }
        }
    }

    private void heapify() {
        for (int i2 = this.size / 2; i2 >= 1; --i2) {
            this.fixDown(i2);
        }
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.queue.length);
        for (int i2 = 1; i2 <= this.size; ++i2) {
            objectOutputStream.writeObject(this.queue[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.queue = new Object[n2];
        for (int i2 = 1; i2 <= this.size; ++i2) {
            this.queue[i2] = objectInputStream.readObject();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private int cursor = 1;
        private int lastRet = 0;
        private int expectedModCount = PriorityQueue.access$100(PriorityQueue.this);
        private ArrayList<E> forgetMeNot = null;
        private Object lastRetElt = null;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= PriorityQueue.this.size || this.forgetMeNot != null;
        }

        @Override
        public E next() {
            Object object;
            this.checkForComodification();
            if (this.cursor <= PriorityQueue.this.size) {
                object = PriorityQueue.this.queue[this.cursor];
                this.lastRet = this.cursor++;
            } else {
                if (this.forgetMeNot == null) {
                    throw new NoSuchElementException();
                }
                int n2 = this.forgetMeNot.size();
                object = this.forgetMeNot.remove(n2 - 1);
                if (n2 == 1) {
                    this.forgetMeNot = null;
                }
                this.lastRet = 0;
                this.lastRetElt = object;
            }
            return object;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastRet != 0) {
                Object object = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = 0;
                if (object == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayList();
                    }
                    this.forgetMeNot.add(object);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.remove(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        final void checkForComodification() {
            if (PriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

