/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.RefAddr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reference
implements Cloneable,
Serializable {
    protected String className;
    protected Vector<RefAddr> addrs = null;
    protected String classFactory = null;
    protected String classFactoryLocation = null;
    private static final long serialVersionUID = -1673475790065791735L;

    public Reference(String string) {
        this.className = string;
        this.addrs = new Vector();
    }

    public Reference(String string, RefAddr refAddr) {
        this.className = string;
        this.addrs = new Vector();
        this.addrs.addElement(refAddr);
    }

    public Reference(String string, String string2, String string3) {
        this(string);
        this.classFactory = string2;
        this.classFactoryLocation = string3;
    }

    public Reference(String string, RefAddr refAddr, String string2, String string3) {
        this(string, refAddr);
        this.classFactory = string2;
        this.classFactoryLocation = string3;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFactoryClassName() {
        return this.classFactory;
    }

    public String getFactoryClassLocation() {
        return this.classFactoryLocation;
    }

    public RefAddr get(String string) {
        int n2 = this.addrs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RefAddr refAddr = this.addrs.elementAt(i2);
            if (refAddr.getType().compareTo(string) != 0) continue;
            return refAddr;
        }
        return null;
    }

    public RefAddr get(int n2) {
        return this.addrs.elementAt(n2);
    }

    public Enumeration<RefAddr> getAll() {
        return this.addrs.elements();
    }

    public int size() {
        return this.addrs.size();
    }

    public void add(RefAddr refAddr) {
        this.addrs.addElement(refAddr);
    }

    public void add(int n2, RefAddr refAddr) {
        this.addrs.insertElementAt(refAddr, n2);
    }

    public Object remove(int n2) {
        RefAddr refAddr = this.addrs.elementAt(n2);
        this.addrs.removeElementAt(n2);
        return refAddr;
    }

    public void clear() {
        this.addrs.setSize(0);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Reference) {
            Reference reference = (Reference)object;
            if (reference.className.equals(this.className) && reference.size() == this.size()) {
                Enumeration<RefAddr> enumeration = this.getAll();
                Enumeration<RefAddr> enumeration2 = reference.getAll();
                while (enumeration.hasMoreElements()) {
                    if (((Object)enumeration.nextElement()).equals(enumeration2.nextElement())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.className.hashCode();
        Enumeration<RefAddr> enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            n2 += ((Object)enumeration.nextElement()).hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Reference Class Name: " + this.className + "\n");
        int n2 = this.addrs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.get(i2).toString());
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        Reference reference = new Reference(this.className, this.classFactory, this.classFactoryLocation);
        Enumeration<RefAddr> enumeration = this.getAll();
        reference.addrs = new Vector();
        while (enumeration.hasMoreElements()) {
            reference.addrs.addElement(enumeration.nextElement());
        }
        return reference;
    }
}

