/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -8144641928112860441L;

    public SerialBlob(byte[] byArray) throws SerialException, SQLException {
        this.len = byArray.length;
        this.buf = new byte[(int)this.len];
        int n2 = 0;
        while ((long)n2 < this.len) {
            this.buf[n2] = byArray[n2];
            ++n2;
        }
        this.origLen = this.len;
    }

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a SerialBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
        this.origLen = this.len;
    }

    public byte[] getBytes(long l2, int n2) throws SerialException {
        if ((long)n2 > this.len) {
            n2 = (int)this.len;
        }
        if (l2 < 1L || (long)n2 - l2 < 0L) {
            throw new SerialException("Invalid arguments: position cannot be less that 1");
        }
        --l2;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = this.buf[(int)l2];
            ++l2;
        }
        return byArray;
    }

    public long length() throws SerialException {
        return this.len;
    }

    public InputStream getBinaryStream() throws SerialException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        return byteArrayInputStream;
    }

    public long position(byte[] byArray, long l2) throws SerialException, SQLException {
        if (l2 < 1L || l2 > this.len) {
            return -1L;
        }
        int n2 = (int)l2 - 1;
        int n3 = 0;
        long l3 = byArray.length;
        while ((long)n2 < this.len) {
            if (byArray[n3] == this.buf[n2]) {
                if ((long)(n3 + 1) == l3) {
                    return (long)(n2 + 1) - (l3 - 1L);
                }
                ++n3;
                ++n2;
                continue;
            }
            if (byArray[n3] == this.buf[n2]) continue;
            ++n2;
        }
        return -1L;
    }

    public long position(Blob blob, long l2) throws SerialException, SQLException {
        return this.position(blob.getBytes(1L, (int)blob.length()), l2);
    }

    public int setBytes(long l2, byte[] byArray) throws SerialException, SQLException {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SerialException, SQLException {
        int n4;
        if (n2 < 0 || n2 > byArray.length) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l2 < 1L || l2 > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n3 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n3 + n2 > byArray.length) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        --l2;
        for (n4 = 0; n4 < n3 || n2 + n4 + 1 < byArray.length - n2; ++n4) {
            this.buf[(int)l2 + n4] = byArray[n2 + n4];
        }
        return n4;
    }

    public OutputStream setBinaryStream(long l2) throws SerialException, SQLException {
        if (this.blob.setBinaryStream(l2) != null) {
            return this.blob.setBinaryStream(l2);
        }
        throw new SerialException("Unsupported operation. SerialBlob cannot return a writable binary stream, unless instantiated with a Blob object that provides a setBinaryStream() implementation");
    }

    public void truncate(long l2) throws SerialException {
        if (l2 > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        if ((int)l2 == 0) {
            this.buf = new byte[0];
            this.len = l2;
        } else {
            this.len = l2;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }
}

