/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.plaf.FontUIResource;
import sun.applet.AppletSecurity;
import sun.awt.AppContext;
import sun.awt.FontConfiguration;
import sun.font.CompositeFont;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontFamily;
import sun.font.NativeFont;
import sun.font.PhysicalFont;
import sun.font.StrikeCache;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.java2d.HeadlessGraphicsEnvironment;
import sun.java2d.SunGraphicsEnvironment;

public final class FontManager {
    public static final int FONTFORMAT_NONE = -1;
    public static final int FONTFORMAT_TRUETYPE = 0;
    public static final int FONTFORMAT_TYPE1 = 1;
    public static final int FONTFORMAT_T2K = 2;
    public static final int FONTFORMAT_TTC = 3;
    public static final int FONTFORMAT_COMPOSITE = 4;
    public static final int FONTFORMAT_NATIVE = 5;
    public static final int NO_FALLBACK = 0;
    public static final int PHYSICAL_FALLBACK = 1;
    public static final int LOGICAL_FALLBACK = 2;
    public static final int QUADPATHTYPE = 1;
    public static final int CUBICPATHTYPE = 2;
    private static final int CHANNELPOOLSIZE = 20;
    private static int lastPoolIndex = 0;
    private static int poolSize = 0;
    private static FileFont[] fontFileCache = new FileFont[20];
    private static int maxCompFont = 0;
    private static CompositeFont[] compFonts = new CompositeFont[20];
    private static Hashtable compositeFonts = new Hashtable();
    private static Hashtable physicalFonts = new Hashtable();
    private static Hashtable fullNameToFont = new Hashtable();
    private static HashMap localeFullNamesToFont;
    private static PhysicalFont defaultPhysicalFont;
    private static boolean usePlatformFontMetrics;
    public static Logger logger;
    public static boolean logging;
    static boolean longAddresses;
    static String osName;
    static boolean useT2K;
    static boolean isWindows;
    static boolean isSolaris;
    public static boolean isSolaris8;
    private static boolean loaded1dot0Fonts;
    static SunGraphicsEnvironment sgEnv;
    static boolean loadedAllFonts;
    static TrueTypeFont eudcFont;
    static HashMap<String, String> jreFontMap;
    private static String[] STR_ARRAY;
    private static final Hashtable deferredFontFiles;
    private static final Hashtable initialisedFonts;
    private static Hashtable fontNameCache;
    private static final short US_LCID = 1033;
    private static Map lcidMap;
    private static final Object altJAFontKey;
    private static final Object localeFontKey;
    private static final Object proportionalFontKey;
    public static boolean usingPerAppContextComposites;
    private static boolean usingAlternateComposites;
    private static boolean gAltJAFont;
    private static boolean gLocalePref;
    private static boolean gPropPref;

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToPool(FileFont fileFont) {
        boolean bl2 = false;
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            if (poolSize < 20) {
                for (int i2 = 0; i2 < 20; ++i2) {
                    if (fontFileCache[i2] != null) continue;
                    FontManager.fontFileCache[i2] = fileFont;
                    ++poolSize;
                    bl2 = true;
                    break;
                }
                assert (bl2);
            } else {
                assert (fontFileCache[lastPoolIndex] != fileFont);
                fontFileCache[lastPoolIndex].close();
                FontManager.fontFileCache[FontManager.lastPoolIndex] = fileFont;
                lastPoolIndex = (lastPoolIndex + 1) % 20;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromPool(FileFont fileFont) {
        FileFont[] fileFontArray = fontFileCache;
        synchronized (fontFileCache) {
            for (int i2 = 0; i2 < 20; ++i2) {
                if (fontFileCache[i2] != fileFont) continue;
                FontManager.fontFileCache[i2] = null;
                --poolSize;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean fontSupportsDefaultEncoding(Font font) {
        return FontManager.getFont2D(font) instanceof CompositeFont;
    }

    public static FontUIResource getCompositeFontUIResource(Font font) {
        FontUIResource fontUIResource = new FontUIResource(font.getName(), font.getStyle(), font.getSize());
        Font2D font2D = FontManager.getFont2D(font);
        if (!(font2D instanceof PhysicalFont)) {
            return fontUIResource;
        }
        CompositeFont compositeFont = (CompositeFont)FontManager.findFont2D("dialog", font.getStyle(), 0);
        if (compositeFont == null) {
            return fontUIResource;
        }
        if (compositeFont.getSlotFont(0) == font2D) {
            return fontUIResource;
        }
        PhysicalFont physicalFont = (PhysicalFont)font2D;
        CompositeFont compositeFont2 = new CompositeFont(physicalFont, compositeFont);
        compositeFont2.isStdComposite = false;
        FontManager.setFont2D(fontUIResource, compositeFont2.handle);
        return fontUIResource;
    }

    public static native void setFont2D(Font var0, Font2DHandle var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n2, int[] nArray, int[] nArray2, boolean bl2) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n2, nArray, nArray2, bl2);
        FontManager.addCompositeToFontList(compositeFont, 2);
        CompositeFont[] compositeFontArray = compFonts;
        synchronized (compFonts) {
            FontManager.compFonts[FontManager.maxCompFont++] = compositeFont;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public static void registerCompositeFont(String string, String[] stringArray, String[] stringArray2, int n2, int[] nArray, int[] nArray2, boolean bl2, Hashtable hashtable) {
        CompositeFont compositeFont = new CompositeFont(string, stringArray, stringArray2, n2, nArray, nArray2, bl2);
        Font2D font2D = (Font2D)hashtable.get(string.toLowerCase(Locale.ENGLISH));
        if (font2D instanceof CompositeFont) {
            font2D.handle.font2D = compositeFont;
        }
        hashtable.put(string.toLowerCase(Locale.ENGLISH), compositeFont);
    }

    private static void addCompositeToFontList(CompositeFont compositeFont, int n2) {
        if (logging) {
            logger.info("Add to Family " + compositeFont.familyName + ", Font " + compositeFont.fullName + " rank=" + n2);
        }
        compositeFont.setRank(n2);
        compositeFonts.put(compositeFont.fullName, compositeFont);
        fullNameToFont.put(compositeFont.fullName.toLowerCase(Locale.ENGLISH), compositeFont);
        FontFamily fontFamily = FontFamily.getFamily(compositeFont.familyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(compositeFont.familyName, true, n2);
        }
        fontFamily.setFont(compositeFont, compositeFont.style);
    }

    private static PhysicalFont addToFontList(PhysicalFont physicalFont, int n2) {
        String string = physicalFont.fullName;
        String string2 = physicalFont.familyName;
        if (string == null || "".equals(string)) {
            return null;
        }
        if (compositeFonts.containsKey(string)) {
            return null;
        }
        physicalFont.setRank(n2);
        if (!physicalFonts.containsKey(string)) {
            if (logging) {
                logger.info("Add to Family " + string2 + ", Font " + string + " rank=" + n2);
            }
            physicalFonts.put(string, physicalFont);
            FontFamily fontFamily = FontFamily.getFamily(string2);
            if (fontFamily == null) {
                fontFamily = new FontFamily(string2, false, n2);
                fontFamily.setFont(physicalFont, physicalFont.style);
            } else if (fontFamily.getRank() >= n2) {
                fontFamily.setFont(physicalFont, physicalFont.style);
            }
            fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont);
            return physicalFont;
        }
        PhysicalFont physicalFont2 = physicalFont;
        PhysicalFont physicalFont3 = (PhysicalFont)physicalFonts.get(string);
        if (physicalFont3 == null) {
            return null;
        }
        if (physicalFont3.getRank() >= n2) {
            Object object;
            if (physicalFont3.mapper != null && n2 > 2) {
                return physicalFont3;
            }
            if (physicalFont3.getRank() == n2) {
                if (physicalFont3 instanceof TrueTypeFont && physicalFont2 instanceof TrueTypeFont) {
                    object = (TrueTypeFont)physicalFont3;
                    TrueTypeFont trueTypeFont = (TrueTypeFont)physicalFont2;
                    if (((TrueTypeFont)object).fileSize >= trueTypeFont.fileSize) {
                        return physicalFont3;
                    }
                } else {
                    return physicalFont3;
                }
            }
            if (physicalFont3.platName.startsWith(SunGraphicsEnvironment.jreFontDirName)) {
                if (logging) {
                    logger.warning("Unexpected attempt to replace a JRE  font " + string + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
                }
                return physicalFont3;
            }
            if (logging) {
                logger.info("Replace in Family " + string2 + ",Font " + string + " new rank=" + n2 + " from " + physicalFont3.platName + " with " + physicalFont2.platName);
            }
            FontManager.replaceFont(physicalFont3, physicalFont2);
            physicalFonts.put(string, physicalFont2);
            fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), physicalFont2);
            object = FontFamily.getFamily(string2);
            if (object == null) {
                object = new FontFamily(string2, false, n2);
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            } else if (((FontFamily)object).getRank() >= n2) {
                ((FontFamily)object).setFont(physicalFont2, physicalFont2.style);
            }
            return physicalFont2;
        }
        return physicalFont3;
    }

    public static Font2D[] getRegisteredFonts() {
        PhysicalFont[] physicalFontArray = FontManager.getPhysicalFonts();
        int n2 = maxCompFont;
        Font2D[] font2DArray = new Font2D[physicalFontArray.length + n2];
        System.arraycopy(compFonts, 0, font2DArray, 0, n2);
        System.arraycopy(physicalFontArray, 0, font2DArray, n2, physicalFontArray.length);
        return font2DArray;
    }

    public static PhysicalFont[] getPhysicalFonts() {
        return physicalFonts.values().toArray(new PhysicalFont[0]);
    }

    public static synchronized void initialiseDeferredFonts() {
        String[] stringArray = deferredFontFiles.keySet().toArray(STR_ARRAY);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            FontManager.initialiseDeferredFont(stringArray[i2]);
        }
    }

    private static PhysicalFont findDeferredFont(String string, int n2) {
        PhysicalFont physicalFont;
        String string2 = string.toLowerCase(Locale.ENGLISH) + n2;
        String string3 = jreFontMap.get(string2);
        if (string3 != null) {
            FontManager.initSGEnv();
            string3 = SunGraphicsEnvironment.jreFontDirName + File.separator + string3;
            if (deferredFontFiles.get(string3) != null && (physicalFont = FontManager.initialiseDeferredFont(string3)) != null && (physicalFont.getFontName(null).equals(string) || physicalFont.getFamilyName(null).equals(string)) && physicalFont.style == n2) {
                return physicalFont;
            }
        }
        String[] stringArray = deferredFontFiles.keySet().toArray(STR_ARRAY);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            physicalFont = FontManager.initialiseDeferredFont(stringArray[i2]);
            if (physicalFont == null || !physicalFont.getFontName(null).equals(string) && !physicalFont.getFamilyName(null).equals(string) || physicalFont.style != n2) continue;
            return physicalFont;
        }
        return null;
    }

    public static void registerDeferredFont(String string, String string2, String[] stringArray, int n2, boolean bl2, int n3) {
        FontRegistrationInfo fontRegistrationInfo = new FontRegistrationInfo(string2, stringArray, n2, bl2, n3);
        deferredFontFiles.put(string, fontRegistrationInfo);
    }

    public static synchronized PhysicalFont initialiseDeferredFont(String string) {
        PhysicalFont physicalFont;
        FontRegistrationInfo fontRegistrationInfo;
        if (string == null) {
            return null;
        }
        if (logging) {
            logger.info("Opening deferred font file " + string);
        }
        if ((fontRegistrationInfo = (FontRegistrationInfo)deferredFontFiles.get(string)) != null) {
            deferredFontFiles.remove(string);
            physicalFont = FontManager.registerFontFile(fontRegistrationInfo.fontFilePath, fontRegistrationInfo.nativeNames, fontRegistrationInfo.fontFormat, fontRegistrationInfo.javaRasterizer, fontRegistrationInfo.fontRank);
            if (physicalFont != null) {
                initialisedFonts.put(string, physicalFont.handle);
            } else {
                initialisedFonts.put(string, FontManager.getDefaultPhysicalFont().handle);
            }
        } else {
            Font2DHandle font2DHandle = (Font2DHandle)initialisedFonts.get(string);
            physicalFont = font2DHandle == null ? FontManager.getDefaultPhysicalFont() : (PhysicalFont)font2DHandle.font2D;
        }
        return physicalFont;
    }

    public static PhysicalFont registerFontFile(String string, String[] stringArray, int n2, boolean bl2, int n3) {
        PhysicalFont physicalFont;
        block9: {
            physicalFont = null;
            try {
                switch (n2) {
                    case 0: {
                        TrueTypeFont trueTypeFont;
                        int n4 = 0;
                        do {
                            trueTypeFont = new TrueTypeFont(string, stringArray, n4++, bl2);
                            PhysicalFont physicalFont2 = FontManager.addToFontList(trueTypeFont, n3);
                            if (physicalFont != null) continue;
                            physicalFont = physicalFont2;
                        } while (n4 < trueTypeFont.getFontCount());
                        break;
                    }
                    case 1: {
                        Type1Font type1Font = new Type1Font(string, stringArray);
                        physicalFont = FontManager.addToFontList(type1Font, n3);
                        break;
                    }
                    case 5: {
                        NativeFont nativeFont = new NativeFont(string, false);
                        physicalFont = FontManager.addToFontList(nativeFont, n3);
                    }
                }
                if (logging) {
                    logger.info("Registered file " + string + " as font " + physicalFont + " rank=" + n3);
                }
            }
            catch (FontFormatException fontFormatException) {
                if (!logging) break block9;
                logger.warning("Unusable font: " + string + " " + fontFormatException.toString());
            }
        }
        return physicalFont;
    }

    public static void registerFonts(String[] stringArray, String[][] stringArray2, int n2, int n3, boolean bl2, int n4, boolean bl3) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl3) {
                FontManager.registerDeferredFont(stringArray[i2], stringArray[i2], stringArray2[i2], n3, bl2, n4);
                continue;
            }
            FontManager.registerFontFile(stringArray[i2], stringArray2[i2], n3, bl2, n4);
        }
    }

    public static PhysicalFont getDefaultPhysicalFont() {
        if (defaultPhysicalFont == null) {
            defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Lucida Sans Regular", 0, 0);
            if (defaultPhysicalFont == null) {
                defaultPhysicalFont = (PhysicalFont)FontManager.findFont2D("Arial", 0, 0);
            }
            if (defaultPhysicalFont == null) {
                Iterator iterator = physicalFonts.values().iterator();
                if (iterator.hasNext()) {
                    defaultPhysicalFont = (PhysicalFont)iterator.next();
                } else {
                    throw new Error("Probable fatal error:No fonts found.");
                }
            }
        }
        return defaultPhysicalFont;
    }

    public static CompositeFont getDefaultLogicalFont(int n2) {
        return (CompositeFont)FontManager.findFont2D("dialog", n2, 0);
    }

    private static String dotStyleStr(int n2) {
        switch (n2) {
            case 1: {
                return ".bold";
            }
            case 2: {
                return ".italic";
            }
            case 3: {
                return ".bolditalic";
            }
        }
        return ".plain";
    }

    static void initSGEnv() {
        if (sgEnv == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (graphicsEnvironment instanceof HeadlessGraphicsEnvironment) {
                HeadlessGraphicsEnvironment headlessGraphicsEnvironment = (HeadlessGraphicsEnvironment)graphicsEnvironment;
                sgEnv = (SunGraphicsEnvironment)headlessGraphicsEnvironment.getSunGraphicsEnvironment();
            } else {
                sgEnv = (SunGraphicsEnvironment)graphicsEnvironment;
            }
        }
    }

    public static Font2D findFont2D(String string, int n2, int n3) {
        Object object;
        Object object2;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        String string3 = string2 + FontManager.dotStyleStr(n2);
        Font2D font2D = usingPerAppContextComposites ? ((object2 = (Hashtable)AppContext.getAppContext().get(CompositeFont.class)) != null ? (Font2D)((Hashtable)object2).get(string3) : null) : (Font2D)fontNameCache.get(string3);
        if (font2D != null) {
            return font2D;
        }
        if (isWindows) {
            if (string2.equals("ms sans serif")) {
                string = "sansserif";
            } else if (string2.equals("ms serif")) {
                string = "serif";
            }
        }
        if (string2.equals("default")) {
            string = "dialog";
        }
        if ((object2 = FontFamily.getFamily(string)) != null) {
            font2D = ((FontFamily)object2).getFontWithExactStyleMatch(n2);
            if (font2D == null) {
                font2D = FontManager.findDeferredFont(string, n2);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getFont(n2);
            }
            if (font2D == null) {
                font2D = ((FontFamily)object2).getClosestStyle(n2);
            }
            if (font2D != null) {
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        if ((font2D = (Font2D)fullNameToFont.get(string2)) != null) {
            if (font2D.style == n2 || n2 == 0) {
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            object2 = FontFamily.getFamily(font2D.getFamilyName(null));
            if (object2 != null) {
                object = ((FontFamily)object2).getFont(n2 | font2D.style);
                if (object != null) {
                    fontNameCache.put(string3, object);
                    return object;
                }
                object = ((FontFamily)object2).getClosestStyle(n2 | font2D.style);
                if (object != null && ((Font2D)object).canDoStyle(n2 | font2D.style)) {
                    fontNameCache.put(string3, object);
                    return object;
                }
            }
        }
        if (sgEnv == null) {
            FontManager.initSGEnv();
            return FontManager.findFont2D(string, n2, n3);
        }
        if (deferredFontFiles.size() > 0 && (font2D = FontManager.findDeferredFont(string, n2)) != null) {
            fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (isSolaris && !loaded1dot0Fonts) {
            if (string2.equals("timesroman")) {
                font2D = FontManager.findFont2D("serif", n2, n3);
                fontNameCache.put(string3, font2D);
            }
            sgEnv.register1dot0Fonts();
            loaded1dot0Fonts = true;
            object = FontManager.findFont2D(string, n2, n3);
            return object;
        }
        if (!loadedAllFonts) {
            sgEnv.loadFonts();
            loadedAllFonts = true;
            return FontManager.findFont2D(string, n2, n3);
        }
        font2D = FontManager.findFont2DAllLocales(string, n2);
        if (font2D != null) {
            fontNameCache.put(string3, font2D);
            return font2D;
        }
        if (isWindows) {
            object = sgEnv.getFontConfiguration().getFallbackFamilyName(string, null);
            if (object != null) {
                font2D = FontManager.findFont2D((String)object, n2, n3);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        } else {
            if (string2.equals("timesroman")) {
                font2D = FontManager.findFont2D("serif", n2, n3);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("helvetica")) {
                font2D = FontManager.findFont2D("sansserif", n2, n3);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
            if (string2.equals("courier")) {
                font2D = FontManager.findFont2D("monospaced", n2, n3);
                fontNameCache.put(string3, font2D);
                return font2D;
            }
        }
        switch (n3) {
            case 1: {
                return FontManager.getDefaultPhysicalFont();
            }
            case 2: {
                return FontManager.getDefaultLogicalFont(n2);
            }
        }
        return null;
    }

    public static native Font2D getFont2D(Font var0);

    public static boolean usePlatformFontMetrics() {
        return usePlatformFontMetrics;
    }

    static native boolean getPlatformFontVar();

    public static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        if (lcidMap == null) {
            FontManager.createLCIDMap();
        }
        String string = locale.toString();
        while (!"".equals(string)) {
            Short s2 = (Short)lcidMap.get(string);
            if (s2 != null) {
                return s2;
            }
            int n2 = string.lastIndexOf(95);
            if (n2 < 1) {
                return 1033;
            }
            string = string.substring(0, n2);
        }
        return 1033;
    }

    private static void addLCIDMapEntry(Map map, String string, short s2) {
        map.put(string, new Short(s2));
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap hashMap = new HashMap(200);
        FontManager.addLCIDMapEntry(hashMap, "ar", (short)1025);
        FontManager.addLCIDMapEntry(hashMap, "bg", (short)1026);
        FontManager.addLCIDMapEntry(hashMap, "ca", (short)1027);
        FontManager.addLCIDMapEntry(hashMap, "zh", (short)1028);
        FontManager.addLCIDMapEntry(hashMap, "cs", (short)1029);
        FontManager.addLCIDMapEntry(hashMap, "da", (short)1030);
        FontManager.addLCIDMapEntry(hashMap, "de", (short)1031);
        FontManager.addLCIDMapEntry(hashMap, "el", (short)1032);
        FontManager.addLCIDMapEntry(hashMap, "es", (short)1034);
        FontManager.addLCIDMapEntry(hashMap, "fi", (short)1035);
        FontManager.addLCIDMapEntry(hashMap, "fr", (short)1036);
        FontManager.addLCIDMapEntry(hashMap, "iw", (short)1037);
        FontManager.addLCIDMapEntry(hashMap, "hu", (short)1038);
        FontManager.addLCIDMapEntry(hashMap, "is", (short)1039);
        FontManager.addLCIDMapEntry(hashMap, "it", (short)1040);
        FontManager.addLCIDMapEntry(hashMap, "ja", (short)1041);
        FontManager.addLCIDMapEntry(hashMap, "ko", (short)1042);
        FontManager.addLCIDMapEntry(hashMap, "nl", (short)1043);
        FontManager.addLCIDMapEntry(hashMap, "no", (short)1044);
        FontManager.addLCIDMapEntry(hashMap, "pl", (short)1045);
        FontManager.addLCIDMapEntry(hashMap, "pt", (short)1046);
        FontManager.addLCIDMapEntry(hashMap, "rm", (short)1047);
        FontManager.addLCIDMapEntry(hashMap, "ro", (short)1048);
        FontManager.addLCIDMapEntry(hashMap, "ru", (short)1049);
        FontManager.addLCIDMapEntry(hashMap, "hr", (short)1050);
        FontManager.addLCIDMapEntry(hashMap, "sk", (short)1051);
        FontManager.addLCIDMapEntry(hashMap, "sq", (short)1052);
        FontManager.addLCIDMapEntry(hashMap, "sv", (short)1053);
        FontManager.addLCIDMapEntry(hashMap, "th", (short)1054);
        FontManager.addLCIDMapEntry(hashMap, "tr", (short)1055);
        FontManager.addLCIDMapEntry(hashMap, "in", (short)1057);
        FontManager.addLCIDMapEntry(hashMap, "uk", (short)1058);
        FontManager.addLCIDMapEntry(hashMap, "be", (short)1059);
        FontManager.addLCIDMapEntry(hashMap, "sl", (short)1060);
        FontManager.addLCIDMapEntry(hashMap, "et", (short)1061);
        FontManager.addLCIDMapEntry(hashMap, "lv", (short)1062);
        FontManager.addLCIDMapEntry(hashMap, "lt", (short)1063);
        FontManager.addLCIDMapEntry(hashMap, "fa", (short)1065);
        FontManager.addLCIDMapEntry(hashMap, "vi", (short)1066);
        FontManager.addLCIDMapEntry(hashMap, "hy", (short)1067);
        FontManager.addLCIDMapEntry(hashMap, "eu", (short)1069);
        FontManager.addLCIDMapEntry(hashMap, "mk", (short)1071);
        FontManager.addLCIDMapEntry(hashMap, "tn", (short)1074);
        FontManager.addLCIDMapEntry(hashMap, "af", (short)1078);
        FontManager.addLCIDMapEntry(hashMap, "ka", (short)1079);
        FontManager.addLCIDMapEntry(hashMap, "fo", (short)1080);
        FontManager.addLCIDMapEntry(hashMap, "hi", (short)1081);
        FontManager.addLCIDMapEntry(hashMap, "mt", (short)1082);
        FontManager.addLCIDMapEntry(hashMap, "gd", (short)1084);
        FontManager.addLCIDMapEntry(hashMap, "ms", (short)1086);
        FontManager.addLCIDMapEntry(hashMap, "kk", (short)1087);
        FontManager.addLCIDMapEntry(hashMap, "sw", (short)1089);
        FontManager.addLCIDMapEntry(hashMap, "ta", (short)1097);
        FontManager.addLCIDMapEntry(hashMap, "mr", (short)1102);
        FontManager.addLCIDMapEntry(hashMap, "sa", (short)1103);
        FontManager.addLCIDMapEntry(hashMap, "ar_IQ", (short)2049);
        FontManager.addLCIDMapEntry(hashMap, "zh_CN", (short)2052);
        FontManager.addLCIDMapEntry(hashMap, "de_CH", (short)2055);
        FontManager.addLCIDMapEntry(hashMap, "en_GB", (short)2057);
        FontManager.addLCIDMapEntry(hashMap, "es_MX", (short)2058);
        FontManager.addLCIDMapEntry(hashMap, "fr_BE", (short)2060);
        FontManager.addLCIDMapEntry(hashMap, "it_CH", (short)2064);
        FontManager.addLCIDMapEntry(hashMap, "nl_BE", (short)2067);
        FontManager.addLCIDMapEntry(hashMap, "no_NO_NY", (short)2068);
        FontManager.addLCIDMapEntry(hashMap, "pt_PT", (short)2070);
        FontManager.addLCIDMapEntry(hashMap, "ro_MD", (short)2072);
        FontManager.addLCIDMapEntry(hashMap, "ru_MD", (short)2073);
        FontManager.addLCIDMapEntry(hashMap, "sr_CS", (short)2074);
        FontManager.addLCIDMapEntry(hashMap, "sv_FI", (short)2077);
        FontManager.addLCIDMapEntry(hashMap, "az_AZ", (short)2092);
        FontManager.addLCIDMapEntry(hashMap, "ga_IE", (short)2108);
        FontManager.addLCIDMapEntry(hashMap, "ms_BN", (short)2110);
        FontManager.addLCIDMapEntry(hashMap, "uz_UZ", (short)2115);
        FontManager.addLCIDMapEntry(hashMap, "ar_EG", (short)3073);
        FontManager.addLCIDMapEntry(hashMap, "zh_HK", (short)3076);
        FontManager.addLCIDMapEntry(hashMap, "de_AT", (short)3079);
        FontManager.addLCIDMapEntry(hashMap, "en_AU", (short)3081);
        FontManager.addLCIDMapEntry(hashMap, "fr_CA", (short)3084);
        FontManager.addLCIDMapEntry(hashMap, "sr_CS", (short)3098);
        FontManager.addLCIDMapEntry(hashMap, "ar_LY", (short)4097);
        FontManager.addLCIDMapEntry(hashMap, "zh_SG", (short)4100);
        FontManager.addLCIDMapEntry(hashMap, "de_LU", (short)4103);
        FontManager.addLCIDMapEntry(hashMap, "en_CA", (short)4105);
        FontManager.addLCIDMapEntry(hashMap, "es_GT", (short)4106);
        FontManager.addLCIDMapEntry(hashMap, "fr_CH", (short)4108);
        FontManager.addLCIDMapEntry(hashMap, "ar_DZ", (short)5121);
        FontManager.addLCIDMapEntry(hashMap, "zh_MO", (short)5124);
        FontManager.addLCIDMapEntry(hashMap, "de_LI", (short)5127);
        FontManager.addLCIDMapEntry(hashMap, "en_NZ", (short)5129);
        FontManager.addLCIDMapEntry(hashMap, "es_CR", (short)5130);
        FontManager.addLCIDMapEntry(hashMap, "fr_LU", (short)5132);
        FontManager.addLCIDMapEntry(hashMap, "ar_MA", (short)6145);
        FontManager.addLCIDMapEntry(hashMap, "en_IE", (short)6153);
        FontManager.addLCIDMapEntry(hashMap, "es_PA", (short)6154);
        FontManager.addLCIDMapEntry(hashMap, "fr_MC", (short)6156);
        FontManager.addLCIDMapEntry(hashMap, "ar_TN", (short)7169);
        FontManager.addLCIDMapEntry(hashMap, "en_ZA", (short)7177);
        FontManager.addLCIDMapEntry(hashMap, "es_DO", (short)7178);
        FontManager.addLCIDMapEntry(hashMap, "ar_OM", (short)8193);
        FontManager.addLCIDMapEntry(hashMap, "en_JM", (short)8201);
        FontManager.addLCIDMapEntry(hashMap, "es_VE", (short)8202);
        FontManager.addLCIDMapEntry(hashMap, "ar_YE", (short)9217);
        FontManager.addLCIDMapEntry(hashMap, "es_CO", (short)9226);
        FontManager.addLCIDMapEntry(hashMap, "ar_SY", (short)10241);
        FontManager.addLCIDMapEntry(hashMap, "en_BZ", (short)10249);
        FontManager.addLCIDMapEntry(hashMap, "es_PE", (short)10250);
        FontManager.addLCIDMapEntry(hashMap, "ar_JO", (short)11265);
        FontManager.addLCIDMapEntry(hashMap, "en_TT", (short)11273);
        FontManager.addLCIDMapEntry(hashMap, "es_AR", (short)11274);
        FontManager.addLCIDMapEntry(hashMap, "ar_LB", (short)12289);
        FontManager.addLCIDMapEntry(hashMap, "en_ZW", (short)12297);
        FontManager.addLCIDMapEntry(hashMap, "es_EC", (short)12298);
        FontManager.addLCIDMapEntry(hashMap, "ar_KW", (short)13313);
        FontManager.addLCIDMapEntry(hashMap, "en_PH", (short)13321);
        FontManager.addLCIDMapEntry(hashMap, "es_CL", (short)13322);
        FontManager.addLCIDMapEntry(hashMap, "ar_AE", (short)14337);
        FontManager.addLCIDMapEntry(hashMap, "es_UY", (short)14346);
        FontManager.addLCIDMapEntry(hashMap, "ar_BH", (short)15361);
        FontManager.addLCIDMapEntry(hashMap, "es_PY", (short)15370);
        FontManager.addLCIDMapEntry(hashMap, "ar_QA", (short)16385);
        FontManager.addLCIDMapEntry(hashMap, "es_BO", (short)16394);
        FontManager.addLCIDMapEntry(hashMap, "es_SV", (short)17418);
        FontManager.addLCIDMapEntry(hashMap, "es_HN", (short)18442);
        FontManager.addLCIDMapEntry(hashMap, "es_NI", (short)19466);
        FontManager.addLCIDMapEntry(hashMap, "es_PR", (short)20490);
        lcidMap = hashMap;
    }

    public static int getNumFonts() {
        return physicalFonts.size() + maxCompFont;
    }

    private static boolean fontSupportsEncoding(Font font, String string) {
        return FontManager.getFont2D(font).supportsEncoding(string);
    }

    public static synchronized native String getFontPath(boolean var0);

    public static synchronized native void setNativeFontPath(String var0);

    public static Font2D createFont2D(File file, int n2, boolean bl2) throws FontFormatException {
        String string = file.getPath();
        FileFont fileFont = null;
        final File file2 = file;
        try {
            switch (n2) {
                case 0: {
                    fileFont = new TrueTypeFont(string, null, 0, true);
                    break;
                }
                case 1: {
                    fileFont = new Type1Font(string, null);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException fontFormatException) {
            if (bl2) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        file2.delete();
                        return null;
                    }
                });
            }
            throw fontFormatException;
        }
        if (bl2) {
            fileFont.setFileToRemove(file);
        }
        return fileFont;
    }

    public static synchronized String getFullNameByFileName(String string) {
        PhysicalFont[] physicalFontArray = FontManager.getPhysicalFonts();
        for (int i2 = 0; i2 < physicalFontArray.length; ++i2) {
            if (!physicalFontArray[i2].platName.equals(string)) continue;
            return physicalFontArray[i2].getFontName(null);
        }
        return null;
    }

    public static synchronized void deRegisterBadFont(Font2D font2D) {
        if (!(font2D instanceof PhysicalFont)) {
            return;
        }
        if (logging) {
            logger.severe("Deregister bad font: " + font2D);
        }
        FontManager.replaceFont((PhysicalFont)font2D, FontManager.getDefaultPhysicalFont());
    }

    public static synchronized void replaceFont(PhysicalFont physicalFont, PhysicalFont physicalFont2) {
        if (physicalFont.handle.font2D != physicalFont) {
            return;
        }
        physicalFont.handle.font2D = physicalFont2;
        physicalFonts.remove(physicalFont.fullName);
        fullNameToFont.remove(physicalFont.fullName.toLowerCase(Locale.ENGLISH));
        FontFamily.remove(physicalFont);
        if (localeFullNamesToFont != null) {
            Map.Entry[] entryArray = localeFullNamesToFont.entrySet().toArray(new Map.Entry[0]);
            for (int i2 = 0; i2 < entryArray.length; ++i2) {
                if (entryArray[i2].getValue() != physicalFont) continue;
                try {
                    entryArray[i2].setValue(physicalFont2);
                    continue;
                }
                catch (Exception exception) {
                    localeFullNamesToFont.remove(entryArray[i2].getKey());
                }
            }
        }
        for (int i3 = 0; i3 < maxCompFont; ++i3) {
            if (physicalFont2.getRank() <= 2) continue;
            compFonts[i3].replaceComponentFont(physicalFont, physicalFont2);
        }
    }

    private static synchronized void loadLocaleNames() {
        if (localeFullNamesToFont != null) {
            return;
        }
        localeFullNamesToFont = new HashMap();
        Font2D[] font2DArray = FontManager.getRegisteredFonts();
        for (int i2 = 0; i2 < font2DArray.length; ++i2) {
            if (!(font2DArray[i2] instanceof TrueTypeFont)) continue;
            TrueTypeFont trueTypeFont = (TrueTypeFont)font2DArray[i2];
            String[] stringArray = trueTypeFont.getAllFullNames();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                localeFullNamesToFont.put(stringArray[i3], trueTypeFont);
            }
            FontFamily fontFamily = FontFamily.getFamily(trueTypeFont.familyName);
            if (fontFamily == null) continue;
            FontFamily.addLocaleNames(fontFamily, trueTypeFont.getAllFamilyNames());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font2D findFont2DAllLocales(String string, int n2) {
        if (localeFullNamesToFont == null) {
            FontManager.loadLocaleNames();
        }
        String string2 = string.toLowerCase();
        Font2D font2D = null;
        FontFamily fontFamily = FontFamily.getLocaleFamily(string2);
        if (fontFamily != null) {
            font2D = fontFamily.getFont(n2);
            if (font2D == null) {
                font2D = fontFamily.getClosestStyle(n2);
            }
            if (font2D != null) {
                return font2D;
            }
        }
        Object object = FontManager.class;
        synchronized (FontManager.class) {
            font2D = (Font2D)localeFullNamesToFont.get(string);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (font2D != null) {
                if (font2D.style == n2 || n2 == 0) {
                    return font2D;
                }
                fontFamily = FontFamily.getFamily(font2D.getFamilyName(null));
                if (fontFamily != null) {
                    object = fontFamily.getFont(n2);
                    if (object != null) {
                        return object;
                    }
                    object = fontFamily.getClosestStyle(n2);
                    if (object != null) {
                        if (!((Font2D)object).canDoStyle(n2)) {
                            object = null;
                        }
                        return object;
                    }
                }
            }
            return font2D;
        }
    }

    public static boolean usingAlternateCompositeFonts() {
        return usingAlternateComposites || usingPerAppContextComposites && AppContext.getAppContext().get(CompositeFont.class) != null;
    }

    private static boolean maybeMultiAppContext() {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityManager securityManager = System.getSecurityManager();
                return new Boolean(securityManager instanceof AppletSecurity);
            }
        });
        return bl2;
    }

    public static synchronized void useAlternateFontforJALocales() {
        if (!isWindows) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            gAltJAFont = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            appContext.put(altJAFontKey, altJAFontKey);
        }
    }

    public static boolean usingAlternateFontforJALocales() {
        if (!FontManager.maybeMultiAppContext()) {
            return gAltJAFont;
        }
        AppContext appContext = AppContext.getAppContext();
        return appContext.get(altJAFontKey) == altJAFontKey;
    }

    public static synchronized void preferLocaleFonts() {
        FontManager.initSGEnv();
        if (!FontConfiguration.willReorderForStartupLocale()) {
            return;
        }
        if (!FontManager.maybeMultiAppContext()) {
            if (gLocalePref) {
                return;
            }
            gLocalePref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(localeFontKey) == localeFontKey) {
                return;
            }
            appContext.put(localeFontKey, localeFontKey);
            boolean bl2 = appContext.get(proportionalFontKey) == proportionalFontKey;
            Hashtable hashtable = new Hashtable();
            appContext.put(CompositeFont.class, hashtable);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(hashtable, true, bl2);
        }
    }

    public static synchronized void preferProportionalFonts() {
        if (!FontConfiguration.hasMonoToPropMap()) {
            return;
        }
        FontManager.initSGEnv();
        if (!FontManager.maybeMultiAppContext()) {
            if (gPropPref) {
                return;
            }
            gPropPref = true;
            sgEnv.createCompositeFonts(fontNameCache, gLocalePref, gPropPref);
            usingAlternateComposites = true;
        } else {
            AppContext appContext = AppContext.getAppContext();
            if (appContext.get(proportionalFontKey) == proportionalFontKey) {
                return;
            }
            appContext.put(proportionalFontKey, proportionalFontKey);
            boolean bl2 = appContext.get(localeFontKey) == localeFontKey;
            Hashtable hashtable = new Hashtable();
            appContext.put(CompositeFont.class, hashtable);
            usingPerAppContextComposites = true;
            sgEnv.createCompositeFonts(hashtable, bl2, true);
        }
    }

    static {
        usePlatformFontMetrics = false;
        logger = null;
        loaded1dot0Fonts = false;
        loadedAllFonts = false;
        STR_ARRAY = new String[0];
        if (SunGraphicsEnvironment.debugFonts) {
            logger = Logger.getLogger("sun.java2d", null);
            logging = logger.getLevel() != Level.OFF;
        }
        jreFontMap = new HashMap();
        jreFontMap.put("lucida sans0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans regular0", "LucidaSansRegular.ttf");
        jreFontMap.put("lucida sans regular1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans bold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans demibold1", "LucidaSansDemiBold.ttf");
        jreFontMap.put("lucida sans typewriter0", "LucidaTypewriter.ttf");
        jreFontMap.put("lucida sans typewriter1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter regular0", "LucidaTypewriter.ttf");
        jreFontMap.put("lucida sans typewriter regular1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter bold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida sans typewriter demibold1", "LucidaTypewriterBold.ttf");
        jreFontMap.put("lucida bright0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright regular0", "LucidaBrightRegular.ttf");
        jreFontMap.put("lucida bright regular1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright regular2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright regular3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright bold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold1", "LucidaBrightDemiBold.ttf");
        jreFontMap.put("lucida bright demibold3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright italic2", "LucidaBrightItalic.ttf");
        jreFontMap.put("lucida bright italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright bold italic3", "LucidaBrightDemiItalic.ttf");
        jreFontMap.put("lucida bright demibold italic3", "LucidaBrightDemiItalic.ttf");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("awt");
                System.loadLibrary("fontmanager");
                FontManager.initIDs();
                switch (StrikeCache.nativeAddressSize) {
                    case 8: {
                        longAddresses = true;
                        break;
                    }
                    case 4: {
                        longAddresses = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected address size");
                    }
                }
                osName = System.getProperty("os.name", "unknownOS");
                isSolaris = osName.startsWith("SunOS");
                if (isSolaris) {
                    String string = System.getProperty("sun.java2d.font.scaler");
                    useT2K = "t2k".equals(string);
                    String string2 = System.getProperty("os.version", "unk");
                    isSolaris8 = string2.equals("5.8");
                } else {
                    isWindows = osName.startsWith("Windows");
                    if (isWindows) {
                        String string;
                        String string3 = SunGraphicsEnvironment.eudcFontFileName;
                        if (string3 != null) {
                            try {
                                eudcFont = new TrueTypeFont(string3, null, 0, true);
                            }
                            catch (FontFormatException fontFormatException) {
                                // empty catch block
                            }
                        }
                        if ("true".equals(string = System.getProperty("java2d.font.usePlatformFont")) || FontManager.getPlatformFontVar()) {
                            usePlatformFontMetrics = true;
                            System.out.println("Enabling platform font metrics for win32. This is an unsupported option.");
                            System.out.println("This yields incorrect composite font metrics as reported by 1.1.x releases.");
                            System.out.println("It is appropriate only for use by applications which do not use any Java 2");
                            System.out.println("functionality. This property will be removed in a later release.");
                        }
                    }
                }
                return null;
            }
        });
        deferredFontFiles = new Hashtable();
        initialisedFonts = new Hashtable();
        fontNameCache = new Hashtable(10, 0.75f);
        altJAFontKey = new Object();
        localeFontKey = new Object();
        proportionalFontKey = new Object();
        usingPerAppContextComposites = false;
        usingAlternateComposites = false;
        gAltJAFont = false;
        gLocalePref = false;
        gPropPref = false;
    }

    private static final class FontRegistrationInfo {
        String fontFilePath;
        String[] nativeNames;
        int fontFormat;
        boolean javaRasterizer;
        int fontRank;

        FontRegistrationInfo(String string, String[] stringArray, int n2, boolean bl2, int n3) {
            this.fontFilePath = string;
            this.nativeNames = stringArray;
            this.fontFormat = n2;
            this.javaRasterizer = bl2;
            this.fontRank = n3;
        }
    }
}

