/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLCachingSurfaceManager
extends CachingSurfaceManager
implements DisplayChangedListener {
    private int transparency;

    public WGLCachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        Object object;
        this.transparency = bufferedImage.getColorModel().getTransparency();
        if (accelerationThreshold == 0 && this.localAccelerationEnabled) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedSurface((GraphicsConfiguration)object, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        if ((object = GraphicsEnvironment.getLocalGraphicsEnvironment()) instanceof Win32GraphicsEnvironment) {
            ((Win32GraphicsEnvironment)object).addDisplayChangedListener(this);
        }
    }

    protected SurfaceData getAccelSurface(GraphicsConfiguration graphicsConfiguration) {
        return this.accelSurfaces != null ? (SurfaceData)this.accelSurfaces.get(graphicsConfiguration) : null;
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof WGLSurfaceData;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl2) {
        return surfaceData instanceof WGLSurfaceData && (color == null || this.transparency == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initAcceleratedSurface(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        WGLCachingSurfaceManager wGLCachingSurfaceManager = this;
        synchronized (wGLCachingSurfaceManager) {
            try {
                this.sdAccel = this.getAccelSurface(graphicsConfiguration);
                if (this.sdAccel == null) {
                    if (graphicsConfiguration instanceof WGLGraphicsConfig) {
                        this.sdAccel = this.createAccelSurface(graphicsConfiguration, n2, n3);
                    }
                    if (this.sdAccel != null) {
                        this.accelSurfaces.put(graphicsConfiguration, this.sdAccel);
                    }
                }
            }
            catch (InvalidPipeException invalidPipeException) {
                this.sdAccel = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.sdAccel = null;
            }
        }
    }

    protected SurfaceData createAccelSurface(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        return WGLSurfaceData.createData((WGLGraphicsConfig)graphicsConfiguration, n2, n3, graphicsConfiguration.getColorModel(), this.bImg, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        WGLCachingSurfaceManager wGLCachingSurfaceManager = this;
        synchronized (wGLCachingSurfaceManager) {
            if (this.sdAccel != null) {
                Hashtable hashtable = this.accelSurfaces;
                this.sdAccel = null;
                this.accelSurfaces = new Hashtable();
                if (hashtable != null) {
                    Object[] objectArray = hashtable.values().toArray();
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        ((SurfaceData)objectArray[i2]).invalidate();
                    }
                }
            }
        }
    }

    public void paletteChanged() {
        this.sdDefault.setNeedsBackup(true);
    }

    public synchronized void flush() {
        this.sdAccel = null;
        if (this.accelSurfaces != null) {
            Hashtable hashtable = this.accelSurfaces;
            this.accelSurfaces = new Hashtable();
            Object[] objectArray = hashtable.values().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ((WGLSurfaceData)objectArray[i2]).flush();
            }
        }
    }

    public String toString() {
        return new String("WGLCachingSurfaceManager@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }
}

