/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.WGLGraphicsConfig;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLVolatileSurfaceManager
extends VolatileSurfaceManager
implements DisplayChangedListener {
    private boolean accelerationEnabled;

    public WGLVolatileSurfaceManager(SunVolatileImage sunVolatileImage, Object object) {
        super(sunVolatileImage, object);
        this.accelerationEnabled = sunVolatileImage.getTransparency() == 1;
        Win32GraphicsEnvironment win32GraphicsEnvironment = (Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        win32GraphicsEnvironment.addDisplayChangedListener(this);
    }

    protected boolean isAccelerationEnabled() {
        return this.accelerationEnabled;
    }

    protected SurfaceData initAcceleratedSurface() {
        WGLSurfaceData.WGLOffScreenSurfaceData wGLOffScreenSurfaceData;
        Component component = this.vImg.getComponent();
        WComponentPeer wComponentPeer = component != null ? (WComponentPeer)component.getPeer() : null;
        try {
            boolean bl2 = false;
            if (this.context instanceof Boolean) {
                bl2 = (Boolean)this.context;
            }
            if (bl2) {
                wGLOffScreenSurfaceData = WGLSurfaceData.createData(wComponentPeer, true);
            } else {
                WGLGraphicsConfig wGLGraphicsConfig = (WGLGraphicsConfig)this.vImg.getGraphicsConfig();
                ColorModel colorModel = wGLGraphicsConfig.getColorModel();
                wGLOffScreenSurfaceData = WGLSurfaceData.createData(wGLGraphicsConfig, this.vImg.getWidth(), this.vImg.getHeight(), colorModel, this.vImg, 3);
            }
        }
        catch (NullPointerException nullPointerException) {
            wGLOffScreenSurfaceData = null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            wGLOffScreenSurfaceData = null;
        }
        return wGLOffScreenSurfaceData;
    }

    protected boolean isConfigValid(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration == null || graphicsConfiguration == this.vImg.getGraphicsConfig();
    }

    public void flush() {
        this.lostSurface = true;
        WGLSurfaceData wGLSurfaceData = (WGLSurfaceData)this.sdAccel;
        this.sdAccel = null;
        if (wGLSurfaceData != null) {
            wGLSurfaceData.flush();
        }
    }

    public void displayChanged() {
        if (!this.isAccelerationEnabled()) {
            return;
        }
        this.lostSurface = true;
        if (this.sdAccel != null) {
            this.sdBackup = null;
            this.sdCurrent = this.getBackupSurface();
            SurfaceData surfaceData = this.sdAccel;
            this.sdAccel = null;
            surfaceData.invalidate();
        }
        this.vImg.updateGraphicsConfig();
    }

    public void paletteChanged() {
        this.lostSurface = true;
    }

    public ImageCapabilities getCapabilities() {
        if (this.isAccelerationEnabled() && !(this.imageCaps instanceof WGLImageCaps)) {
            this.imageCaps = new WGLImageCaps();
        }
        return super.getCapabilities();
    }

    private class WGLImageCaps
    extends VolatileSurfaceManager.DefaultImageCapabilities {
        private WGLImageCaps() {
            super(WGLVolatileSurfaceManager.this);
        }

        public boolean isTrueVolatile() {
            return this.isAccelerated();
        }
    }
}

